/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.io.connection.impl;

import net.kuujo.vertigo.io.connection.ConnectionOutputBatch;
import net.kuujo.vertigo.io.connection.OutputConnection;
import net.kuujo.vertigo.io.connection.impl.DefaultConnectionOutputGroup;
import net.kuujo.vertigo.io.connection.impl.DefaultOutputConnection;
import net.kuujo.vertigo.io.group.OutputGroup;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.VoidHandler;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.json.JsonArray;
import org.vertx.java.core.json.JsonObject;

public class DefaultConnectionOutputBatch
implements ConnectionOutputBatch {
    private final String id;
    private final DefaultOutputConnection connection;
    private Handler<ConnectionOutputBatch> startHandler;
    private Handler<Void> endHandler;
    private int children;
    private boolean started;
    private boolean ended;
    private boolean closed;

    public DefaultConnectionOutputBatch(String id, DefaultOutputConnection connection) {
        this.id = id;
        this.connection = connection;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String address() {
        return this.connection.address();
    }

    @Override
    public int size() {
        return this.connection.size();
    }

    @Override
    public OutputConnection open() {
        this.connection.open((Handler)null);
        return this;
    }

    @Override
    public OutputConnection open(Handler<AsyncResult<Void>> doneHandler) {
        this.connection.open((Handler)doneHandler);
        return this;
    }

    @Override
    public void close() {
        this.connection.close(null);
    }

    @Override
    public void close(Handler<AsyncResult<Void>> doneHandler) {
        this.connection.close(doneHandler);
    }

    @Override
    public Vertx vertx() {
        return this.connection.vertx();
    }

    @Override
    public OutputConnection setSendQueueMaxSize(int maxSize) {
        this.connection.setSendQueueMaxSize(maxSize);
        return this;
    }

    @Override
    public int getSendQueueMaxSize() {
        return this.connection.getSendQueueMaxSize();
    }

    @Override
    public boolean sendQueueFull() {
        return this.connection.sendQueueFull();
    }

    @Override
    public OutputConnection drainHandler(Handler<Void> handler) {
        this.connection.drainHandler((Handler)handler);
        return this;
    }

    private void checkEnd() {
        if (this.ended && !this.closed && this.children == 0) {
            this.closed = true;
            this.connection.doBatchEnd(this.id);
            if (this.endHandler != null) {
                this.endHandler.handle((Object)null);
            }
        }
    }

    void endHandler(Handler<Void> handler) {
        this.endHandler = handler;
        if (this.closed) {
            this.endHandler.handle((Object)null);
        }
    }

    void start(Handler<ConnectionOutputBatch> startHandler) {
        this.connection.doBatchStart(this.id);
        this.startHandler = startHandler;
    }

    void handleStart() {
        if (!this.started && this.startHandler != null) {
            this.startHandler.handle((Object)this);
            this.started = true;
        }
    }

    @Override
    public OutputConnection send(Object message) {
        if (!this.ended) {
            this.connection.doBatchSend(this.id, message);
        }
        return this;
    }

    @Override
    public OutputConnection send(String message) {
        if (!this.ended) {
            this.connection.doBatchSend(this.id, message);
        }
        return this;
    }

    @Override
    public OutputConnection send(Short message) {
        if (!this.ended) {
            this.connection.doBatchSend(this.id, message);
        }
        return this;
    }

    @Override
    public OutputConnection send(Integer message) {
        if (!this.ended) {
            this.connection.doBatchSend(this.id, message);
        }
        return this;
    }

    @Override
    public OutputConnection send(Long message) {
        if (!this.ended) {
            this.connection.doBatchSend(this.id, message);
        }
        return this;
    }

    @Override
    public OutputConnection send(Float message) {
        if (!this.ended) {
            this.connection.doBatchSend(this.id, message);
        }
        return this;
    }

    @Override
    public OutputConnection send(Double message) {
        if (!this.ended) {
            this.connection.doBatchSend(this.id, message);
        }
        return this;
    }

    @Override
    public OutputConnection send(Boolean message) {
        if (!this.ended) {
            this.connection.doBatchSend(this.id, message);
        }
        return this;
    }

    @Override
    public OutputConnection send(Byte message) {
        if (!this.ended) {
            this.connection.doBatchSend(this.id, message);
        }
        return this;
    }

    @Override
    public OutputConnection send(byte[] message) {
        if (!this.ended) {
            this.connection.doBatchSend(this.id, message);
        }
        return this;
    }

    @Override
    public OutputConnection send(Character message) {
        if (!this.ended) {
            this.connection.doBatchSend(this.id, message);
        }
        return this;
    }

    @Override
    public OutputConnection send(Buffer message) {
        if (!this.ended) {
            this.connection.doBatchSend(this.id, message);
        }
        return this;
    }

    @Override
    public OutputConnection send(JsonArray message) {
        if (!this.ended) {
            this.connection.doBatchSend(this.id, message);
        }
        return this;
    }

    @Override
    public OutputConnection send(JsonObject message) {
        if (!this.ended) {
            this.connection.doBatchSend(this.id, message);
        }
        return this;
    }

    @Override
    public OutputConnection batch(String id, Handler<ConnectionOutputBatch> handler) {
        throw new UnsupportedOperationException("Cannot batch a batch.");
    }

    @Override
    public OutputConnection group(String name, Handler<OutputGroup> handler) {
        DefaultConnectionOutputGroup group = this.connection.group(name, this.id, handler);
        ++this.children;
        group.endHandler((Handler<Void>)new VoidHandler(){

            protected void handle() {
                DefaultConnectionOutputBatch.this.children--;
                DefaultConnectionOutputBatch.this.checkEnd();
            }
        });
        return this;
    }

    @Override
    public void end() {
        this.ended = true;
        this.checkEnd();
    }
}

