/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.io.connection.impl;

import java.util.HashMap;
import java.util.Map;
import net.kuujo.vertigo.io.connection.ConnectionInputGroup;
import net.kuujo.vertigo.io.connection.impl.DefaultInputConnection;
import net.kuujo.vertigo.io.group.InputGroup;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;

public class DefaultConnectionInputGroup
implements ConnectionInputGroup {
    private final String id;
    private final String name;
    private final DefaultInputConnection connection;
    private Handler messageHandler;
    private Handler<Void> startHandler;
    private Handler<Void> endHandler;
    private final Map<String, Handler<InputGroup>> groupHandlers = new HashMap<String, Handler<InputGroup>>();
    private boolean started;

    public DefaultConnectionInputGroup(String id, String name, DefaultInputConnection connection) {
        this.id = id;
        this.name = name;
        this.connection = connection;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Vertx vertx() {
        return this.connection.vertx();
    }

    @Override
    public InputGroup pause() {
        this.connection.pause();
        return this;
    }

    @Override
    public InputGroup resume() {
        this.connection.resume();
        return this;
    }

    void handleMessage(Object message) {
        if (this.messageHandler != null) {
            this.messageHandler.handle(message);
        }
    }

    @Override
    public InputGroup messageHandler(Handler handler) {
        this.messageHandler = handler;
        if (!this.started && handler != null) {
            this.connection.groupReady(this.id);
            this.started = true;
        }
        return this;
    }

    void handleGroup(InputGroup group) {
        Handler<InputGroup> handler = this.groupHandlers.get(group.name());
        if (handler != null) {
            handler.handle((Object)group);
        } else {
            this.connection.groupReady(group.id());
        }
    }

    @Override
    public InputGroup groupHandler(String group, Handler<InputGroup> handler) {
        if (handler != null) {
            this.groupHandlers.put(group, handler);
            if (!this.started) {
                this.connection.groupReady(this.id);
                this.started = true;
            }
        } else {
            this.groupHandlers.remove(group);
        }
        return this;
    }

    void handleStart() {
        if (this.startHandler != null) {
            this.startHandler.handle(null);
        }
    }

    @Override
    public InputGroup startHandler(Handler<Void> handler) {
        this.startHandler = handler;
        return this;
    }

    void handleEnd() {
        if (this.endHandler != null) {
            this.endHandler.handle(null);
        }
    }

    @Override
    public InputGroup endHandler(Handler<Void> handler) {
        this.endHandler = handler;
        return this;
    }
}

