/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.io.batch.impl;

import java.util.ArrayList;
import java.util.Collection;
import net.kuujo.vertigo.io.batch.OutputBatch;
import net.kuujo.vertigo.io.group.OutputGroup;
import net.kuujo.vertigo.io.group.impl.BaseOutputGroup;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.json.JsonArray;
import org.vertx.java.core.json.JsonObject;

public class BaseOutputBatch
implements OutputBatch {
    private final String id;
    private final Vertx vertx;
    private final Collection<OutputBatch> connections;

    public BaseOutputBatch(String id, Vertx vertx, Collection<OutputBatch> connections) {
        this.id = id;
        this.vertx = vertx;
        this.connections = connections;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public Vertx vertx() {
        return this.vertx;
    }

    @Override
    public OutputBatch setSendQueueMaxSize(int maxSize) {
        for (OutputBatch group : this.connections) {
            group.setSendQueueMaxSize(maxSize);
        }
        return this;
    }

    @Override
    public int getSendQueueMaxSize() {
        int maxSize = 0;
        for (OutputBatch group : this.connections) {
            maxSize += group.getSendQueueMaxSize();
        }
        return maxSize;
    }

    @Override
    public int size() {
        int highest = 0;
        for (OutputBatch group : this.connections) {
            highest = Math.max(highest, group.size());
        }
        return highest;
    }

    @Override
    public boolean sendQueueFull() {
        for (OutputBatch group : this.connections) {
            if (!group.sendQueueFull()) continue;
            return true;
        }
        return false;
    }

    @Override
    public OutputBatch drainHandler(Handler<Void> handler) {
        for (OutputBatch group : this.connections) {
            group.drainHandler(handler);
        }
        return this;
    }

    @Override
    public OutputBatch group(final String name, final Handler<OutputGroup> handler) {
        final ArrayList<OutputGroup> groups = new ArrayList<OutputGroup>();
        final int connectionsSize = this.connections.size();
        if (connectionsSize == 0) {
            handler.handle((Object)new BaseOutputGroup(name, this.vertx, groups));
        } else {
            for (OutputBatch connection : this.connections) {
                connection.group(name, new Handler<OutputGroup>(){

                    public void handle(OutputGroup group) {
                        groups.add(group);
                        if (groups.size() == connectionsSize) {
                            handler.handle((Object)new BaseOutputGroup(name, BaseOutputBatch.this.vertx, groups));
                        }
                    }
                });
            }
        }
        return this;
    }

    @Override
    public OutputBatch send(Object message) {
        for (OutputBatch output : this.connections) {
            output.send(message);
        }
        return this;
    }

    @Override
    public OutputBatch send(String message) {
        for (OutputBatch output : this.connections) {
            output.send(message);
        }
        return this;
    }

    @Override
    public OutputBatch send(Boolean message) {
        for (OutputBatch output : this.connections) {
            output.send(message);
        }
        return this;
    }

    @Override
    public OutputBatch send(Character message) {
        for (OutputBatch output : this.connections) {
            output.send(message);
        }
        return this;
    }

    @Override
    public OutputBatch send(Short message) {
        for (OutputBatch output : this.connections) {
            output.send(message);
        }
        return this;
    }

    @Override
    public OutputBatch send(Integer message) {
        for (OutputBatch output : this.connections) {
            output.send(message);
        }
        return this;
    }

    @Override
    public OutputBatch send(Long message) {
        for (OutputBatch output : this.connections) {
            output.send(message);
        }
        return this;
    }

    @Override
    public OutputBatch send(Double message) {
        for (OutputBatch output : this.connections) {
            output.send(message);
        }
        return this;
    }

    @Override
    public OutputBatch send(Float message) {
        for (OutputBatch output : this.connections) {
            output.send(message);
        }
        return this;
    }

    @Override
    public OutputBatch send(Buffer message) {
        for (OutputBatch output : this.connections) {
            output.send(message);
        }
        return this;
    }

    @Override
    public OutputBatch send(JsonObject message) {
        for (OutputBatch output : this.connections) {
            output.send(message);
        }
        return this;
    }

    @Override
    public OutputBatch send(JsonArray message) {
        for (OutputBatch output : this.connections) {
            output.send(message);
        }
        return this;
    }

    @Override
    public OutputBatch send(Byte message) {
        for (OutputBatch output : this.connections) {
            output.send(message);
        }
        return this;
    }

    @Override
    public OutputBatch send(byte[] message) {
        for (OutputBatch output : this.connections) {
            output.send(message);
        }
        return this;
    }

    @Override
    public void end() {
        for (OutputBatch output : this.connections) {
            output.end();
        }
    }
}

