/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.hook;

import net.kuujo.vertigo.component.InstanceContext;
import net.kuujo.vertigo.component.impl.DefaultInstanceContext;
import org.vertx.java.core.Handler;
import org.vertx.java.core.eventbus.EventBus;
import org.vertx.java.core.eventbus.Message;
import org.vertx.java.core.json.JsonObject;

public class EventBusHookListener {
    private final String componentAddress;
    private final EventBus eventBus;

    public EventBusHookListener(String componentAddress, EventBus eventBus) {
        this.componentAddress = componentAddress;
        this.eventBus = eventBus;
        this.registerHandler();
    }

    private void registerHandler() {
    }

    public EventBusHookListener startHandler(final Handler<InstanceContext> startHandler) {
        this.eventBus.registerHandler(String.format("vertigo.hooks.%s.start", this.componentAddress), (Handler)new Handler<Message<JsonObject>>(){

            public void handle(Message<JsonObject> message) {
                JsonObject body = (JsonObject)message.body();
                if (body != null) {
                    startHandler.handle((Object)DefaultInstanceContext.fromJson(body));
                }
            }
        });
        return this;
    }

    public EventBusHookListener receiveHandler(final Handler receiveHandler) {
        this.eventBus.registerHandler(String.format("vertigo.hooks.%s.receive", this.componentAddress), (Handler)new Handler<Message<Object>>(){

            public void handle(Message<Object> message) {
                receiveHandler.handle(message.body());
            }
        });
        return this;
    }

    public EventBusHookListener emitHandler(final Handler sendHandler) {
        this.eventBus.registerHandler(String.format("vertigo.hooks.%s.emit", this.componentAddress), (Handler)new Handler<Message<Object>>(){

            public void handle(Message<Object> message) {
                sendHandler.handle(message.body());
            }
        });
        return this;
    }

    public EventBusHookListener stopHandler(final Handler<InstanceContext> stopHandler) {
        this.eventBus.registerHandler(String.format("vertigo.hooks.%s.stop", this.componentAddress), (Handler)new Handler<Message<JsonObject>>(){

            public void handle(Message<JsonObject> message) {
                JsonObject body = (JsonObject)message.body();
                if (body != null) {
                    stopHandler.handle((Object)DefaultInstanceContext.fromJson(body));
                }
            }
        });
        return this;
    }
}

