/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.hook;

import com.fasterxml.jackson.annotation.JsonIgnore;
import net.kuujo.vertigo.component.Component;
import net.kuujo.vertigo.component.InstanceContext;
import net.kuujo.vertigo.component.impl.DefaultInstanceContext;
import net.kuujo.vertigo.hook.ComponentHook;
import org.vertx.java.core.eventbus.EventBus;

public class EventBusHook
implements ComponentHook {
    @JsonIgnore
    private InstanceContext context;
    @JsonIgnore
    private EventBus eventBus;
    @JsonIgnore
    private String address;

    @Override
    public void handleStart(Component component) {
        this.eventBus = component.vertx().eventBus();
        this.context = component.context();
        this.address = component.context().component().address();
        this.eventBus.publish(String.format("vertigo.hooks.%s.start", this.address), DefaultInstanceContext.toJson(this.context));
    }

    @Override
    public void handleSend(Object message) {
        this.eventBus.publish(String.format("vertigo.hooks.%s.send", this.address), message);
    }

    @Override
    public void handleReceive(Object message) {
        this.eventBus.publish(String.format("vertigo.hooks.%s.receive", this.address), message);
    }

    @Override
    public void handleStop(Component subject) {
        this.eventBus.publish(String.format("vertigo.hooks.%s.stop", this.address), DefaultInstanceContext.toJson(this.context));
    }
}

