/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.cluster.impl;

import java.util.ArrayList;
import java.util.Collection;
import net.kuujo.vertigo.Config;
import net.kuujo.vertigo.cluster.ClusterManager;
import net.kuujo.vertigo.cluster.ClusterManagerException;
import net.kuujo.vertigo.network.ActiveNetwork;
import net.kuujo.vertigo.network.NetworkConfig;
import net.kuujo.vertigo.network.NetworkContext;
import net.kuujo.vertigo.network.impl.DefaultActiveNetwork;
import net.kuujo.vertigo.network.impl.DefaultNetworkConfig;
import net.kuujo.vertigo.network.impl.DefaultNetworkContext;
import net.kuujo.vertigo.util.Configs;
import net.kuujo.vertigo.util.CountingCompletionHandler;
import net.kuujo.vertigo.util.serialization.SerializerFactory;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.eventbus.Message;
import org.vertx.java.core.impl.DefaultFutureResult;
import org.vertx.java.core.json.JsonArray;
import org.vertx.java.core.json.JsonObject;
import org.vertx.java.platform.Container;
import org.vertx.java.platform.Verticle;

public class DefaultClusterManager
implements ClusterManager {
    private static final String DEFAULT_CLUSTER_ADDRESS = "vertigo";
    private static final long DEFAULT_REPLY_TIMEOUT = 30000L;
    private final String address;
    private final Vertx vertx;

    public DefaultClusterManager(Verticle verticle) {
        this(DEFAULT_CLUSTER_ADDRESS, verticle.getVertx(), verticle.getContainer());
    }

    public DefaultClusterManager(String address, Verticle verticle) {
        this(address, verticle.getVertx(), verticle.getContainer());
    }

    public DefaultClusterManager(Vertx vertx, Container container) {
        this(DEFAULT_CLUSTER_ADDRESS, vertx, container);
    }

    public DefaultClusterManager(String address, Vertx vertx, Container container) {
        this.address = address;
        this.vertx = vertx;
    }

    @Override
    public String address() {
        return this.address;
    }

    @Override
    public ClusterManager getNetworks(final Handler<AsyncResult<Collection<ActiveNetwork>>> resultHandler) {
        JsonObject message = new JsonObject().putString("action", "list").putString("type", "network");
        this.vertx.eventBus().sendWithTimeout(this.address, message, 30000L, (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

            public void handle(AsyncResult<Message<JsonObject>> result) {
                if (result.failed()) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterManagerException(result.cause()))).setHandler(resultHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("error")) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterManagerException(((JsonObject)((Message)result.result()).body()).getString("message")))).setHandler(resultHandler);
                } else {
                    final ArrayList networks = new ArrayList();
                    JsonArray jsonNetworks = ((JsonObject)((Message)result.result()).body()).getArray("result");
                    final CountingCompletionHandler<Void> counter = new CountingCompletionHandler<Void>(jsonNetworks.size());
                    counter.setHandler(new Handler<AsyncResult<Void>>(){

                        public void handle(AsyncResult<Void> result) {
                            if (result.failed()) {
                                new DefaultFutureResult(result.cause()).setHandler(resultHandler);
                            } else {
                                new DefaultFutureResult((Object)networks).setHandler(resultHandler);
                            }
                        }
                    });
                    for (Object jsonNetwork : jsonNetworks) {
                        DefaultClusterManager.this.createActiveNetwork(DefaultNetworkContext.fromJson((JsonObject)jsonNetwork), (Handler<AsyncResult<ActiveNetwork>>)((Handler)new Handler<AsyncResult<ActiveNetwork>>(){

                            public void handle(AsyncResult<ActiveNetwork> result) {
                                if (result.failed()) {
                                    counter.fail(result.cause());
                                } else {
                                    networks.add(result.result());
                                    counter.succeed();
                                }
                            }
                        }));
                    }
                }
            }
        });
        return this;
    }

    @Override
    public ClusterManager getNetwork(String name, final Handler<AsyncResult<ActiveNetwork>> resultHandler) {
        JsonObject message = new JsonObject().putString("action", "load").putString("type", "network").putString("network", name);
        this.vertx.eventBus().sendWithTimeout(this.address, message, 30000L, (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

            public void handle(AsyncResult<Message<JsonObject>> result) {
                if (result.failed()) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterManagerException(result.cause()))).setHandler(resultHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("error")) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterManagerException(((JsonObject)((Message)result.result()).body()).getString("message")))).setHandler(resultHandler);
                } else {
                    DefaultClusterManager.this.createActiveNetwork(DefaultNetworkContext.fromJson(((JsonObject)((Message)result.result()).body()).getObject("result")), (Handler<AsyncResult<ActiveNetwork>>)resultHandler);
                }
            }
        });
        return this;
    }

    @Override
    public ClusterManager isDeployed(String name, final Handler<AsyncResult<Boolean>> resultHandler) {
        JsonObject message = new JsonObject().putString("action", "check").putString("type", "network").putString("network", name);
        this.vertx.eventBus().sendWithTimeout(this.address, message, 30000L, (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

            public void handle(AsyncResult<Message<JsonObject>> result) {
                if (result.failed()) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterManagerException(result.cause()))).setHandler(resultHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("error")) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterManagerException(((JsonObject)((Message)result.result()).body()).getString("message")))).setHandler(resultHandler);
                } else {
                    new DefaultFutureResult((Object)((JsonObject)((Message)result.result()).body()).getBoolean("result")).setHandler(resultHandler);
                }
            }
        });
        return this;
    }

    @Override
    public ClusterManager deployNetwork(String name) {
        return this.deployNetwork(name, null);
    }

    @Override
    public ClusterManager deployNetwork(String name, Handler<AsyncResult<ActiveNetwork>> doneHandler) {
        return this.deployNetwork(new DefaultNetworkConfig(name), doneHandler);
    }

    @Override
    public ClusterManager deployNetwork(JsonObject network) {
        return this.deployNetwork(network, null);
    }

    @Override
    public ClusterManager deployNetwork(JsonObject network, Handler<AsyncResult<ActiveNetwork>> doneHandler) {
        return this.deployNetwork(Configs.createNetwork(network), doneHandler);
    }

    @Override
    public ClusterManager deployNetwork(NetworkConfig network) {
        return this.deployNetwork(network, null);
    }

    @Override
    public ClusterManager deployNetwork(NetworkConfig network, final Handler<AsyncResult<ActiveNetwork>> doneHandler) {
        JsonObject message = new JsonObject().putString("action", "deploy").putString("type", "network").putObject("network", SerializerFactory.getSerializer(Config.class).serializeToObject(network));
        this.vertx.eventBus().sendWithTimeout(this.address, message, 30000L, (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

            public void handle(AsyncResult<Message<JsonObject>> result) {
                if (result.failed()) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterManagerException(result.cause()))).setHandler(doneHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("error")) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterManagerException(((JsonObject)((Message)result.result()).body()).getString("message")))).setHandler(doneHandler);
                } else {
                    DefaultClusterManager.this.createActiveNetwork(DefaultNetworkContext.fromJson(((JsonObject)((Message)result.result()).body()).getObject("context")), (Handler<AsyncResult<ActiveNetwork>>)doneHandler);
                }
            }
        });
        return this;
    }

    @Override
    public ClusterManager undeployNetwork(String name) {
        return this.undeployNetwork(name, null);
    }

    @Override
    public ClusterManager undeployNetwork(String name, final Handler<AsyncResult<Void>> doneHandler) {
        JsonObject message = new JsonObject().putString("action", "undeploy").putString("type", "network").putString("network", name);
        this.vertx.eventBus().sendWithTimeout(this.address, message, 30000L, (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

            public void handle(AsyncResult<Message<JsonObject>> result) {
                if (result.failed()) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterManagerException(result.cause()))).setHandler(doneHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("error")) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterManagerException(((JsonObject)((Message)result.result()).body()).getString("message")))).setHandler(doneHandler);
                } else {
                    new DefaultFutureResult((Object)null).setHandler(doneHandler);
                }
            }
        });
        return this;
    }

    @Override
    public ClusterManager undeployNetwork(JsonObject network) {
        return this.undeployNetwork(network, null);
    }

    @Override
    public ClusterManager undeployNetwork(JsonObject network, Handler<AsyncResult<Void>> doneHandler) {
        return this.undeployNetwork(Configs.createNetwork(network), doneHandler);
    }

    @Override
    public ClusterManager undeployNetwork(NetworkConfig network) {
        return this.undeployNetwork(network, null);
    }

    @Override
    public ClusterManager undeployNetwork(NetworkConfig network, final Handler<AsyncResult<Void>> doneHandler) {
        JsonObject message = new JsonObject().putString("action", "undeploy").putString("type", "network").putObject("network", SerializerFactory.getSerializer(Config.class).serializeToObject(network));
        this.vertx.eventBus().sendWithTimeout(this.address, message, 30000L, (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

            public void handle(AsyncResult<Message<JsonObject>> result) {
                if (result.failed()) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterManagerException(result.cause()))).setHandler(doneHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("error")) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterManagerException(((JsonObject)((Message)result.result()).body()).getString("message")))).setHandler(doneHandler);
                } else {
                    new DefaultFutureResult((Object)null).setHandler(doneHandler);
                }
            }
        });
        return this;
    }

    private void createActiveNetwork(NetworkContext context, final Handler<AsyncResult<ActiveNetwork>> doneHandler) {
        final DefaultActiveNetwork active = new DefaultActiveNetwork(context.config(), this);
        this.vertx.eventBus().registerHandler(String.format("%s.%s.change", context.name(), context.name()), (Handler)new Handler<Message<JsonObject>>(){

            public void handle(Message<JsonObject> message) {
                String event = ((JsonObject)message.body()).getString("type");
                if (event.equals("change") && ((JsonObject)message.body()).getString("value") != null) {
                    active.update(DefaultNetworkContext.fromJson(new JsonObject(((JsonObject)message.body()).getString("value"))));
                }
            }
        }, (Handler)new Handler<AsyncResult<Void>>(){

            public void handle(AsyncResult<Void> result) {
                if (result.failed()) {
                    new DefaultFutureResult((Throwable)((Object)new ClusterManagerException(result.cause()))).setHandler(doneHandler);
                } else {
                    new DefaultFutureResult((Object)active).setHandler(doneHandler);
                }
            }
        });
    }

    public boolean equals(Object other) {
        return other instanceof ClusterManager && ((ClusterManager)other).address().equals(this.address);
    }

    public String toString() {
        return this.address;
    }
}

