/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.cluster.impl;

import java.util.HashMap;
import java.util.Map;
import net.kuujo.vertigo.cluster.Cluster;
import net.kuujo.vertigo.cluster.DeploymentException;
import net.kuujo.vertigo.cluster.data.AsyncCounter;
import net.kuujo.vertigo.cluster.data.AsyncList;
import net.kuujo.vertigo.cluster.data.AsyncMap;
import net.kuujo.vertigo.cluster.data.AsyncQueue;
import net.kuujo.vertigo.cluster.data.AsyncSet;
import net.kuujo.vertigo.cluster.data.impl.DefaultAsyncCounter;
import net.kuujo.vertigo.cluster.data.impl.DefaultAsyncList;
import net.kuujo.vertigo.cluster.data.impl.DefaultAsyncMap;
import net.kuujo.vertigo.cluster.data.impl.DefaultAsyncQueue;
import net.kuujo.vertigo.cluster.data.impl.DefaultAsyncSet;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.eventbus.Message;
import org.vertx.java.core.impl.DefaultFutureResult;
import org.vertx.java.core.json.JsonObject;
import org.vertx.java.platform.Container;
import org.vertx.java.platform.Verticle;

public class DefaultCluster
implements Cluster {
    private static final String DEFAULT_CLUSTER_ADDRESS = "vertigo";
    private final String address;
    private final Vertx vertx;
    private final Map<String, AsyncMap> maps = new HashMap<String, AsyncMap>();
    private final Map<String, AsyncList> lists = new HashMap<String, AsyncList>();
    private final Map<String, AsyncQueue> queues = new HashMap<String, AsyncQueue>();
    private final Map<String, AsyncSet> sets = new HashMap<String, AsyncSet>();
    private final Map<String, AsyncCounter> counters = new HashMap<String, AsyncCounter>();

    public DefaultCluster(Verticle verticle) {
        this(DEFAULT_CLUSTER_ADDRESS, verticle);
    }

    public DefaultCluster(Vertx vertx, Container container) {
        this(DEFAULT_CLUSTER_ADDRESS, vertx, container);
    }

    public DefaultCluster(String address, Verticle verticle) {
        this(address, verticle.getVertx(), verticle.getContainer());
    }

    public DefaultCluster(String address, Vertx vertx, Container container) {
        this.address = address;
        this.vertx = vertx;
    }

    @Override
    public String address() {
        return this.address;
    }

    @Override
    public Cluster isDeployed(String deploymentID, final Handler<AsyncResult<Boolean>> resultHandler) {
        JsonObject message = new JsonObject().putString("action", "check").putString("id", deploymentID);
        this.vertx.eventBus().sendWithTimeout(this.address, message, 30000L, (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

            public void handle(AsyncResult<Message<JsonObject>> result) {
                if (result.failed()) {
                    new DefaultFutureResult(result.cause()).setHandler(resultHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("ok")) {
                    new DefaultFutureResult((Object)((JsonObject)((Message)result.result()).body()).getBoolean("result")).setHandler(resultHandler);
                } else {
                    new DefaultFutureResult((Throwable)((Object)new DeploymentException(((JsonObject)((Message)result.result()).body()).getString("message")))).setHandler(resultHandler);
                }
            }
        });
        return this;
    }

    @Override
    public Cluster deployModule(String deploymentID, String moduleName) {
        return this.deployModuleTo(deploymentID, null, moduleName, null, 1, null);
    }

    @Override
    public Cluster deployModule(String deploymentID, String moduleName, JsonObject config) {
        return this.deployModuleTo(deploymentID, null, moduleName, config, 1, null);
    }

    @Override
    public Cluster deployModule(String deploymentID, String moduleName, int instances) {
        return this.deployModuleTo(deploymentID, null, moduleName, null, instances, null);
    }

    @Override
    public Cluster deployModule(String deploymentID, String moduleName, JsonObject config, int instances) {
        return this.deployModuleTo(deploymentID, null, moduleName, config, instances, null);
    }

    @Override
    public Cluster deployModule(String deploymentID, String moduleName, Handler<AsyncResult<String>> doneHandler) {
        return this.deployModuleTo(deploymentID, null, moduleName, null, 1, doneHandler);
    }

    @Override
    public Cluster deployModule(String deploymentID, String moduleName, JsonObject config, Handler<AsyncResult<String>> doneHandler) {
        return this.deployModuleTo(deploymentID, null, moduleName, config, 1, doneHandler);
    }

    @Override
    public Cluster deployModule(String deploymentID, String moduleName, int instances, Handler<AsyncResult<String>> doneHandler) {
        return this.deployModuleTo(deploymentID, null, moduleName, null, instances, doneHandler);
    }

    @Override
    public Cluster deployModule(String deploymentID, String moduleName, JsonObject config, int instances, Handler<AsyncResult<String>> doneHandler) {
        return this.deployModuleTo(deploymentID, null, moduleName, config, instances, doneHandler);
    }

    @Override
    public Cluster deployModule(String deploymentID, String moduleName, JsonObject config, int instances, boolean ha, Handler<AsyncResult<String>> doneHandler) {
        return this.deployModuleTo(deploymentID, null, moduleName, config, instances, ha, doneHandler);
    }

    @Override
    public Cluster deployModuleTo(String deploymentID, String groupID, String moduleName) {
        return this.deployModuleTo(deploymentID, groupID, moduleName, null, 1, null);
    }

    @Override
    public Cluster deployModuleTo(String deploymentID, String groupID, String moduleName, JsonObject config) {
        return this.deployModuleTo(deploymentID, groupID, moduleName, config, 1, null);
    }

    @Override
    public Cluster deployModuleTo(String deploymentID, String groupID, String moduleName, int instances) {
        return this.deployModuleTo(deploymentID, groupID, moduleName, null, instances, null);
    }

    @Override
    public Cluster deployModuleTo(String deploymentID, String groupID, String moduleName, JsonObject config, int instances) {
        return this.deployModuleTo(deploymentID, groupID, moduleName, config, instances, null);
    }

    @Override
    public Cluster deployModuleTo(String deploymentID, String groupID, String moduleName, Handler<AsyncResult<String>> doneHandler) {
        return this.deployModuleTo(deploymentID, groupID, moduleName, null, 1, doneHandler);
    }

    @Override
    public Cluster deployModuleTo(String deploymentID, String groupID, String moduleName, JsonObject config, Handler<AsyncResult<String>> doneHandler) {
        return this.deployModuleTo(deploymentID, groupID, moduleName, config, 1, doneHandler);
    }

    @Override
    public Cluster deployModuleTo(String deploymentID, String groupID, String moduleName, int instances, Handler<AsyncResult<String>> doneHandler) {
        return this.deployModuleTo(deploymentID, groupID, moduleName, null, instances, doneHandler);
    }

    @Override
    public Cluster deployModuleTo(String deploymentID, String groupID, String moduleName, JsonObject config, int instances, Handler<AsyncResult<String>> doneHandler) {
        return this.deployModuleTo(deploymentID, groupID, moduleName, config, instances, false, doneHandler);
    }

    @Override
    public Cluster deployModuleTo(String deploymentID, String groupID, String moduleName, JsonObject config, int instances, boolean ha, final Handler<AsyncResult<String>> doneHandler) {
        JsonObject message = new JsonObject().putString("action", "deploy").putString("id", deploymentID).putString("group", groupID).putString("type", "module").putString("module", moduleName).putObject("config", config).putNumber("instances", (Number)instances).putBoolean("ha", Boolean.valueOf(ha));
        this.vertx.eventBus().sendWithTimeout(this.address, message, 30000L, (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

            public void handle(AsyncResult<Message<JsonObject>> result) {
                if (result.failed()) {
                    new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("ok")) {
                    new DefaultFutureResult((Object)((JsonObject)((Message)result.result()).body()).getString("id")).setHandler(doneHandler);
                } else {
                    new DefaultFutureResult((Throwable)((Object)new DeploymentException(((JsonObject)((Message)result.result()).body()).getString("message")))).setHandler(doneHandler);
                }
            }
        });
        return this;
    }

    @Override
    public Cluster deployVerticle(String deploymentID, String main) {
        return this.deployVerticleTo(deploymentID, null, main, null, 1, null);
    }

    @Override
    public Cluster deployVerticle(String deploymentID, String main, JsonObject config) {
        return this.deployVerticleTo(deploymentID, null, main, config, 1, null);
    }

    @Override
    public Cluster deployVerticle(String deploymentID, String main, int instances) {
        return this.deployVerticleTo(deploymentID, null, main, null, instances, null);
    }

    @Override
    public Cluster deployVerticle(String deploymentID, String main, JsonObject config, int instances) {
        return this.deployVerticleTo(deploymentID, null, main, config, instances, null);
    }

    @Override
    public Cluster deployVerticle(String deploymentID, String main, Handler<AsyncResult<String>> doneHandler) {
        return this.deployVerticleTo(deploymentID, null, main, null, 1, doneHandler);
    }

    @Override
    public Cluster deployVerticle(String deploymentID, String main, JsonObject config, Handler<AsyncResult<String>> doneHandler) {
        return this.deployVerticleTo(deploymentID, null, main, config, 1, doneHandler);
    }

    @Override
    public Cluster deployVerticle(String deploymentID, String main, int instances, Handler<AsyncResult<String>> doneHandler) {
        return this.deployVerticleTo(deploymentID, null, main, null, instances, doneHandler);
    }

    @Override
    public Cluster deployVerticle(String deploymentID, String main, JsonObject config, int instances, Handler<AsyncResult<String>> doneHandler) {
        return this.deployVerticleTo(deploymentID, null, main, config, instances, doneHandler);
    }

    @Override
    public Cluster deployVerticle(String deploymentID, String main, JsonObject config, int instances, boolean ha, Handler<AsyncResult<String>> doneHandler) {
        return this.deployVerticleTo(deploymentID, null, main, config, instances, ha, doneHandler);
    }

    @Override
    public Cluster deployVerticleTo(String deploymentID, String groupID, String main) {
        return this.deployVerticleTo(deploymentID, groupID, main, null, 1, null);
    }

    @Override
    public Cluster deployVerticleTo(String deploymentID, String groupID, String main, JsonObject config) {
        return this.deployVerticleTo(deploymentID, groupID, main, config, 1, null);
    }

    @Override
    public Cluster deployVerticleTo(String deploymentID, String groupID, String main, int instances) {
        return this.deployVerticleTo(deploymentID, groupID, main, null, instances, null);
    }

    @Override
    public Cluster deployVerticleTo(String deploymentID, String groupID, String main, JsonObject config, int instances) {
        return this.deployVerticleTo(deploymentID, groupID, main, config, instances, null);
    }

    @Override
    public Cluster deployVerticleTo(String deploymentID, String groupID, String main, Handler<AsyncResult<String>> doneHandler) {
        return this.deployVerticleTo(deploymentID, groupID, main, null, 1, doneHandler);
    }

    @Override
    public Cluster deployVerticleTo(String deploymentID, String groupID, String main, JsonObject config, Handler<AsyncResult<String>> doneHandler) {
        return this.deployVerticleTo(deploymentID, groupID, main, config, 1, doneHandler);
    }

    @Override
    public Cluster deployVerticleTo(String deploymentID, String groupID, String main, int instances, Handler<AsyncResult<String>> doneHandler) {
        return this.deployVerticleTo(deploymentID, groupID, main, null, instances, doneHandler);
    }

    @Override
    public Cluster deployVerticleTo(String deploymentID, String groupID, String main, JsonObject config, int instances, Handler<AsyncResult<String>> doneHandler) {
        return this.deployVerticleTo(deploymentID, groupID, main, config, instances, false, doneHandler);
    }

    @Override
    public Cluster deployVerticleTo(String deploymentID, String groupID, String main, JsonObject config, int instances, boolean ha, final Handler<AsyncResult<String>> doneHandler) {
        JsonObject message = new JsonObject().putString("action", "deploy").putString("id", deploymentID).putString("group", groupID).putString("type", "verticle").putString("main", main).putObject("config", config).putNumber("instances", (Number)instances).putBoolean("ha", Boolean.valueOf(ha));
        this.vertx.eventBus().sendWithTimeout(this.address, message, 30000L, (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

            public void handle(AsyncResult<Message<JsonObject>> result) {
                if (result.failed()) {
                    new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("ok")) {
                    new DefaultFutureResult((Object)((JsonObject)((Message)result.result()).body()).getString("id")).setHandler(doneHandler);
                } else {
                    new DefaultFutureResult((Throwable)((Object)new DeploymentException(((JsonObject)((Message)result.result()).body()).getString("message")))).setHandler(doneHandler);
                }
            }
        });
        return this;
    }

    @Override
    public Cluster deployWorkerVerticle(String deploymentID, String main) {
        return this.deployWorkerVerticleTo(deploymentID, null, main, null, 1, false, null);
    }

    @Override
    public Cluster deployWorkerVerticle(String deploymentID, String main, JsonObject config) {
        return this.deployWorkerVerticleTo(deploymentID, null, main, config, 1, false, null);
    }

    @Override
    public Cluster deployWorkerVerticle(String deploymentID, String main, int instances) {
        return this.deployWorkerVerticleTo(deploymentID, null, main, null, instances, false, null);
    }

    @Override
    public Cluster deployWorkerVerticle(String deploymentID, String main, JsonObject config, int instances, boolean multiThreaded) {
        return this.deployWorkerVerticleTo(deploymentID, null, main, config, instances, multiThreaded, null);
    }

    @Override
    public Cluster deployWorkerVerticle(String deploymentID, String main, Handler<AsyncResult<String>> doneHandler) {
        return this.deployWorkerVerticleTo(deploymentID, null, main, null, 1, false, doneHandler);
    }

    @Override
    public Cluster deployWorkerVerticle(String deploymentID, String main, JsonObject config, Handler<AsyncResult<String>> doneHandler) {
        return this.deployWorkerVerticleTo(deploymentID, null, main, config, 1, false, doneHandler);
    }

    @Override
    public Cluster deployWorkerVerticle(String deploymentID, String main, int instances, Handler<AsyncResult<String>> doneHandler) {
        return this.deployWorkerVerticleTo(deploymentID, null, main, null, instances, false, doneHandler);
    }

    @Override
    public Cluster deployWorkerVerticle(String deploymentID, String main, JsonObject config, int instances, boolean multiThreaded, Handler<AsyncResult<String>> doneHandler) {
        return this.deployWorkerVerticleTo(deploymentID, null, main, config, instances, multiThreaded, doneHandler);
    }

    @Override
    public Cluster deployWorkerVerticle(String deploymentID, String main, JsonObject config, int instances, boolean multiThreaded, boolean ha, Handler<AsyncResult<String>> doneHandler) {
        return this.deployWorkerVerticleTo(deploymentID, null, main, config, instances, multiThreaded, ha, doneHandler);
    }

    @Override
    public Cluster deployWorkerVerticleTo(String deploymentID, String groupID, String main) {
        return this.deployWorkerVerticleTo(deploymentID, groupID, main, null, 1, false, null);
    }

    @Override
    public Cluster deployWorkerVerticleTo(String deploymentID, String groupID, String main, JsonObject config) {
        return this.deployWorkerVerticleTo(deploymentID, groupID, main, config, 1, false, null);
    }

    @Override
    public Cluster deployWorkerVerticleTo(String deploymentID, String groupID, String main, int instances) {
        return this.deployWorkerVerticleTo(deploymentID, groupID, main, null, instances, false, null);
    }

    @Override
    public Cluster deployWorkerVerticleTo(String deploymentID, String groupID, String main, JsonObject config, int instances, boolean multiThreaded) {
        return this.deployWorkerVerticleTo(deploymentID, groupID, main, config, instances, multiThreaded, null);
    }

    @Override
    public Cluster deployWorkerVerticleTo(String deploymentID, String groupID, String main, Handler<AsyncResult<String>> doneHandler) {
        return this.deployWorkerVerticleTo(deploymentID, groupID, main, null, 1, false, doneHandler);
    }

    @Override
    public Cluster deployWorkerVerticleTo(String deploymentID, String groupID, String main, JsonObject config, Handler<AsyncResult<String>> doneHandler) {
        return this.deployWorkerVerticleTo(deploymentID, groupID, main, config, 1, false, doneHandler);
    }

    @Override
    public Cluster deployWorkerVerticleTo(String deploymentID, String groupID, String main, int instances, Handler<AsyncResult<String>> doneHandler) {
        return this.deployWorkerVerticleTo(deploymentID, groupID, main, null, instances, false, doneHandler);
    }

    @Override
    public Cluster deployWorkerVerticleTo(String deploymentID, String groupID, String main, JsonObject config, int instances, boolean multiThreaded, Handler<AsyncResult<String>> doneHandler) {
        return this.deployWorkerVerticleTo(deploymentID, groupID, main, config, instances, multiThreaded, false, doneHandler);
    }

    @Override
    public Cluster deployWorkerVerticleTo(String deploymentID, String groupID, String main, JsonObject config, int instances, boolean multiThreaded, boolean ha, final Handler<AsyncResult<String>> doneHandler) {
        JsonObject message = new JsonObject().putString("action", "deploy").putString("id", deploymentID).putString("group", groupID).putString("type", "verticle").putString("main", main).putObject("config", config).putNumber("instances", (Number)instances).putBoolean("worker", Boolean.valueOf(true)).putBoolean("multi-threaded", Boolean.valueOf(multiThreaded)).putBoolean("ha", Boolean.valueOf(ha));
        this.vertx.eventBus().sendWithTimeout(this.address, message, 30000L, (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

            public void handle(AsyncResult<Message<JsonObject>> result) {
                if (result.failed()) {
                    new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("ok")) {
                    new DefaultFutureResult((Object)((JsonObject)((Message)result.result()).body()).getString("id")).setHandler(doneHandler);
                } else {
                    new DefaultFutureResult((Throwable)((Object)new DeploymentException(((JsonObject)((Message)result.result()).body()).getString("message")))).setHandler(doneHandler);
                }
            }
        });
        return this;
    }

    @Override
    public Cluster undeployModule(String deploymentID) {
        return this.undeployModule(deploymentID, null);
    }

    @Override
    public Cluster undeployModule(String deploymentID, final Handler<AsyncResult<Void>> doneHandler) {
        JsonObject message = new JsonObject().putString("action", "undeploy").putString("id", deploymentID).putString("type", "module");
        this.vertx.eventBus().sendWithTimeout(this.address, message, 30000L, (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

            public void handle(AsyncResult<Message<JsonObject>> result) {
                if (result.failed()) {
                    new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("ok")) {
                    new DefaultFutureResult((Object)null).setHandler(doneHandler);
                } else {
                    new DefaultFutureResult((Throwable)((Object)new DeploymentException(((JsonObject)((Message)result.result()).body()).getString("message")))).setHandler(doneHandler);
                }
            }
        });
        return this;
    }

    @Override
    public Cluster undeployVerticle(String deploymentID) {
        return this.undeployVerticle(deploymentID, null);
    }

    @Override
    public Cluster undeployVerticle(String deploymentID, final Handler<AsyncResult<Void>> doneHandler) {
        JsonObject message = new JsonObject().putString("action", "undeploy").putString("id", deploymentID).putString("type", "verticle");
        this.vertx.eventBus().sendWithTimeout(this.address, message, 30000L, (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

            public void handle(AsyncResult<Message<JsonObject>> result) {
                if (result.failed()) {
                    new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                } else if (((JsonObject)((Message)result.result()).body()).getString("status").equals("ok")) {
                    new DefaultFutureResult((Object)null).setHandler(doneHandler);
                } else {
                    new DefaultFutureResult((Throwable)((Object)new DeploymentException(((JsonObject)((Message)result.result()).body()).getString("message")))).setHandler(doneHandler);
                }
            }
        });
        return this;
    }

    @Override
    public <K, V> AsyncMap<K, V> getMap(String name) {
        DefaultAsyncMap map = this.maps.get(name);
        if (map == null) {
            map = new DefaultAsyncMap(this.address, name, this.vertx);
            this.maps.put(name, map);
        }
        return map;
    }

    @Override
    public <T> AsyncList<T> getList(String name) {
        DefaultAsyncList list = this.lists.get(name);
        if (list == null) {
            list = new DefaultAsyncList(this.address, name, this.vertx);
            this.lists.put(name, list);
        }
        return list;
    }

    @Override
    public <T> AsyncSet<T> getSet(String name) {
        DefaultAsyncSet set = this.sets.get(name);
        if (set == null) {
            set = new DefaultAsyncSet(this.address, name, this.vertx);
            this.sets.put(name, set);
        }
        return set;
    }

    @Override
    public <T> AsyncQueue<T> getQueue(String name) {
        DefaultAsyncQueue queue = this.queues.get(name);
        if (queue == null) {
            queue = new DefaultAsyncQueue(this.address, name, this.vertx);
            this.queues.put(name, queue);
        }
        return queue;
    }

    @Override
    public AsyncCounter getCounter(String name) {
        AsyncCounter counter = this.counters.get(name);
        if (counter == null) {
            counter = new DefaultAsyncCounter(this.address, name, this.vertx);
            this.counters.put(name, counter);
        }
        return counter;
    }

    public boolean equals(Object other) {
        return other instanceof Cluster && ((Cluster)other).address().equals(this.address);
    }

    public String toString() {
        return this.address;
    }
}

