/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.cluster.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.kuujo.vertigo.Config;
import net.kuujo.vertigo.cluster.data.MapEvent;
import net.kuujo.vertigo.impl.ContextBuilder;
import net.kuujo.vertigo.network.NetworkConfig;
import net.kuujo.vertigo.network.NetworkContext;
import net.kuujo.vertigo.network.impl.DefaultNetworkConfig;
import net.kuujo.vertigo.network.impl.DefaultNetworkContext;
import net.kuujo.vertigo.network.manager.NetworkManager;
import net.kuujo.vertigo.util.Configs;
import net.kuujo.vertigo.util.CountingCompletionHandler;
import net.kuujo.vertigo.util.serialization.SerializationException;
import net.kuujo.vertigo.util.serialization.Serializer;
import net.kuujo.vertigo.util.serialization.SerializerFactory;
import net.kuujo.xync.Xync;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.eventbus.EventBus;
import org.vertx.java.core.eventbus.Message;
import org.vertx.java.core.impl.DefaultFutureResult;
import org.vertx.java.core.json.JsonArray;
import org.vertx.java.core.json.JsonObject;

public class ClusterAgent
extends Xync {
    private static final Serializer configSerializer = SerializerFactory.getSerializer(Config.class);

    protected void handleClusterMessage(Message<JsonObject> message) {
        String action = ((JsonObject)message.body()).getString("action");
        if (action != null) {
            switch (action) {
                case "list": {
                    if (((JsonObject)message.body()).containsField("type") && ((JsonObject)message.body()).getString("type").equals("network")) {
                        this.doListNetworks(message);
                        break;
                    }
                    super.handleClusterMessage(message);
                    break;
                }
                case "check": {
                    if (((JsonObject)message.body()).containsField("type") && ((JsonObject)message.body()).getString("type").equals("network")) {
                        this.doIsDeployedNetwork(message);
                        break;
                    }
                    super.handleClusterMessage(message);
                    break;
                }
                case "load": {
                    if (((JsonObject)message.body()).containsField("type") && ((JsonObject)message.body()).getString("type").equals("network")) {
                        this.doLoadNetwork(message);
                        break;
                    }
                    super.handleClusterMessage(message);
                    break;
                }
                case "deploy": {
                    if (((JsonObject)message.body()).containsField("type") && ((JsonObject)message.body()).getString("type").equals("network")) {
                        this.doDeployNetwork(message);
                        break;
                    }
                    super.handleClusterMessage(message);
                    break;
                }
                case "undeploy": {
                    if (((JsonObject)message.body()).containsField("type") && ((JsonObject)message.body()).getString("type").equals("network")) {
                        this.doUndeployNetwork(message);
                        break;
                    }
                    super.handleClusterMessage(message);
                    break;
                }
                default: {
                    super.handleClusterMessage(message);
                }
            }
        }
    }

    protected void handleNodeMessage(Message<JsonObject> message) {
        String action = ((JsonObject)message.body()).getString("action");
        if (action != null) {
            switch (action) {
                case "list": {
                    if (((JsonObject)message.body()).containsField("type") && ((JsonObject)message.body()).getString("type").equals("network")) {
                        this.doListNetworks(message);
                        break;
                    }
                    super.handleClusterMessage(message);
                    break;
                }
                case "check": {
                    if (((JsonObject)message.body()).containsField("type") && ((JsonObject)message.body()).getString("type").equals("network")) {
                        this.doIsDeployedNetwork(message);
                        break;
                    }
                    super.handleNodeMessage(message);
                    break;
                }
                case "load": {
                    if (((JsonObject)message.body()).containsField("type") && ((JsonObject)message.body()).getString("type").equals("network")) {
                        this.doLoadNetwork(message);
                        break;
                    }
                    super.handleNodeMessage(message);
                    break;
                }
                case "deploy": {
                    if (((JsonObject)message.body()).containsField("type") && ((JsonObject)message.body()).getString("type").equals("network")) {
                        this.doDeployNetwork(message);
                        break;
                    }
                    super.handleNodeMessage(message);
                    break;
                }
                case "undeploy": {
                    if (((JsonObject)message.body()).containsField("type") && ((JsonObject)message.body()).getString("type").equals("network")) {
                        this.doUndeployNetwork(message);
                        break;
                    }
                    super.handleNodeMessage(message);
                    break;
                }
                default: {
                    super.handleNodeMessage(message);
                }
            }
        }
    }

    private void doIsDeployedNetwork(final Message<JsonObject> message) {
        String network = ((JsonObject)message.body()).getString("network");
        if (network == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No network name specified."));
        } else {
            String scontext = (String)this.manager.getMap(String.format("%s.%s", this.cluster, network)).get(String.format("%s.%s", this.cluster, network));
            if (scontext == null) {
                message.reply(new JsonObject().putString("status", "ok").putBoolean("result", Boolean.valueOf(false)));
            } else {
                DefaultNetworkContext context = DefaultNetworkContext.fromJson(new JsonObject(scontext));
                this.platform.isDeployed(context.address(), (Handler)new Handler<AsyncResult<Boolean>>(){

                    public void handle(AsyncResult<Boolean> result) {
                        if (result.failed()) {
                            message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                        } else {
                            message.reply(new JsonObject().putString("status", "ok").putBoolean("result", (Boolean)result.result()));
                        }
                    }
                });
            }
        }
    }

    private void doListNetworks(Message<JsonObject> message) {
        Set networks = this.manager.getSet(String.format("cluster.%s.networks", this.cluster));
        JsonArray results = new JsonArray();
        for (String network : networks) {
            String scontext = (String)this.manager.getMap(String.format("%s.%s", this.cluster, network)).get(String.format("%s.%s", this.cluster, network));
            if (scontext == null) continue;
            results.add((Object)new JsonObject(scontext));
        }
        message.reply(new JsonObject().putString("status", "ok").putArray("result", results));
    }

    private void doLoadNetwork(Message<JsonObject> message) {
        String network = ((JsonObject)message.body()).getString("network");
        if (network == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No network name specified."));
        } else {
            String scontext = (String)this.manager.getMap(String.format("%s.%s", this.cluster, network)).get(String.format("%s.%s", this.cluster, network));
            if (scontext == null) {
                message.reply(new JsonObject().putString("status", "error").putString("message", "Network not deployed."));
            } else {
                message.reply(new JsonObject().putString("status", "ok").putObject("result", new JsonObject(scontext)));
            }
        }
    }

    private void doDeployNetwork(Message<JsonObject> message) {
        Object network = ((JsonObject)message.body()).getValue("network");
        if (network != null) {
            if (network instanceof String) {
                this.doDeployNetwork((String)network, message);
            } else if (network instanceof JsonObject) {
                JsonObject jsonNetwork = (JsonObject)network;
                try {
                    NetworkConfig config = configSerializer.deserializeObject(jsonNetwork, NetworkConfig.class);
                    this.doDeployNetwork(config, message);
                }
                catch (SerializationException e) {
                    message.reply(new JsonObject().putString("status", "error").putString("message", e.getMessage()));
                }
            } else {
                message.reply(new JsonObject().putString("status", "error").putString("message", "Invalid network configuration."));
            }
        } else {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No network specified."));
        }
    }

    private void doDeployNetwork(String name, Message<JsonObject> message) {
        this.doDeployNetwork(new DefaultNetworkConfig(name), message);
    }

    private void doDeployNetwork(NetworkConfig network, final Message<JsonObject> message) {
        String scontext = (String)this.manager.getMap(String.format("%s.%s", this.cluster, network.getName())).get(String.format("%s.%s", this.cluster, network.getName()));
        NetworkContext updatedContext = scontext != null ? ContextBuilder.buildContext(Configs.mergeNetworks(DefaultNetworkContext.fromJson(new JsonObject(scontext)).config(), network), this.cluster) : ContextBuilder.buildContext(network, this.cluster);
        final NetworkContext context = updatedContext;
        this.platform.isDeployed(context.address(), (Handler)new Handler<AsyncResult<Boolean>>(){

            public void handle(AsyncResult<Boolean> result) {
                if (result.failed()) {
                    message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                } else if (((Boolean)result.result()).booleanValue()) {
                    ClusterAgent.this.doDeployNetwork(context, (Message<JsonObject>)message);
                } else {
                    ClusterAgent.this.platform.deployVerticleAs(context.address(), NetworkManager.class.getName(), new JsonObject().putString("cluster", ClusterAgent.this.address).putString("address", context.address()), 1, true, (Handler)new Handler<AsyncResult<String>>(){

                        public void handle(AsyncResult<String> result) {
                            if (result.failed()) {
                                message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                            } else {
                                ClusterAgent.this.manager.getSet(String.format("cluster.%s.networks", ClusterAgent.this.cluster)).add(context.name());
                                ClusterAgent.this.doDeployNetwork(context, (Message<JsonObject>)message);
                            }
                        }
                    });
                }
            }
        });
    }

    private void doDeployNetwork(final NetworkContext context, final Message<JsonObject> message) {
        final WrappedWatchableMap<String, String> data = new WrappedWatchableMap<String, String>(context.address(), this.manager.getMap(context.address()), this.vertx);
        data.watch(context.status(), null, new Handler<MapEvent<String, String>>(){

            public void handle(MapEvent<String, String> event) {
                if (event.type().equals((Object)MapEvent.Type.CREATE) && event.value().equals(context.version())) {
                    data.unwatch(context.status(), null, this, new Handler<AsyncResult<Void>>(){

                        public void handle(AsyncResult<Void> result) {
                            message.reply(new JsonObject().putString("status", "ok").putObject("context", DefaultNetworkContext.toJson(context)));
                        }
                    });
                }
            }
        }, new Handler<AsyncResult<Void>>(){

            public void handle(AsyncResult<Void> result) {
                if (result.failed()) {
                    message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                } else {
                    try {
                        data.put(context.address(), DefaultNetworkContext.toJson(context).encode());
                    }
                    catch (Exception e) {
                        message.reply(new JsonObject().putString("status", "error").putString("message", e.getMessage()));
                    }
                }
            }
        });
    }

    private void doUndeployNetwork(Message<JsonObject> message) {
        Object network = ((JsonObject)message.body()).getValue("network");
        if (network != null) {
            if (network instanceof String) {
                this.doUndeployNetwork((String)network, message);
            } else if (network instanceof JsonObject) {
                JsonObject jsonNetwork = (JsonObject)network;
                try {
                    NetworkConfig config = configSerializer.deserializeObject(jsonNetwork, NetworkConfig.class);
                    this.doUndeployNetwork(config, message);
                }
                catch (SerializationException e) {
                    message.reply(new JsonObject().putString("status", "error").putString("message", e.getMessage()));
                }
            } else {
                message.reply(new JsonObject().putString("status", "error").putString("message", "Invalid network configuration."));
            }
        } else {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No network specified."));
        }
    }

    private void doUndeployNetwork(String name, final Message<JsonObject> message) {
        final WrappedWatchableMap data = new WrappedWatchableMap(String.format("%s.%s", this.cluster, name), this.manager.getMap(String.format("%s.%s", this.cluster, name)), this.vertx);
        String scontext = (String)data.get(String.format("%s.%s", this.cluster, name));
        if (scontext == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "Network is not deployed."));
        } else {
            final DefaultNetworkContext context = DefaultNetworkContext.fromJson(new JsonObject(scontext));
            this.platform.isDeployed(context.address(), (Handler)new Handler<AsyncResult<Boolean>>(){

                public void handle(AsyncResult<Boolean> result) {
                    if (result.failed()) {
                        message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                    } else if (!((Boolean)result.result()).booleanValue()) {
                        message.reply(new JsonObject().putString("status", "error").putString("message", "Network is not deployed."));
                    } else {
                        data.watch(context.status(), MapEvent.Type.CHANGE, new Handler<MapEvent<String, String>>(){

                            public void handle(MapEvent<String, String> event) {
                                if (event.value() != null && event.value().equals("")) {
                                    data.unwatch(context.status(), MapEvent.Type.CHANGE, this, new Handler<AsyncResult<Void>>(){

                                        public void handle(AsyncResult<Void> result) {
                                            ClusterAgent.this.platform.undeployVerticleAs(context.address(), (Handler)new Handler<AsyncResult<Void>>(){

                                                public void handle(AsyncResult<Void> result) {
                                                    if (result.failed()) {
                                                        message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                                                    } else {
                                                        ClusterAgent.this.manager.getSet(String.format("cluster.%s.networks", ClusterAgent.this.cluster)).remove(context.name());
                                                        data.remove(context.status());
                                                        message.reply(new JsonObject().putString("status", "ok"));
                                                    }
                                                }
                                            });
                                        }
                                    });
                                }
                            }
                        }, new Handler<AsyncResult<Void>>(){

                            public void handle(AsyncResult<Void> result) {
                                if (result.failed()) {
                                    message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                                } else {
                                    data.remove(context.address());
                                }
                            }
                        });
                    }
                }
            });
        }
    }

    private void doUndeployNetwork(final NetworkConfig network, final Message<JsonObject> message) {
        final WrappedWatchableMap data = new WrappedWatchableMap(String.format("%s.%s", this.cluster, network.getName()), this.manager.getMap(String.format("%s.%s", this.cluster, network.getName())), this.vertx);
        String scontext = (String)data.get(String.format("%s.%s", this.cluster, network.getName()));
        if (scontext == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "Network is not deployed."));
        } else {
            final DefaultNetworkContext context = DefaultNetworkContext.fromJson(new JsonObject(scontext));
            this.platform.isDeployed(context.address(), (Handler)new Handler<AsyncResult<Boolean>>(){

                public void handle(AsyncResult<Boolean> result) {
                    if (result.failed()) {
                        message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                    } else if (!((Boolean)result.result()).booleanValue()) {
                        message.reply(new JsonObject().putString("status", "error").putString("message", "Network is not deployed."));
                    } else {
                        NetworkConfig updatedConfig = Configs.unmergeNetworks(context.config(), network);
                        final NetworkContext context2 = ContextBuilder.buildContext(updatedConfig, ClusterAgent.this.cluster);
                        if (context2.components().isEmpty()) {
                            data.watch(context2.status(), MapEvent.Type.CHANGE, new Handler<MapEvent<String, String>>(){

                                public void handle(MapEvent<String, String> event) {
                                    if (event.value() != null && event.value().equals("")) {
                                        data.unwatch(context2.status(), MapEvent.Type.CHANGE, this, new Handler<AsyncResult<Void>>(){

                                            public void handle(AsyncResult<Void> result) {
                                                ClusterAgent.this.platform.undeployVerticleAs(context2.address(), (Handler)new Handler<AsyncResult<Void>>(){

                                                    public void handle(AsyncResult<Void> result) {
                                                        if (result.failed()) {
                                                            message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                                                        } else {
                                                            data.remove(context2.status());
                                                            message.reply(new JsonObject().putString("status", "ok"));
                                                        }
                                                    }
                                                });
                                            }
                                        });
                                    }
                                }
                            }, new Handler<AsyncResult<Void>>(){

                                public void handle(AsyncResult<Void> result) {
                                    if (result.failed()) {
                                        message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                                    } else {
                                        data.remove(context2.address());
                                    }
                                }
                            });
                        } else {
                            data.watch(context2.status(), MapEvent.Type.CHANGE, new Handler<MapEvent<String, String>>(){

                                public void handle(MapEvent<String, String> event) {
                                    if (event.value() != null && event.value().equals(context2.version())) {
                                        data.unwatch(context2.status(), null, this, new Handler<AsyncResult<Void>>(){

                                            public void handle(AsyncResult<Void> result) {
                                                message.reply(new JsonObject().putString("status", "ok").putObject("context", DefaultNetworkContext.toJson(context2)));
                                            }
                                        });
                                    }
                                }
                            }, new Handler<AsyncResult<Void>>(){

                                public void handle(AsyncResult<Void> result) {
                                    if (result.failed()) {
                                        message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                                    } else {
                                        data.put(context2.address(), DefaultNetworkContext.toJson(context2).encode());
                                    }
                                }
                            });
                        }
                    }
                }
            });
        }
    }

    private static class WrappedWatchableMap<K, V>
    implements Map<K, V> {
        private final String name;
        private final Map<K, V> map;
        private final EventBus eventBus;
        private final Map<MapEvent.Type, Map<Handler<MapEvent<K, V>>, Handler<Message<JsonObject>>>> watchHandlers = new HashMap<MapEvent.Type, Map<Handler<MapEvent<K, V>>, Handler<Message<JsonObject>>>>();

        public WrappedWatchableMap(String name, Map<K, V> map, Vertx vertx) {
            this.name = name;
            this.map = map;
            this.eventBus = vertx.eventBus();
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.map.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.map.containsValue(value);
        }

        @Override
        public V get(Object key) {
            return this.map.get(key);
        }

        @Override
        public V put(K key, V value) {
            V result = this.map.put(key, value);
            this.eventBus.publish(String.format("%s.%s.%s", this.name, key, MapEvent.Type.CHANGE.toString()), new JsonObject().putString("type", MapEvent.Type.CHANGE.toString()).putValue("key", key).putValue("value", value));
            String event = result == null ? MapEvent.Type.CREATE.toString() : MapEvent.Type.UPDATE.toString();
            this.eventBus.publish(String.format("%s.%s.%s", this.name, key, event), new JsonObject().putString("type", event).putValue("key", key).putValue("value", value));
            return result;
        }

        @Override
        public V remove(Object key) {
            V result = this.map.remove(key);
            this.eventBus.publish(String.format("%s.%s.%s", this.name, key, MapEvent.Type.CHANGE.toString()), new JsonObject().putString("type", MapEvent.Type.CHANGE.toString()).putValue("key", key).putValue("value", result));
            this.eventBus.publish(String.format("%s.%s.%s", this.name, key, MapEvent.Type.DELETE.toString()), new JsonObject().putString("type", MapEvent.Type.DELETE.toString()).putValue("key", key).putValue("value", result));
            return result;
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> m) {
            this.map.putAll(m);
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public Set<K> keySet() {
            return this.map.keySet();
        }

        @Override
        public Collection<V> values() {
            return this.map.values();
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return this.map.entrySet();
        }

        public void watch(K key, MapEvent.Type event, Handler<MapEvent<K, V>> handler, Handler<AsyncResult<Void>> doneHandler) {
            if (event == null) {
                CountingCompletionHandler<Void> counter = new CountingCompletionHandler<Void>(4).setHandler(doneHandler);
                this.addWatcher(key, MapEvent.Type.CHANGE, handler, counter);
                this.addWatcher(key, MapEvent.Type.CREATE, handler, counter);
                this.addWatcher(key, MapEvent.Type.UPDATE, handler, counter);
                this.addWatcher(key, MapEvent.Type.DELETE, handler, counter);
            } else {
                this.addWatcher(key, event, handler, doneHandler);
            }
        }

        private void addWatcher(K key, final MapEvent.Type event, final Handler<MapEvent<K, V>> handler, Handler<AsyncResult<Void>> doneHandler) {
            Handler<Message<JsonObject>> wrappedHandler;
            Map<Handler<MapEvent<Handler<MapEvent<K, V>>, Handler<Message<JsonObject>>>>, Handler<Message<JsonObject>>> watchHandlers = this.watchHandlers.get((Object)event);
            if (watchHandlers == null) {
                watchHandlers = new HashMap<Handler<MapEvent<K, V>>, Handler<Message<JsonObject>>>();
                this.watchHandlers.put(event, watchHandlers);
            }
            if (!watchHandlers.containsKey(handler)) {
                wrappedHandler = new Handler<Message<JsonObject>>(){

                    public void handle(Message<JsonObject> message) {
                        Object key = ((JsonObject)message.body()).getValue("key");
                        Object value = ((JsonObject)message.body()).getValue("value");
                        handler.handle(new MapEvent<Object, Object>(event, key, value));
                    }
                };
                watchHandlers.put(handler, wrappedHandler);
            } else {
                wrappedHandler = watchHandlers.get(handler);
            }
            this.eventBus.registerHandler(String.format("%s.%s.%s", this.name, key, event.toString()), (Handler)wrappedHandler, doneHandler);
        }

        public void unwatch(K key, MapEvent.Type event, Handler<MapEvent<K, V>> handler, Handler<AsyncResult<Void>> doneHandler) {
            if (event == null) {
                CountingCompletionHandler<Void> counter = new CountingCompletionHandler<Void>(4).setHandler(doneHandler);
                this.removeWatcher(key, MapEvent.Type.CHANGE, handler, counter);
                this.removeWatcher(key, MapEvent.Type.CREATE, handler, counter);
                this.removeWatcher(key, MapEvent.Type.UPDATE, handler, counter);
                this.removeWatcher(key, MapEvent.Type.DELETE, handler, counter);
            } else {
                this.removeWatcher(key, event, handler, doneHandler);
            }
        }

        private void removeWatcher(K key, MapEvent.Type event, Handler<MapEvent<K, V>> handler, Handler<AsyncResult<Void>> doneHandler) {
            Map<Handler<MapEvent<K, V>>, Handler<Message<JsonObject>>> watchHandlers = this.watchHandlers.get((Object)event);
            if (watchHandlers == null || !watchHandlers.containsKey(handler)) {
                new DefaultFutureResult((Object)null).setHandler(doneHandler);
            } else {
                Handler<Message<JsonObject>> wrappedHandler = watchHandlers.remove(handler);
                this.eventBus.unregisterHandler(String.format("%s.%s.%s", this.name, key, event.toString()), wrappedHandler, doneHandler);
            }
        }
    }
}

