/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.cluster.data.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.kuujo.vertigo.cluster.data.AsyncMap;
import net.kuujo.vertigo.cluster.data.MapEvent;
import net.kuujo.vertigo.cluster.data.WatchableAsyncMap;
import net.kuujo.vertigo.util.CountingCompletionHandler;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.eventbus.EventBus;
import org.vertx.java.core.eventbus.Message;
import org.vertx.java.core.impl.DefaultFutureResult;
import org.vertx.java.core.json.JsonObject;

public class WrappedWatchableAsyncMap<K, V>
implements WatchableAsyncMap<K, V> {
    private final AsyncMap<K, V> map;
    private final EventBus eventBus;
    private final Map<MapEvent.Type, Map<Handler<MapEvent<K, V>>, Handler<Message<JsonObject>>>> watchHandlers = new HashMap<MapEvent.Type, Map<Handler<MapEvent<K, V>>, Handler<Message<JsonObject>>>>();

    public WrappedWatchableAsyncMap(AsyncMap<K, V> map, Vertx vertx) {
        this.map = map;
        this.eventBus = vertx.eventBus();
    }

    @Override
    public String name() {
        return this.map.name();
    }

    @Override
    public void put(K key, V value) {
        this.put(key, value, null);
    }

    @Override
    public void put(final K key, final V value, final Handler<AsyncResult<V>> doneHandler) {
        this.map.put(key, value, new Handler<AsyncResult<V>>(){

            public void handle(AsyncResult<V> result) {
                WrappedWatchableAsyncMap.this.eventBus.publish(String.format("%s.%s.%s", WrappedWatchableAsyncMap.this.map.name(), key, MapEvent.Type.CHANGE.toString()), new JsonObject().putString("type", MapEvent.Type.CHANGE.toString()).putValue("key", key).putValue("value", value));
                String event = result.result() == null ? MapEvent.Type.CREATE.toString() : MapEvent.Type.UPDATE.toString();
                WrappedWatchableAsyncMap.this.eventBus.publish(String.format("%s.%s.%s", WrappedWatchableAsyncMap.this.map.name(), key, event), new JsonObject().putString("type", event).putValue("key", key).putValue("value", value));
                if (doneHandler != null) {
                    doneHandler.handle(result);
                }
            }
        });
    }

    @Override
    public void get(K key, Handler<AsyncResult<V>> resultHandler) {
        this.map.get(key, resultHandler);
    }

    @Override
    public void remove(K key) {
        this.remove(key, null);
    }

    @Override
    public void remove(final K key, final Handler<AsyncResult<V>> resultHandler) {
        this.map.remove(key, new Handler<AsyncResult<V>>(){

            public void handle(AsyncResult<V> result) {
                WrappedWatchableAsyncMap.this.eventBus.publish(String.format("%s.%s.%s", WrappedWatchableAsyncMap.this.map.name(), key, MapEvent.Type.CHANGE.toString()), new JsonObject().putString("type", MapEvent.Type.CHANGE.toString()).putValue("key", key).putValue("value", result.result()));
                WrappedWatchableAsyncMap.this.eventBus.publish(String.format("%s.%s.%s", WrappedWatchableAsyncMap.this.map.name(), key, MapEvent.Type.DELETE.toString()), new JsonObject().putString("type", MapEvent.Type.DELETE.toString()).putValue("key", key).putValue("value", result.result()));
                if (resultHandler != null) {
                    resultHandler.handle(result);
                }
            }
        });
    }

    @Override
    public void containsKey(K key, Handler<AsyncResult<Boolean>> resultHandler) {
        this.map.containsKey(key, resultHandler);
    }

    @Override
    public void keySet(Handler<AsyncResult<Set<K>>> resultHandler) {
        this.map.keySet(resultHandler);
    }

    @Override
    public void values(Handler<AsyncResult<Collection<V>>> resultHandler) {
        this.map.values(resultHandler);
    }

    @Override
    public void size(Handler<AsyncResult<Integer>> resultHandler) {
        this.map.size(resultHandler);
    }

    @Override
    public void isEmpty(Handler<AsyncResult<Boolean>> resultHandler) {
        this.map.isEmpty(resultHandler);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public void clear(Handler<AsyncResult<Void>> doneHandler) {
        this.map.clear(doneHandler);
    }

    @Override
    public void watch(K key, Handler<MapEvent<K, V>> handler) {
        this.watch(key, null, handler, null);
    }

    @Override
    public void watch(K key, Handler<MapEvent<K, V>> handler, Handler<AsyncResult<Void>> doneHandler) {
        this.watch(key, null, handler, doneHandler);
    }

    @Override
    public void watch(K key, MapEvent.Type event, Handler<MapEvent<K, V>> handler) {
        this.watch(key, event, handler, null);
    }

    @Override
    public void watch(K key, MapEvent.Type event, Handler<MapEvent<K, V>> handler, Handler<AsyncResult<Void>> doneHandler) {
        if (event == null) {
            CountingCompletionHandler<Void> counter = new CountingCompletionHandler<Void>(4).setHandler(doneHandler);
            this.addWatcher(key, MapEvent.Type.CHANGE, handler, counter);
            this.addWatcher(key, MapEvent.Type.CREATE, handler, counter);
            this.addWatcher(key, MapEvent.Type.UPDATE, handler, counter);
            this.addWatcher(key, MapEvent.Type.DELETE, handler, counter);
        } else {
            this.addWatcher(key, event, handler, doneHandler);
        }
    }

    private void addWatcher(K key, final MapEvent.Type event, final Handler<MapEvent<K, V>> handler, Handler<AsyncResult<Void>> doneHandler) {
        Handler<Message<JsonObject>> wrappedHandler;
        Map<Handler<MapEvent<Handler<MapEvent<K, V>>, Handler<Message<JsonObject>>>>, Handler<Message<JsonObject>>> watchHandlers = this.watchHandlers.get((Object)event);
        if (watchHandlers == null) {
            watchHandlers = new HashMap<Handler<MapEvent<K, V>>, Handler<Message<JsonObject>>>();
            this.watchHandlers.put(event, watchHandlers);
        }
        if (!watchHandlers.containsKey(handler)) {
            wrappedHandler = new Handler<Message<JsonObject>>(){

                public void handle(Message<JsonObject> message) {
                    Object key = ((JsonObject)message.body()).getValue("key");
                    Object value = ((JsonObject)message.body()).getValue("value");
                    handler.handle(new MapEvent<Object, Object>(event, key, value));
                }
            };
            watchHandlers.put(handler, wrappedHandler);
        } else {
            wrappedHandler = watchHandlers.get(handler);
        }
        this.eventBus.registerHandler(String.format("%s.%s.%s", this.map.name(), key, event.toString()), (Handler)wrappedHandler, doneHandler);
    }

    @Override
    public void unwatch(K key, Handler<MapEvent<K, V>> handler) {
        this.unwatch(key, null, handler, null);
    }

    @Override
    public void unwatch(K key, Handler<MapEvent<K, V>> handler, Handler<AsyncResult<Void>> doneHandler) {
        this.unwatch(key, null, handler, doneHandler);
    }

    @Override
    public void unwatch(K key, MapEvent.Type event, Handler<MapEvent<K, V>> handler) {
        this.unwatch(key, event, handler, null);
    }

    @Override
    public void unwatch(K key, MapEvent.Type event, Handler<MapEvent<K, V>> handler, Handler<AsyncResult<Void>> doneHandler) {
        if (event == null) {
            CountingCompletionHandler<Void> counter = new CountingCompletionHandler<Void>(4).setHandler(doneHandler);
            this.removeWatcher(key, MapEvent.Type.CHANGE, handler, counter);
            this.removeWatcher(key, MapEvent.Type.CREATE, handler, counter);
            this.removeWatcher(key, MapEvent.Type.UPDATE, handler, counter);
            this.removeWatcher(key, MapEvent.Type.DELETE, handler, counter);
        } else {
            this.removeWatcher(key, event, handler, doneHandler);
        }
    }

    private void removeWatcher(K key, MapEvent.Type event, Handler<MapEvent<K, V>> handler, Handler<AsyncResult<Void>> doneHandler) {
        Map<Handler<MapEvent<K, V>>, Handler<Message<JsonObject>>> watchHandlers = this.watchHandlers.get((Object)event);
        if (watchHandlers == null || !watchHandlers.containsKey(handler)) {
            new DefaultFutureResult((Object)null).setHandler(doneHandler);
        } else {
            Handler<Message<JsonObject>> wrappedHandler = watchHandlers.remove(handler);
            this.eventBus.unregisterHandler(String.format("%s.%s.%s", this.map.name(), key, event.toString()), wrappedHandler, doneHandler);
        }
    }
}

