/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.cluster;

import java.util.HashMap;
import java.util.Map;
import net.kuujo.vertigo.cluster.ClusterManager;
import net.kuujo.vertigo.cluster.impl.DefaultClusterManagerFactory;
import org.vertx.java.core.Vertx;
import org.vertx.java.platform.Container;

public abstract class ClusterManagerFactory {
    private static final String CLUSTER_MANAGER_FACTORY_PROPERTY_NAME = "net.kuujo.vertigo.cluster-manager-factory";
    private static ClusterManagerFactory instance;
    private static final Map<String, ClusterManager> clusters;
    protected Vertx vertx;
    protected Container container;

    private static ClusterManagerFactory getInstance(Vertx vertx, Container container) {
        if (instance == null) {
            String className = null;
            try {
                className = System.getProperty(CLUSTER_MANAGER_FACTORY_PROPERTY_NAME);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (className != null) {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                try {
                    Class<?> clazz = loader.loadClass(className);
                    instance = ((ClusterManagerFactory)clazz.newInstance()).setVertx(vertx).setContainer(container);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Error instantiating cluster factory.", e);
                }
            } else {
                instance = new DefaultClusterManagerFactory().setVertx(vertx).setContainer(container);
            }
        }
        return instance;
    }

    public static ClusterManager getClusterManager(String address, Vertx vertx, Container container) {
        ClusterManager cluster = clusters.get(address);
        if (cluster == null) {
            cluster = ClusterManagerFactory.getInstance(vertx, container).createClusterManager(address);
            clusters.put(address, cluster);
        }
        return cluster;
    }

    protected ClusterManagerFactory setVertx(Vertx vertx) {
        this.vertx = vertx;
        return this;
    }

    protected ClusterManagerFactory setContainer(Container container) {
        this.container = container;
        return this;
    }

    public abstract ClusterManager createClusterManager(String var1);

    static {
        clusters = new HashMap<String, ClusterManager>();
    }
}

