/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.cluster;

import java.util.HashMap;
import java.util.Map;
import net.kuujo.vertigo.cluster.Cluster;
import net.kuujo.vertigo.cluster.impl.DefaultClusterFactory;
import org.vertx.java.core.Vertx;
import org.vertx.java.platform.Container;

public abstract class ClusterFactory {
    private static final String CLUSTER_FACTORY_PROPERTY_NAME = "net.kuujo.vertigo.cluster-factory";
    private static ClusterFactory instance;
    private static final Map<String, Cluster> clusters;
    protected Vertx vertx;
    protected Container container;

    private static ClusterFactory getInstance(Vertx vertx, Container container) {
        if (instance == null) {
            String className = null;
            try {
                className = System.getProperty(CLUSTER_FACTORY_PROPERTY_NAME);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (className != null) {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                try {
                    Class<?> clazz = loader.loadClass(className);
                    instance = ((ClusterFactory)clazz.newInstance()).setVertx(vertx).setContainer(container);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Error instantiating cluster factory.", e);
                }
            } else {
                instance = new DefaultClusterFactory().setVertx(vertx).setContainer(container);
            }
        }
        return instance;
    }

    public static Cluster getCluster(String address, Vertx vertx, Container container) {
        Cluster cluster = clusters.get(address);
        if (cluster == null) {
            cluster = ClusterFactory.getInstance(vertx, container).createCluster(address);
            clusters.put(address, cluster);
        }
        return cluster;
    }

    protected ClusterFactory setVertx(Vertx vertx) {
        this.vertx = vertx;
        return this;
    }

    protected ClusterFactory setContainer(Container container) {
        this.container = container;
        return this;
    }

    public abstract Cluster createCluster(String var1);

    static {
        clusters = new HashMap<String, Cluster>();
    }
}

