/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo;

import net.kuujo.vertigo.cluster.ClusterManager;
import net.kuujo.vertigo.cluster.ClusterManagerFactory;
import net.kuujo.vertigo.cluster.impl.ClusterAgent;
import net.kuujo.vertigo.network.ActiveNetwork;
import net.kuujo.vertigo.network.NetworkConfig;
import net.kuujo.vertigo.network.impl.DefaultNetworkConfig;
import net.kuujo.vertigo.util.Configs;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.impl.DefaultFutureResult;
import org.vertx.java.core.json.JsonObject;
import org.vertx.java.platform.Container;
import org.vertx.java.platform.Verticle;

public class Vertigo {
    private static final String CLUSTER_MAIN_PROPERTY_NAME = "net.kuujo.vertigo.cluster";
    private final Vertx vertx;
    private final Container container;
    private static String clusterMain;

    public Vertigo(Verticle verticle) {
        this(verticle.getVertx(), verticle.getContainer());
    }

    public Vertigo(Vertx vertx, Container container) {
        this.vertx = vertx;
        this.container = container;
    }

    public NetworkConfig createNetwork(String name) {
        return new DefaultNetworkConfig(name);
    }

    public NetworkConfig createNetwork(JsonObject json) {
        return Configs.createNetwork(json);
    }

    private String getClusterMain() {
        if (clusterMain == null) {
            try {
                clusterMain = System.getProperty(CLUSTER_MAIN_PROPERTY_NAME);
            }
            catch (Exception exception) {
                // empty catch block
            }
            clusterMain = ClusterAgent.class.getName();
        }
        return clusterMain;
    }

    public Vertigo deployCluster(String cluster) {
        return this.deployCluster(cluster, 1, null);
    }

    public Vertigo deployCluster(String cluster, Handler<AsyncResult<ClusterManager>> doneHandler) {
        return this.deployCluster(cluster, 1, doneHandler);
    }

    public Vertigo deployCluster(String cluster, int nodes) {
        return this.deployCluster(cluster, nodes, null);
    }

    public Vertigo deployCluster(final String cluster, int nodes, final Handler<AsyncResult<ClusterManager>> doneHandler) {
        JsonObject config = new JsonObject().putString("cluster", cluster);
        this.container.deployWorkerVerticle(this.getClusterMain(), config, nodes, false, (Handler)new Handler<AsyncResult<String>>(){

            public void handle(AsyncResult<String> result) {
                if (result.failed()) {
                    new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                } else {
                    new DefaultFutureResult((Object)Vertigo.this.getCluster(cluster)).setHandler(doneHandler);
                }
            }
        });
        return this;
    }

    public ClusterManager getCluster(String cluster) {
        return ClusterManagerFactory.getClusterManager(cluster, this.vertx, this.container);
    }

    public Vertigo deployNetwork(String cluster, String name) {
        this.getCluster(cluster).deployNetwork(name);
        return this;
    }

    public Vertigo deployNetwork(String cluster, String name, Handler<AsyncResult<ActiveNetwork>> doneHandler) {
        this.getCluster(cluster).deployNetwork(name, doneHandler);
        return this;
    }

    public Vertigo deployNetwork(String cluster, JsonObject network) {
        this.getCluster(cluster).deployNetwork(network);
        return this;
    }

    public Vertigo deployNetwork(String cluster, JsonObject network, Handler<AsyncResult<ActiveNetwork>> doneHandler) {
        this.getCluster(cluster).deployNetwork(network, doneHandler);
        return this;
    }

    public Vertigo deployNetwork(String cluster, NetworkConfig network) {
        this.getCluster(cluster).deployNetwork(network);
        return this;
    }

    public Vertigo deployNetwork(String cluster, NetworkConfig network, Handler<AsyncResult<ActiveNetwork>> doneHandler) {
        this.getCluster(cluster).deployNetwork(network, doneHandler);
        return this;
    }

    public Vertigo undeployNetwork(String cluster, String name) {
        this.getCluster(cluster).undeployNetwork(name);
        return this;
    }

    public Vertigo undeployNetwork(String cluster, String name, Handler<AsyncResult<Void>> doneHandler) {
        this.getCluster(cluster).undeployNetwork(name, doneHandler);
        return this;
    }

    public Vertigo undeployNetwork(String cluster, JsonObject network) {
        this.getCluster(cluster).undeployNetwork(network);
        return this;
    }

    public Vertigo undeployNetwork(String cluster, JsonObject network, Handler<AsyncResult<Void>> doneHandler) {
        this.getCluster(cluster).undeployNetwork(network, doneHandler);
        return this;
    }

    public Vertigo undeployNetwork(String cluster, NetworkConfig network) {
        this.getCluster(cluster).undeployNetwork(network);
        return this;
    }

    public Vertigo undeployNetwork(String cluster, NetworkConfig network, Handler<AsyncResult<Void>> doneHandler) {
        this.getCluster(cluster).undeployNetwork(network, doneHandler);
        return this;
    }
}

