/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import net.kuujo.vertigo.cluster.ClusterScope;
import net.kuujo.vertigo.cluster.ClusterType;
import net.kuujo.vertigo.cluster.ClusterTypeInfo;
import net.kuujo.vertigo.cluster.LocalType;
import net.kuujo.vertigo.cluster.LocalTypeInfo;
import net.kuujo.vertigo.component.Component;
import net.kuujo.vertigo.component.impl.DefaultComponentFactory;
import net.kuujo.vertigo.util.Config;
import net.kuujo.vertigo.util.Factory;
import org.vertx.java.core.Vertx;
import org.vertx.java.platform.Container;

public final class Factories {
    public static Component createComponent(Vertx vertx, Container container) {
        return new DefaultComponentFactory().setVertx(vertx).setContainer(container).createComponent(Config.parseContext(container.config()), Config.parseCluster(container.config(), vertx, container));
    }

    public static <T> T createObject(ClusterScope scope, Class<T> clazz, Object ... args) {
        if (scope.equals((Object)ClusterScope.LOCAL)) {
            if (!clazz.isAnnotationPresent(LocalTypeInfo.class)) {
                throw new IllegalArgumentException("No local type info available.");
            }
            LocalTypeInfo info = clazz.getAnnotation(LocalTypeInfo.class);
            return Factories.createObjectFromFactoryMethod(info.defaultImpl(), args);
        }
        if (scope.equals((Object)ClusterScope.CLUSTER)) {
            if (!clazz.isAnnotationPresent(ClusterTypeInfo.class)) {
                throw new IllegalArgumentException("No cluster type info available.");
            }
            ClusterTypeInfo info = clazz.getAnnotation(ClusterTypeInfo.class);
            return Factories.createObjectFromFactoryMethod(info.defaultImpl(), args);
        }
        return null;
    }

    public static <T> T resolveObject(ClusterScope scope, Class<? extends T> clazz, Object ... args) {
        return (T)Factories.createObjectFromFactoryMethod(Factories.resolveType(scope, clazz), args);
    }

    private static <T> T createObjectFromFactoryMethod(Class<? extends T> clazz, Object ... args) {
        for (Method method : clazz.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(Factory.class)) continue;
            if (!Modifier.isPublic(method.getModifiers()) || !Modifier.isStatic(method.getModifiers())) {
                throw new IllegalArgumentException("Factory method " + method.getName() + " in " + clazz.getCanonicalName() + " must be public and static.");
            }
            if (!method.getReturnType().isAssignableFrom(clazz)) {
                throw new IllegalArgumentException("Factory method " + method.getName() + " in " + clazz.getCanonicalName() + " must return a " + clazz.getCanonicalName() + " instance.");
            }
            try {
                return (T)method.invoke(null, args);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException(clazz.getCanonicalName() + " does not contain a valid factory method.");
    }

    private static Class<?> resolveType(ClusterScope scope, Class<?> clazz) {
        if (scope.equals((Object)ClusterScope.LOCAL)) {
            if (Factories.isAnnotationPresentInHierarchy(clazz, LocalType.class) || !Factories.isAnnotationPresentInHierarchy(clazz, LocalType.class) && !Factories.isAnnotationPresentInHierarchy(clazz, ClusterType.class)) {
                return clazz;
            }
            LocalTypeInfo info = (LocalTypeInfo)Factories.getAnnotationInHierarchy(clazz, LocalTypeInfo.class);
            if (info == null) {
                throw new IllegalStateException("Cannot instantiate " + clazz.getName() + " object in local mode.");
            }
            return info.defaultImpl();
        }
        if (scope.equals((Object)ClusterScope.CLUSTER)) {
            if (Factories.isAnnotationPresentInHierarchy(clazz, ClusterType.class) || !Factories.isAnnotationPresentInHierarchy(clazz, LocalType.class) && !Factories.isAnnotationPresentInHierarchy(clazz, ClusterType.class)) {
                return clazz;
            }
            ClusterTypeInfo info = (ClusterTypeInfo)Factories.getAnnotationInHierarchy(clazz, ClusterTypeInfo.class);
            if (info == null) {
                throw new IllegalStateException("Cannot instantiate " + clazz.getName() + " object in cluster mode.");
            }
            return info.defaultImpl();
        }
        throw new IllegalStateException("Vertigo mode not initialized.");
    }

    private static boolean isAnnotationPresentInHierarchy(Class<?> clazz, Class<? extends Annotation> annotation) {
        for (Class<?> current = clazz; current != Object.class; current = current.getSuperclass()) {
            if (current.isAnnotationPresent(annotation)) {
                return true;
            }
            for (Class<?> iface : current.getInterfaces()) {
                if (!iface.isAnnotationPresent(annotation)) continue;
                return true;
            }
        }
        return false;
    }

    private static <T extends Annotation> T getAnnotationInHierarchy(Class<?> clazz, Class<? extends Annotation> annotation) {
        for (Class<?> current = clazz; current != Object.class; current = current.getSuperclass()) {
            if (current.isAnnotationPresent(annotation)) {
                return (T)current.getAnnotation(annotation);
            }
            for (Class<?> iface : current.getInterfaces()) {
                if (!iface.isAnnotationPresent(annotation)) continue;
                return (T)iface.getAnnotation(annotation);
            }
        }
        return null;
    }
}

