/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.util;

import net.kuujo.vertigo.Config;
import net.kuujo.vertigo.component.ComponentConfig;
import net.kuujo.vertigo.io.connection.ConnectionConfig;
import net.kuujo.vertigo.network.NetworkConfig;
import net.kuujo.vertigo.util.serialization.Serializer;
import net.kuujo.vertigo.util.serialization.SerializerFactory;
import org.vertx.java.core.json.JsonObject;

public final class Configs {
    private static final Serializer serializer = SerializerFactory.getSerializer(Config.class);

    public static NetworkConfig createNetwork(JsonObject config) {
        return (NetworkConfig)serializer.deserializeObject(config, NetworkConfig.class);
    }

    public static <T extends ComponentConfig<T>> T createComponent(JsonObject config) {
        return (T)((ComponentConfig)serializer.deserializeObject(config, ComponentConfig.class));
    }

    public static ConnectionConfig createConnection(JsonObject config) {
        return (ConnectionConfig)serializer.deserializeObject(config, ConnectionConfig.class);
    }

    public static NetworkConfig mergeNetworks(NetworkConfig base, NetworkConfig merge) {
        if (!base.getName().equals(merge.getName())) {
            throw new IllegalArgumentException("Cannot merge networks of different names.");
        }
        for (ComponentConfig<?> component : merge.getComponents()) {
            if (base.hasComponent(component.getName())) continue;
            base.addComponent(component);
        }
        for (ConnectionConfig connection : merge.getConnections()) {
            boolean exists = false;
            for (ConnectionConfig existing : base.getConnections()) {
                if (!existing.equals(connection)) continue;
                exists = true;
                break;
            }
            if (exists) continue;
            base.createConnection(connection);
        }
        return base;
    }

    public static NetworkConfig unmergeNetworks(NetworkConfig base, NetworkConfig unmerge) {
        if (!base.getName().equals(unmerge.getName())) {
            throw new IllegalArgumentException("Cannot merge networks of different names.");
        }
        for (ComponentConfig<?> component : unmerge.getComponents()) {
            base.removeComponent(component.getName());
        }
        for (ConnectionConfig connection : unmerge.getConnections()) {
            base.destroyConnection(connection);
        }
        return base;
    }
}

