/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.io.selector;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.kuujo.vertigo.io.connection.Connection;
import net.kuujo.vertigo.io.selector.Selector;
import net.kuujo.vertigo.util.serialization.SerializerFactory;
import org.vertx.java.core.json.JsonObject;

public class CustomSelector
implements Selector {
    private Map<String, Object> properties = new HashMap<String, Object>();
    private boolean initialized;
    private Selector selector;

    public CustomSelector() {
    }

    public CustomSelector(Selector selector) {
        this.selector = selector;
    }

    @JsonAnyGetter
    private Map<String, Object> getProperties() {
        if (this.selector != null) {
            this.properties = SerializerFactory.getSerializer(this.selector.getClass()).serializeToObject((Object)this.selector).toMap();
        }
        return this.properties;
    }

    @JsonAnySetter
    private void setProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    private void init() {
        if (!this.initialized) {
            String className = (String)this.properties.get("selector");
            if (className != null) {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                try {
                    Class<?> clazz = loader.loadClass(className);
                    this.selector = (Selector)SerializerFactory.getSerializer(clazz).deserializeObject(new JsonObject(this.properties), clazz);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Error instantiating serializer factory.");
                }
            } else {
                throw new IllegalStateException("Not a valid custom serializer.");
            }
        }
    }

    @Override
    public <T extends Connection> List<T> select(Object message, List<T> connections) {
        this.init();
        return this.selector.select(message, connections);
    }
}

