/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.io.port.impl;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.kuujo.vertigo.hook.InputHook;
import net.kuujo.vertigo.impl.BaseContext;
import net.kuujo.vertigo.io.InputContext;
import net.kuujo.vertigo.io.connection.InputConnectionContext;
import net.kuujo.vertigo.io.connection.impl.DefaultInputConnectionContext;
import net.kuujo.vertigo.io.port.InputPortContext;

public class DefaultInputPortContext
extends BaseContext<InputPortContext>
implements InputPortContext {
    private String port;
    private Collection<InputConnectionContext> connections = new ArrayList<InputConnectionContext>();
    private List<InputHook> hooks = new ArrayList<InputHook>();
    @JsonIgnore
    private InputContext input;

    public DefaultInputPortContext setInput(InputContext input) {
        this.input = input;
        return this;
    }

    @Override
    public String name() {
        return this.port;
    }

    @Override
    public InputContext input() {
        return this.input;
    }

    @Override
    public String address() {
        return this.address;
    }

    @Override
    public Collection<InputConnectionContext> connections() {
        return this.connections;
    }

    @Override
    public List<InputHook> hooks() {
        return this.hooks;
    }

    @Override
    public void notify(InputPortContext update) {
        if (update == null) {
            for (InputConnectionContext connection : this.connections) {
                connection.notify(null);
            }
            this.connections.clear();
        } else {
            Iterator<InputConnectionContext> iter = this.connections.iterator();
            while (iter.hasNext()) {
                InputConnectionContext connection = iter.next();
                InputConnectionContext match = null;
                for (InputConnectionContext c : update.connections()) {
                    if (!connection.equals(c)) continue;
                    match = c;
                    break;
                }
                if (match != null) {
                    connection.notify(match);
                    continue;
                }
                connection.notify(null);
                iter.remove();
            }
            for (InputConnectionContext connection : update.connections()) {
                if (this.connections.contains(connection)) continue;
                this.connections.add(connection);
            }
        }
        super.notify(this);
    }

    public static class Builder
    extends BaseContext.Builder<Builder, DefaultInputPortContext> {
        private Builder() {
            super(new DefaultInputPortContext());
        }

        private Builder(DefaultInputPortContext context) {
            super(context);
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static Builder newBuilder(DefaultInputPortContext context) {
            return new Builder(context);
        }

        public Builder setName(String port) {
            ((DefaultInputPortContext)this.context).port = port;
            return this;
        }

        public Builder setConnections(DefaultInputConnectionContext ... connections) {
            ((DefaultInputPortContext)this.context).connections = new ArrayList();
            for (DefaultInputConnectionContext connection : connections) {
                ((DefaultInputPortContext)this.context).connections.add(connection.setPort((InputPortContext)((Object)this.context)));
            }
            return this;
        }

        public Builder setConnections(Collection<DefaultInputConnectionContext> connections) {
            ((DefaultInputPortContext)this.context).connections = new ArrayList();
            for (DefaultInputConnectionContext connection : connections) {
                ((DefaultInputPortContext)this.context).connections.add(connection.setPort((InputPortContext)((Object)this.context)));
            }
            return this;
        }

        public Builder addConnection(DefaultInputConnectionContext connection) {
            ((DefaultInputPortContext)this.context).connections.add(connection.setPort((InputPortContext)((Object)this.context)));
            return this;
        }

        public Builder removeConnection(InputConnectionContext connection) {
            ((DefaultInputPortContext)this.context).connections.remove(connection);
            return this;
        }

        public Builder setHooks(InputHook ... hooks) {
            ((DefaultInputPortContext)this.context).hooks = Arrays.asList(hooks);
            return this;
        }

        public Builder setHooks(List<InputHook> hooks) {
            ((DefaultInputPortContext)this.context).hooks = hooks;
            return this;
        }

        public Builder addHook(InputHook hook) {
            ((DefaultInputPortContext)this.context).hooks.add(hook);
            return this;
        }

        public Builder removeHook(InputHook hook) {
            ((DefaultInputPortContext)this.context).hooks.remove(hook);
            return this;
        }
    }
}

