/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.io.port.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.kuujo.vertigo.hook.InputHook;
import net.kuujo.vertigo.io.connection.InputConnection;
import net.kuujo.vertigo.io.connection.InputConnectionContext;
import net.kuujo.vertigo.io.connection.impl.DefaultInputConnection;
import net.kuujo.vertigo.io.group.InputGroup;
import net.kuujo.vertigo.io.port.InputPort;
import net.kuujo.vertigo.io.port.InputPortContext;
import net.kuujo.vertigo.util.CountingCompletionHandler;
import net.kuujo.vertigo.util.Observer;
import net.kuujo.vertigo.util.Task;
import net.kuujo.vertigo.util.TaskRunner;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.impl.DefaultFutureResult;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;

public class DefaultInputPort
implements InputPort,
Observer<InputPortContext> {
    private static final Logger log = LoggerFactory.getLogger(DefaultInputPort.class);
    private final Vertx vertx;
    private InputPortContext context;
    private final List<InputConnection> connections = new ArrayList<InputConnection>();
    private List<InputHook> hooks = new ArrayList<InputHook>();
    private final TaskRunner tasks = new TaskRunner();
    private Handler messageHandler;
    private final Map<String, Handler<InputGroup>> groupHandlers = new HashMap<String, Handler<InputGroup>>();
    private boolean open;
    private boolean paused;

    public DefaultInputPort(Vertx vertx, InputPortContext context) {
        this.vertx = vertx;
        this.context = context;
        this.hooks = context.hooks();
        context.registerObserver(this);
    }

    @Override
    public String name() {
        return this.context.name();
    }

    @Override
    public Vertx vertx() {
        return this.vertx;
    }

    public void update(final InputPortContext update) {
        this.tasks.runTask((Handler)new Handler<Task>(){

            public void handle(final Task task) {
                Iterator iter = DefaultInputPort.this.connections.iterator();
                while (iter.hasNext()) {
                    final InputConnection connection = (InputConnection)iter.next();
                    boolean exists = false;
                    for (InputConnectionContext inputConnectionContext : update.connections()) {
                        if (!inputConnectionContext.address().equals(connection.address())) continue;
                        exists = true;
                        break;
                    }
                    if (exists) continue;
                    connection.close(new Handler<AsyncResult<Void>>(){

                        public void handle(AsyncResult<Void> result) {
                            if (result.failed()) {
                                log.error((Object)("Failed to close input connection " + connection.address()));
                            }
                        }
                    });
                    iter.remove();
                }
                ArrayList<DefaultInputConnection> newConnections = new ArrayList<DefaultInputConnection>();
                for (InputConnectionContext inputConnectionContext : update.connections()) {
                    boolean bl = false;
                    for (InputConnection inputConnection : DefaultInputPort.this.connections) {
                        if (!inputConnection.address().equals(inputConnectionContext.address())) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    newConnections.add(new DefaultInputConnection(DefaultInputPort.this.vertx, inputConnectionContext));
                }
                if (DefaultInputPort.this.open) {
                    CountingCompletionHandler counter = new CountingCompletionHandler(newConnections.size());
                    counter.setHandler((Handler)new Handler<AsyncResult<Void>>(){

                        public void handle(AsyncResult<Void> result) {
                            DefaultInputPort.this.hooks = update.hooks();
                            task.complete();
                        }
                    });
                    for (final InputConnection inputConnection : newConnections) {
                        inputConnection.messageHandler(DefaultInputPort.this.messageHandler);
                        for (Map.Entry entry : DefaultInputPort.this.groupHandlers.entrySet()) {
                            inputConnection.groupHandler((String)entry.getKey(), (Handler<InputGroup>)((Handler)entry.getValue()));
                        }
                        if (DefaultInputPort.this.paused) {
                            inputConnection.pause();
                        }
                        inputConnection.open(new Handler<AsyncResult<Void>>(){

                            public void handle(AsyncResult<Void> result) {
                                if (result.failed()) {
                                    log.error((Object)("Failed to open input connection " + inputConnection.address()));
                                } else {
                                    DefaultInputPort.this.connections.add(inputConnection);
                                }
                            }
                        });
                    }
                } else {
                    for (InputConnection inputConnection : newConnections) {
                        inputConnection.messageHandler(DefaultInputPort.this.messageHandler);
                        for (Map.Entry entry : DefaultInputPort.this.groupHandlers.entrySet()) {
                            inputConnection.groupHandler((String)entry.getKey(), (Handler<InputGroup>)((Handler)entry.getValue()));
                        }
                        if (DefaultInputPort.this.paused) {
                            inputConnection.pause();
                        }
                        DefaultInputPort.this.connections.add(inputConnection);
                    }
                    DefaultInputPort.this.hooks = update.hooks();
                    task.complete();
                }
            }
        });
    }

    @Override
    public InputPort pause() {
        this.paused = true;
        for (InputConnection connection : this.connections) {
            connection.pause();
        }
        return this;
    }

    @Override
    public InputPort resume() {
        this.paused = false;
        for (InputConnection connection : this.connections) {
            connection.resume();
        }
        return this;
    }

    @Override
    public InputPort messageHandler(final Handler handler) {
        this.messageHandler = new Handler(){

            public void handle(Object message) {
                handler.handle(message);
                for (InputHook hook : DefaultInputPort.this.hooks) {
                    hook.handleReceive(message);
                }
            }
        };
        for (InputConnection connection : this.connections) {
            connection.messageHandler(this.messageHandler);
        }
        return this;
    }

    @Override
    public InputPort groupHandler(String group, Handler<InputGroup> handler) {
        this.groupHandlers.put(group, handler);
        for (InputConnection connection : this.connections) {
            connection.groupHandler(group, handler);
        }
        return this;
    }

    @Override
    public InputPort open() {
        return this.open((Handler)null);
    }

    @Override
    public InputPort open(final Handler<AsyncResult<Void>> doneHandler) {
        this.tasks.runTask((Handler)new Handler<Task>(){

            public void handle(final Task task) {
                if (!DefaultInputPort.this.open) {
                    final CountingCompletionHandler startCounter = new CountingCompletionHandler(DefaultInputPort.this.context.connections().size());
                    startCounter.setHandler((Handler)new Handler<AsyncResult<Void>>(){

                        public void handle(AsyncResult<Void> result) {
                            if (result.failed()) {
                                new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                            } else {
                                DefaultInputPort.this.open = true;
                                new DefaultFutureResult((Object)null).setHandler(doneHandler);
                            }
                            task.complete();
                        }
                    });
                    DefaultInputPort.this.connections.clear();
                    for (InputConnectionContext connectionContext : DefaultInputPort.this.context.connections()) {
                        final DefaultInputConnection connection = new DefaultInputConnection(DefaultInputPort.this.vertx, connectionContext);
                        connection.messageHandler(DefaultInputPort.this.messageHandler);
                        for (Map.Entry entry : DefaultInputPort.this.groupHandlers.entrySet()) {
                            connection.groupHandler((String)entry.getKey(), (Handler<InputGroup>)((Handler)entry.getValue()));
                        }
                        if (DefaultInputPort.this.paused) {
                            connection.pause();
                        }
                        connection.open(new Handler<AsyncResult<Void>>(){

                            public void handle(AsyncResult<Void> result) {
                                if (result.failed()) {
                                    log.error((Object)("Failed to open input connection " + connection.address()));
                                    startCounter.fail(result.cause());
                                } else {
                                    DefaultInputPort.this.connections.add(connection);
                                    startCounter.succeed();
                                }
                            }
                        });
                    }
                } else {
                    new DefaultFutureResult((Object)null).setHandler(doneHandler);
                    task.complete();
                }
            }
        });
        return this;
    }

    @Override
    public void close() {
        this.close(null);
    }

    @Override
    public void close(final Handler<AsyncResult<Void>> doneHandler) {
        this.tasks.runTask((Handler)new Handler<Task>(){

            public void handle(final Task task) {
                if (DefaultInputPort.this.open) {
                    CountingCompletionHandler stopCounter = new CountingCompletionHandler(DefaultInputPort.this.connections.size());
                    stopCounter.setHandler((Handler)new Handler<AsyncResult<Void>>(){

                        public void handle(AsyncResult<Void> result) {
                            if (result.failed()) {
                                new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                            } else {
                                DefaultInputPort.this.connections.clear();
                                new DefaultFutureResult((Object)null).setHandler(doneHandler);
                            }
                            task.complete();
                        }
                    });
                    for (InputConnection connection : DefaultInputPort.this.connections) {
                        connection.close((Handler<AsyncResult<Void>>)stopCounter);
                    }
                } else {
                    new DefaultFutureResult((Object)null).setHandler(doneHandler);
                    task.complete();
                }
            }
        });
    }
}

