/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.io.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.kuujo.vertigo.util.serialization.Serializer;
import net.kuujo.vertigo.util.serialization.SerializerFactory;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.json.JsonArray;
import org.vertx.java.core.json.JsonObject;

public class OutputSerializer {
    private final Map<Class<?>, Serializer> serializers = new HashMap();
    private final Set<Class<?>> eventBusTypes = new HashSet<Class<?>>(){
        {
            this.add(String.class);
            this.add(Integer.class);
            this.add(Short.class);
            this.add(Integer.class);
            this.add(Long.class);
            this.add(Float.class);
            this.add(Double.class);
            this.add(Byte.class);
            this.add(byte[].class);
            this.add(Character.class);
            this.add(Buffer.class);
            this.add(JsonObject.class);
            this.add(JsonArray.class);
        }
    };

    public JsonObject serialize(Object message) {
        Class<?> clazz = message.getClass();
        if (this.eventBusTypes.contains(clazz)) {
            return new JsonObject().putValue("value", message);
        }
        Serializer serializer = this.serializers.get(clazz);
        if (serializer == null) {
            serializer = SerializerFactory.getSerializer(clazz);
            this.serializers.put(clazz, serializer);
        }
        return new JsonObject().putBoolean("serialized", Boolean.valueOf(true)).putString("class", clazz.getName()).putString("value", serializer.serializeToString(message));
    }
}

