/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.io.impl;

import java.util.HashMap;
import java.util.Map;
import net.kuujo.vertigo.util.serialization.Serializer;
import net.kuujo.vertigo.util.serialization.SerializerFactory;
import org.vertx.java.core.json.JsonObject;

public class InputDeserializer {
    private final Map<String, Class<?>> classes = new HashMap();
    private final Map<Class<?>, Serializer> serializers = new HashMap();

    public Object deserialize(JsonObject message) {
        String value;
        Serializer serializer;
        boolean serialized = message.getBoolean("serialized", false);
        if (!serialized) {
            return message.getValue("value");
        }
        String className = message.getString("class");
        if (className == null) {
            return null;
        }
        Class<?> clazz = this.classes.get(className);
        if (clazz == null) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            try {
                clazz = loader.loadClass(className);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Error instantiating serializer factory.");
            }
        }
        if ((serializer = this.serializers.get(clazz)) == null) {
            serializer = SerializerFactory.getSerializer(clazz);
            this.serializers.put(clazz, serializer);
        }
        if ((value = message.getString("value")) == null) {
            return null;
        }
        return serializer.deserializeString(value, clazz);
    }
}

