/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.io.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import net.kuujo.vertigo.component.impl.DefaultInstanceContext;
import net.kuujo.vertigo.impl.BaseContext;
import net.kuujo.vertigo.io.InputContext;
import net.kuujo.vertigo.io.impl.DefaultIOContext;
import net.kuujo.vertigo.io.port.InputPortContext;
import net.kuujo.vertigo.io.port.impl.DefaultInputPortContext;
import net.kuujo.vertigo.util.serialization.Serializer;
import net.kuujo.vertigo.util.serialization.SerializerFactory;
import org.vertx.java.core.json.JsonObject;

public class DefaultInputContext
extends DefaultIOContext<InputContext>
implements InputContext {
    private Collection<InputPortContext> ports = new ArrayList<InputPortContext>();

    public static InputContext fromJson(JsonObject context) {
        Serializer serializer = SerializerFactory.getSerializer(DefaultInstanceContext.class);
        DefaultInputContext input = (DefaultInputContext)serializer.deserializeObject(context.getObject("input"), DefaultInputContext.class);
        DefaultInstanceContext instance = DefaultInstanceContext.fromJson(context);
        return (InputContext)input.setInstanceContext(instance);
    }

    public static JsonObject toJson(DefaultInputContext context) {
        Serializer serializer = SerializerFactory.getSerializer(DefaultInstanceContext.class);
        JsonObject json = DefaultInstanceContext.toJson(context.instance());
        return json.putObject("input", serializer.serializeToObject((Object)context));
    }

    @Override
    public Collection<InputPortContext> ports() {
        return this.ports;
    }

    @Override
    public String address() {
        return null;
    }

    @Override
    public void notify(InputContext update) {
        if (update == null) {
            for (InputPortContext port : this.ports) {
                port.notify(null);
            }
            this.ports.clear();
        } else {
            Iterator<InputPortContext> iter = this.ports.iterator();
            while (iter.hasNext()) {
                InputPortContext port = iter.next();
                InputPortContext match = null;
                for (InputPortContext p : update.ports()) {
                    if (!port.name().equals(p.name())) continue;
                    match = p;
                    break;
                }
                if (match != null) {
                    port.notify(match);
                    continue;
                }
                port.notify(null);
                iter.remove();
            }
            for (InputPortContext port : update.ports()) {
                if (this.ports.contains(port)) continue;
                this.ports.add(port);
            }
        }
        super.notify(this);
    }

    public static class Builder
    extends BaseContext.Builder<Builder, DefaultInputContext> {
        private Builder() {
            super(new DefaultInputContext());
        }

        private Builder(DefaultInputContext context) {
            super(context);
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static Builder newBuilder(DefaultInputContext context) {
            return new Builder(context);
        }

        public Builder setPorts(DefaultInputPortContext ... ports) {
            ((DefaultInputContext)this.context).ports = new ArrayList();
            for (DefaultInputPortContext port : ports) {
                ((DefaultInputContext)this.context).ports.add(port.setInput((InputContext)((Object)this.context)));
            }
            return this;
        }

        public Builder setPorts(Collection<DefaultInputPortContext> ports) {
            ((DefaultInputContext)this.context).ports = new ArrayList();
            for (DefaultInputPortContext port : ports) {
                ((DefaultInputContext)this.context).ports.add(port.setInput((InputContext)((Object)this.context)));
            }
            return this;
        }

        public Builder addPort(DefaultInputPortContext port) {
            ((DefaultInputContext)this.context).ports.add(port.setInput((InputContext)((Object)this.context)));
            return this;
        }

        public Builder removePort(InputPortContext port) {
            ((DefaultInputContext)this.context).ports.remove(port);
            return this;
        }
    }
}

