/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.io.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.kuujo.vertigo.io.InputCollector;
import net.kuujo.vertigo.io.InputContext;
import net.kuujo.vertigo.io.impl.DefaultInputContext;
import net.kuujo.vertigo.io.port.InputPort;
import net.kuujo.vertigo.io.port.InputPortContext;
import net.kuujo.vertigo.io.port.impl.DefaultInputPort;
import net.kuujo.vertigo.io.port.impl.DefaultInputPortContext;
import net.kuujo.vertigo.util.CountingCompletionHandler;
import net.kuujo.vertigo.util.Observer;
import net.kuujo.vertigo.util.Task;
import net.kuujo.vertigo.util.TaskRunner;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.impl.DefaultFutureResult;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;

public class DefaultInputCollector
implements InputCollector,
Observer<InputContext> {
    private static final Logger log = LoggerFactory.getLogger(DefaultInputCollector.class);
    private final Vertx vertx;
    private InputContext context;
    private final Map<String, InputPort> ports = new HashMap<String, InputPort>();
    private final TaskRunner tasks = new TaskRunner();
    private boolean started;

    public DefaultInputCollector(Vertx vertx) {
        this.vertx = vertx;
    }

    public DefaultInputCollector(Vertx vertx, InputContext context) {
        this.vertx = vertx;
        this.context = context;
        context.registerObserver(this);
    }

    @Override
    public Collection<InputPort> ports() {
        return this.ports.values();
    }

    @Override
    public InputPort port(String name) {
        InputPort port = this.ports.get(name);
        if (port == null) {
            InputPortContext portContext = null;
            for (InputPortContext input : this.context.ports()) {
                if (!input.name().equals(name)) continue;
                portContext = input;
                break;
            }
            if (portContext == null) {
                portContext = (InputPortContext)((DefaultInputPortContext.Builder)DefaultInputPortContext.Builder.newBuilder().setAddress(UUID.randomUUID().toString())).setName(name).build();
                DefaultInputContext.Builder.newBuilder((DefaultInputContext)this.context).addPort((DefaultInputPortContext)portContext);
            }
            port = new DefaultInputPort(this.vertx, portContext);
            this.ports.put(name, (InputPort)port.open());
        }
        return port;
    }

    public void update(final InputContext update) {
        this.tasks.runTask((Handler)new Handler<Task>(){

            public void handle(final Task task) {
                ArrayList<DefaultInputPort> newPorts = new ArrayList<DefaultInputPort>();
                for (InputPortContext inputPortContext : update.ports()) {
                    boolean bl = false;
                    for (InputPort port : DefaultInputCollector.this.ports.values()) {
                        if (!port.name().equals(inputPortContext.name())) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    newPorts.add(new DefaultInputPort(DefaultInputCollector.this.vertx, inputPortContext));
                }
                if (DefaultInputCollector.this.started) {
                    final CountingCompletionHandler counter = new CountingCompletionHandler(newPorts.size());
                    counter.setHandler((Handler)new Handler<AsyncResult<Void>>(){

                        public void handle(AsyncResult<Void> result) {
                            task.complete();
                        }
                    });
                    for (final InputPort inputPort : newPorts) {
                        inputPort.open(new Handler<AsyncResult<Void>>(){

                            public void handle(AsyncResult<Void> result) {
                                if (result.failed()) {
                                    log.error((Object)("Failed to open input port " + inputPort.name()));
                                } else {
                                    DefaultInputCollector.this.ports.put(inputPort.name(), inputPort);
                                }
                                counter.succeed();
                            }
                        });
                    }
                } else {
                    for (InputPort inputPort : newPorts) {
                        DefaultInputCollector.this.ports.put(inputPort.name(), inputPort);
                    }
                    task.complete();
                }
            }
        });
    }

    @Override
    public InputCollector open() {
        return this.open((Handler)null);
    }

    @Override
    public InputCollector open(final Handler<AsyncResult<Void>> doneHandler) {
        this.tasks.runTask((Handler)new Handler<Task>(){

            public void handle(final Task task) {
                if (!DefaultInputCollector.this.started) {
                    final CountingCompletionHandler startCounter = new CountingCompletionHandler(DefaultInputCollector.this.context.ports().size());
                    startCounter.setHandler((Handler)new Handler<AsyncResult<Void>>(){

                        public void handle(AsyncResult<Void> result) {
                            if (result.failed()) {
                                new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                            } else {
                                new DefaultFutureResult((Object)null).setHandler(doneHandler);
                            }
                            task.complete();
                        }
                    });
                    for (InputPortContext port : DefaultInputCollector.this.context.ports()) {
                        if (DefaultInputCollector.this.ports.containsKey(port.name())) {
                            ((DefaultInputPort)DefaultInputCollector.this.ports.get(port.name())).open((Handler)new Handler<AsyncResult<Void>>(){

                                public void handle(AsyncResult<Void> result) {
                                    if (result.failed()) {
                                        startCounter.fail(result.cause());
                                    } else {
                                        startCounter.succeed();
                                    }
                                }
                            });
                            continue;
                        }
                        DefaultInputCollector.this.ports.put(port.name(), new DefaultInputPort(DefaultInputCollector.this.vertx, port).open((Handler)new Handler<AsyncResult<Void>>(){

                            public void handle(AsyncResult<Void> result) {
                                if (result.failed()) {
                                    startCounter.fail(result.cause());
                                } else {
                                    startCounter.succeed();
                                }
                            }
                        }));
                    }
                    DefaultInputCollector.this.started = true;
                } else {
                    new DefaultFutureResult((Object)null).setHandler(doneHandler);
                    task.complete();
                }
            }
        });
        return this;
    }

    @Override
    public void close() {
        this.close(null);
    }

    @Override
    public void close(final Handler<AsyncResult<Void>> doneHandler) {
        this.tasks.runTask((Handler)new Handler<Task>(){

            public void handle(final Task task) {
                if (DefaultInputCollector.this.started) {
                    final CountingCompletionHandler stopCounter = new CountingCompletionHandler(DefaultInputCollector.this.ports.size());
                    stopCounter.setHandler((Handler)new Handler<AsyncResult<Void>>(){

                        public void handle(AsyncResult<Void> result) {
                            if (result.failed()) {
                                new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                            } else {
                                DefaultInputCollector.this.ports.clear();
                                DefaultInputCollector.this.started = false;
                                new DefaultFutureResult((Object)null).setHandler(doneHandler);
                            }
                            task.complete();
                        }
                    });
                    for (InputPort port : DefaultInputCollector.this.ports.values()) {
                        port.close(new Handler<AsyncResult<Void>>(){

                            public void handle(AsyncResult<Void> result) {
                                if (result.failed()) {
                                    stopCounter.fail(result.cause());
                                } else {
                                    stopCounter.succeed();
                                }
                            }
                        });
                    }
                } else {
                    new DefaultFutureResult((Object)null).setHandler(doneHandler);
                    task.complete();
                }
            }
        });
    }
}

