/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.io;

import net.kuujo.vertigo.io.Output;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;

public class Feeder<T extends Output<T>> {
    private static final long DEFAULT_FEED_DELAY = 10L;
    private final T output;
    private final Vertx vertx;
    private Handler<T> feedHandler;
    private boolean fed;
    private long feedDelay = 10L;
    private long feedTimer;
    private final Handler<Void> feedRunner = new Handler<Void>(){

        public void handle(Void _) {
            int before = Feeder.this.output.size();
            Feeder.this.feedHandler.handle((Object)Feeder.this.output);
            int after = Feeder.this.output.size();
            Feeder.this.fed = after > before;
            Feeder.this.doFeed();
        }
    };
    private final Handler<Long> recursiveRunner = new Handler<Long>(){

        public void handle(Long timerID) {
            Feeder.this.doFeed();
        }
    };

    public static <T extends Output<T>> Feeder<T> createFeeder(T output) {
        return new Feeder<T>(output);
    }

    public Feeder(T output) {
        this.output = output;
        this.vertx = output.vertx();
    }

    public Feeder<T> feedHandler(Handler<T> handler) {
        this.feedHandler = handler;
        return this;
    }

    public Feeder<T> setFeedDelay(long feedDelay) {
        this.feedDelay = feedDelay;
        return this;
    }

    public long getFeedDelay() {
        return this.feedDelay;
    }

    public void start() {
        this.doFeed();
    }

    private void doFeed() {
        if (this.fed && !this.output.sendQueueFull()) {
            this.fed = false;
            this.vertx.runOnContext(this.feedRunner);
        } else {
            this.feedTimer = this.vertx.setTimer(this.feedDelay, this.recursiveRunner);
        }
    }

    public void stop() {
        if (this.feedTimer > 0L) {
            this.vertx.cancelTimer(this.feedTimer);
        }
    }
}

