/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.impl;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashSet;
import java.util.Set;
import net.kuujo.vertigo.Context;
import net.kuujo.vertigo.util.Observer;
import net.kuujo.vertigo.util.serialization.Serializer;
import net.kuujo.vertigo.util.serialization.SerializerFactory;

public abstract class BaseContext<T extends Context<T>>
implements Context<T> {
    private static final Serializer serializer = SerializerFactory.getSerializer(BaseContext.class);
    @JsonIgnore
    protected final Set<Observer<T>> observers = new HashSet<Observer<T>>();
    protected String version;
    protected String address;

    public T registerObserver(Observer<T> observer) {
        this.observers.add(observer);
        return (T)this;
    }

    public T unregisterObserver(Observer<T> observer) {
        this.observers.remove(observer);
        return (T)this;
    }

    public void notify(T object) {
        for (Observer<T> observer : this.observers) {
            object.registerObserver(observer);
            observer.update(object);
        }
    }

    public String toString() {
        return this.address();
    }

    public boolean equals(Object other) {
        return other instanceof BaseContext && ((BaseContext)other).address().equals(this.address());
    }

    public int hashCode() {
        return this.address().hashCode();
    }

    public T copy() {
        return (T)((Context)serializer.deserializeString(serializer.serializeToString((Object)this), this.getClass()));
    }

    public static abstract class Builder<T extends Builder<T, U>, U extends BaseContext> {
        protected final U context;

        protected Builder(U context) {
            this.context = context;
        }

        public T setAddress(String address) {
            ((BaseContext)this.context).address = address;
            return (T)this;
        }

        public U build() {
            return this.context;
        }
    }
}

