/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.hook;

import com.fasterxml.jackson.annotation.JsonIgnore;
import net.kuujo.vertigo.component.Component;
import net.kuujo.vertigo.component.InstanceContext;
import net.kuujo.vertigo.hook.ComponentHook;
import org.vertx.java.core.eventbus.EventBus;
import org.vertx.java.core.json.JsonObject;

public class MetricsHook
implements ComponentHook {
    @JsonIgnore
    private InstanceContext context;
    @JsonIgnore
    private EventBus eventBus;
    private String address;

    public MetricsHook() {
    }

    public MetricsHook(String address) {
        this.address = address;
    }

    @Override
    public void handleStart(Component component) {
        this.context = component.context();
        this.eventBus = component.vertx().eventBus();
    }

    @Override
    public void handleReceive(Object message) {
        this.eventBus.send(this.address, new JsonObject().putString("action", "mark").putString("name", String.format("%s.receive", this.context.address())));
    }

    @Override
    public void handleSend(Object message) {
        this.eventBus.send(this.address, new JsonObject().putString("action", "mark").putString("name", String.format("%s.send", this.context.address())));
    }

    @Override
    public void handleStop(Component component) {
    }
}

