/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.component.impl;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.kuujo.vertigo.component.ComponentConfig;
import net.kuujo.vertigo.component.VerticleConfig;
import net.kuujo.vertigo.hook.ComponentHook;
import net.kuujo.vertigo.network.NetworkConfig;
import org.vertx.java.core.json.JsonObject;

public class DefaultVerticleConfig
implements VerticleConfig {
    private static final int DEFAULT_NUM_INSTANCES = 1;
    private static final String DEFAULT_GROUP = "__DEFAULT__";
    private String name;
    private Map<String, Object> config;
    private int instances = 1;
    private String group = "__DEFAULT__";
    private List<ComponentHook> hooks = new ArrayList<ComponentHook>();
    private String main;
    private boolean worker = false;
    @JsonProperty(value="multi-threaded")
    private boolean multiThreaded = false;

    public DefaultVerticleConfig() {
    }

    public DefaultVerticleConfig(String name, String main, NetworkConfig network) {
        this.name = name;
        this.main = main;
    }

    @Override
    public ComponentConfig.Type getType() {
        return ComponentConfig.Type.VERTICLE;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public JsonObject getConfig() {
        return this.config != null ? new JsonObject(this.config) : new JsonObject();
    }

    @Override
    public VerticleConfig setConfig(JsonObject config) {
        this.config = config != null ? config.toMap() : new HashMap();
        return this;
    }

    @Override
    public int getInstances() {
        return this.instances;
    }

    @Override
    public VerticleConfig setInstances(int instances) {
        if (instances < 1) {
            throw new IllegalArgumentException("Instances must be a positive integer.");
        }
        this.instances = instances;
        return this;
    }

    @Override
    public VerticleConfig setGroup(String group) {
        this.group = group != null ? group : DEFAULT_GROUP;
        return this;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public VerticleConfig addHook(ComponentHook hook) {
        this.hooks.add(hook);
        return this;
    }

    @Override
    public List<ComponentHook> getHooks() {
        return this.hooks;
    }

    @Override
    public VerticleConfig setMain(String main) {
        this.main = main;
        return this;
    }

    @Override
    public String getMain() {
        return this.main;
    }

    @Override
    public VerticleConfig setWorker(boolean isWorker) {
        this.worker = isWorker;
        if (!this.worker) {
            this.multiThreaded = false;
        }
        return this;
    }

    @Override
    public boolean isWorker() {
        return this.worker;
    }

    @Override
    public VerticleConfig setMultiThreaded(boolean isMultiThreaded) {
        this.multiThreaded = isMultiThreaded;
        return this;
    }

    @Override
    public boolean isMultiThreaded() {
        return this.multiThreaded;
    }
}

