/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.component.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.kuujo.vertigo.component.ComponentConfig;
import net.kuujo.vertigo.component.ModuleConfig;
import net.kuujo.vertigo.hook.ComponentHook;
import net.kuujo.vertigo.network.NetworkConfig;
import org.vertx.java.core.json.JsonObject;
import org.vertx.java.platform.impl.ModuleIdentifier;

public class DefaultModuleConfig
implements ModuleConfig {
    private static final int DEFAULT_NUM_INSTANCES = 1;
    private static final String DEFAULT_GROUP = "__DEFAULT__";
    private String name;
    private Map<String, Object> config;
    private int instances = 1;
    private String group = "__DEFAULT__";
    private List<ComponentHook> hooks = new ArrayList<ComponentHook>();
    private String module;

    public DefaultModuleConfig() {
    }

    public DefaultModuleConfig(String name, String moduleName, NetworkConfig network) {
        this.name = name;
        this.setModule(moduleName);
    }

    @Override
    public ComponentConfig.Type getType() {
        return ComponentConfig.Type.MODULE;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public JsonObject getConfig() {
        return this.config != null ? new JsonObject(this.config) : new JsonObject();
    }

    @Override
    public ModuleConfig setConfig(JsonObject config) {
        this.config = config != null ? config.toMap() : new HashMap();
        return this;
    }

    @Override
    public int getInstances() {
        return this.instances;
    }

    @Override
    public ModuleConfig setInstances(int instances) {
        if (instances < 1) {
            throw new IllegalArgumentException("Instances must be a positive integer.");
        }
        this.instances = instances;
        return this;
    }

    @Override
    public ModuleConfig setGroup(String group) {
        this.group = group != null ? group : DEFAULT_GROUP;
        return this;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public ModuleConfig addHook(ComponentHook hook) {
        this.hooks.add(hook);
        return this;
    }

    @Override
    public List<ComponentHook> getHooks() {
        return this.hooks;
    }

    @Override
    public ModuleConfig setModule(String moduleName) {
        new ModuleIdentifier(moduleName);
        this.module = moduleName;
        return this;
    }

    @Override
    public String getModule() {
        return this.module;
    }
}

