/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.component.impl;

import net.kuujo.vertigo.VertigoException;
import net.kuujo.vertigo.cluster.Cluster;
import net.kuujo.vertigo.cluster.data.MapEvent;
import net.kuujo.vertigo.cluster.data.WatchableAsyncMap;
import net.kuujo.vertigo.cluster.data.impl.WrappedWatchableAsyncMap;
import net.kuujo.vertigo.cluster.impl.ClusterFactory;
import net.kuujo.vertigo.component.ComponentCoordinator;
import net.kuujo.vertigo.component.InstanceContext;
import net.kuujo.vertigo.component.impl.DefaultInstanceContext;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.impl.DefaultFutureResult;
import org.vertx.java.core.json.JsonObject;
import org.vertx.java.platform.Container;

public class DefaultComponentCoordinator
implements ComponentCoordinator {
    private final String address;
    private final Vertx vertx;
    private final ClusterFactory clusterFactory;
    private Cluster cluster;
    private WatchableAsyncMap<String, String> data;
    private InstanceContext currentContext;
    private Handler<Void> resumeHandler;
    private Handler<Void> pauseHandler;
    private boolean paused = true;
    private final Handler<MapEvent<String, String>> instanceHandler = new Handler<MapEvent<String, String>>(){

        public void handle(MapEvent<String, String> event) {
            if (DefaultComponentCoordinator.this.currentContext != null && !event.type().equals((Object)MapEvent.Type.CHANGE)) {
                DefaultComponentCoordinator.this.currentContext.notify(DefaultInstanceContext.fromJson(new JsonObject((String)event.value())));
            }
        }
    };
    private final Handler<MapEvent<String, String>> statusHandler = new Handler<MapEvent<String, String>>(){

        public void handle(MapEvent<String, String> event) {
            if (event.type().equals((Object)MapEvent.Type.CREATE) || event.type().equals((Object)MapEvent.Type.UPDATE)) {
                DefaultComponentCoordinator.this.paused = false;
                DefaultComponentCoordinator.this.checkResume();
            } else if (event.type().equals((Object)MapEvent.Type.DELETE)) {
                DefaultComponentCoordinator.this.paused = true;
                DefaultComponentCoordinator.this.checkPause();
            }
        }
    };

    public DefaultComponentCoordinator(InstanceContext context, Vertx vertx, Container container) {
        this.address = context.address();
        this.vertx = vertx;
        this.currentContext = context;
        this.clusterFactory = new ClusterFactory(vertx, container);
    }

    @Override
    public String address() {
        return this.address;
    }

    @Override
    public ComponentCoordinator start(final Handler<AsyncResult<InstanceContext>> doneHandler) {
        this.clusterFactory.getCurrentCluster((Handler)new Handler<AsyncResult<Cluster>>(){

            public void handle(AsyncResult<Cluster> result) {
                if (result.failed()) {
                    new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                } else {
                    DefaultComponentCoordinator.this.cluster = (Cluster)result.result();
                    DefaultComponentCoordinator.this.data = (WatchableAsyncMap)new WrappedWatchableAsyncMap(DefaultComponentCoordinator.this.cluster.getMap(DefaultComponentCoordinator.this.currentContext.component().network().address()), DefaultComponentCoordinator.this.vertx);
                    DefaultComponentCoordinator.this.data.watch((Object)DefaultComponentCoordinator.this.address, DefaultComponentCoordinator.this.instanceHandler, (Handler)new Handler<AsyncResult<Void>>(){

                        public void handle(AsyncResult<Void> result) {
                            if (result.failed()) {
                                new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                            } else {
                                DefaultComponentCoordinator.this.data.get((Object)DefaultComponentCoordinator.this.address, (Handler)new Handler<AsyncResult<String>>(){

                                    public void handle(AsyncResult<String> result) {
                                        if (result.failed()) {
                                            new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                                        } else {
                                            if (result.result() != null) {
                                                DefaultComponentCoordinator.this.currentContext.notify(DefaultInstanceContext.fromJson(new JsonObject((String)result.result())));
                                            }
                                            DefaultComponentCoordinator.this.data.watch((Object)DefaultComponentCoordinator.this.currentContext.component().network().status(), DefaultComponentCoordinator.this.statusHandler, (Handler)new Handler<AsyncResult<Void>>(){

                                                public void handle(AsyncResult<Void> result) {
                                                    if (result.failed()) {
                                                        new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                                                    } else {
                                                        new DefaultFutureResult((Object)DefaultComponentCoordinator.this.currentContext).setHandler(doneHandler);
                                                    }
                                                }
                                            });
                                        }
                                    }
                                });
                            }
                        }
                    });
                }
            }
        });
        return this;
    }

    @Override
    public ComponentCoordinator resume() {
        return this.resume(null);
    }

    @Override
    public ComponentCoordinator resume(final Handler<AsyncResult<Void>> doneHandler) {
        if (this.currentContext != null && this.data != null) {
            this.data.put((Object)this.currentContext.status(), (Object)"ready", (Handler)new Handler<AsyncResult<String>>(){

                public void handle(AsyncResult<String> result) {
                    if (result.failed()) {
                        new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                    } else {
                        new DefaultFutureResult((Object)null).setHandler(doneHandler);
                    }
                }
            });
        } else {
            new DefaultFutureResult((Throwable)new VertigoException("No component context available.")).setHandler(doneHandler);
        }
        return this;
    }

    @Override
    public ComponentCoordinator pause() {
        return this.pause(null);
    }

    @Override
    public ComponentCoordinator pause(final Handler<AsyncResult<Void>> doneHandler) {
        if (this.currentContext != null && this.data != null) {
            this.data.remove((Object)this.currentContext.status(), (Handler)new Handler<AsyncResult<String>>(){

                public void handle(AsyncResult<String> result) {
                    if (result.failed()) {
                        new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                    } else {
                        new DefaultFutureResult((Object)null).setHandler(doneHandler);
                    }
                }
            });
        } else {
            new DefaultFutureResult((Throwable)new VertigoException("No component context available.")).setHandler(doneHandler);
        }
        return this;
    }

    @Override
    public ComponentCoordinator resumeHandler(Handler<Void> handler) {
        this.resumeHandler = handler;
        this.checkResume();
        return this;
    }

    private void checkResume() {
        if (!this.paused && this.resumeHandler != null) {
            this.resumeHandler.handle((Object)null);
        }
    }

    @Override
    public ComponentCoordinator pauseHandler(Handler<Void> handler) {
        this.pauseHandler = handler;
        this.checkPause();
        return this;
    }

    private void checkPause() {
        if (this.paused && this.pauseHandler != null) {
            this.pauseHandler.handle((Object)null);
        }
    }

    @Override
    public void stop(final Handler<AsyncResult<Void>> doneHandler) {
        if (this.currentContext != null && this.data != null) {
            this.data.unwatch((Object)this.currentContext.component().network().status(), this.statusHandler, (Handler)new Handler<AsyncResult<Void>>(){

                public void handle(AsyncResult<Void> result) {
                    if (result.failed()) {
                        DefaultComponentCoordinator.this.data.unwatch((Object)DefaultComponentCoordinator.this.address, DefaultComponentCoordinator.this.instanceHandler);
                        new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                    } else {
                        DefaultComponentCoordinator.this.data.unwatch((Object)DefaultComponentCoordinator.this.address, DefaultComponentCoordinator.this.instanceHandler, doneHandler);
                    }
                    DefaultComponentCoordinator.this.currentContext = null;
                }
            });
        } else {
            this.data.unwatch((Object)this.address, this.instanceHandler, doneHandler);
        }
    }
}

