/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.component.impl;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.kuujo.vertigo.component.ComponentContext;
import net.kuujo.vertigo.component.InstanceContext;
import net.kuujo.vertigo.component.ModuleContext;
import net.kuujo.vertigo.component.VerticleContext;
import net.kuujo.vertigo.component.impl.DefaultInstanceContext;
import net.kuujo.vertigo.component.impl.DefaultModuleContext;
import net.kuujo.vertigo.component.impl.DefaultVerticleContext;
import net.kuujo.vertigo.hook.ComponentHook;
import net.kuujo.vertigo.impl.BaseContext;
import net.kuujo.vertigo.network.impl.DefaultNetworkContext;
import net.kuujo.vertigo.util.serialization.Serializer;
import net.kuujo.vertigo.util.serialization.SerializerFactory;
import org.vertx.java.core.json.JsonObject;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=DefaultModuleContext.class, name="module"), @JsonSubTypes.Type(value=DefaultVerticleContext.class, name="verticle")})
public abstract class DefaultComponentContext<T extends ComponentContext<T>>
extends BaseContext<T>
implements ComponentContext<T> {
    private static final String DEFAULT_GROUP = "__DEFAULT__";
    protected String name;
    protected String status;
    protected String group = "__DEFAULT__";
    protected Map<String, Object> config;
    protected List<InstanceContext> instances = new ArrayList<InstanceContext>();
    protected List<ComponentHook> hooks = new ArrayList<ComponentHook>();
    @JsonIgnore
    private DefaultNetworkContext network;

    public static <T extends DefaultComponentContext<T>> T fromJson(JsonObject context) {
        Serializer serializer = SerializerFactory.getSerializer(ComponentContext.class);
        DefaultComponentContext component = (DefaultComponentContext)serializer.deserializeObject(context.getObject("component"), ComponentContext.class);
        DefaultNetworkContext network = DefaultNetworkContext.fromJson(context);
        return (T)((DefaultComponentContext)component.setNetworkContext(network));
    }

    public static JsonObject toJson(ComponentContext context) {
        Serializer serializer = SerializerFactory.getSerializer(ComponentContext.class);
        JsonObject json = DefaultNetworkContext.toJson(context.network());
        json.putObject("component", serializer.serializeToObject((Object)context));
        return json;
    }

    @JsonGetter(value="type")
    protected abstract String type();

    public T setNetworkContext(DefaultNetworkContext network) {
        this.network = network;
        return (T)this;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String address() {
        return this.address;
    }

    @Override
    public String status() {
        return this.status;
    }

    @Override
    public boolean isModule() {
        return false;
    }

    @Override
    public boolean isVerticle() {
        return false;
    }

    @Override
    public JsonObject config() {
        return this.config != null ? new JsonObject(this.config) : new JsonObject();
    }

    @Override
    public List<InstanceContext> instances() {
        for (InstanceContext instance : this.instances) {
            ((DefaultInstanceContext)instance).setComponentContext(this);
        }
        return this.instances;
    }

    @Override
    public int numInstances() {
        return this.instances.size();
    }

    @Override
    public InstanceContext instance(int instanceNumber) {
        for (InstanceContext instance : this.instances) {
            if (instance.number() != instanceNumber) continue;
            return instance;
        }
        return null;
    }

    @Override
    public InstanceContext instance(String address) {
        for (InstanceContext instance : this.instances) {
            if (!instance.address().equals(address)) continue;
            return instance;
        }
        return null;
    }

    @Override
    public String group() {
        return this.group;
    }

    @Override
    public List<ComponentHook> hooks() {
        return this.hooks;
    }

    @Override
    public ModuleContext asModule() {
        return (DefaultModuleContext)this;
    }

    @Override
    public VerticleContext asVerticle() {
        return (DefaultVerticleContext)this;
    }

    @Override
    public DefaultNetworkContext network() {
        return this.network;
    }

    @Override
    public void notify(T update) {
        if (update == null) {
            for (InstanceContext instance : this.instances) {
                instance.notify(null);
            }
            this.instances.clear();
        } else {
            Iterator<InstanceContext> iter = this.instances.iterator();
            while (iter.hasNext()) {
                InstanceContext instance = iter.next();
                InstanceContext match = null;
                for (InstanceContext i : update.instances()) {
                    if (!instance.equals(i)) continue;
                    match = i;
                    break;
                }
                if (match != null) {
                    instance.notify(match);
                    continue;
                }
                instance.notify(null);
                iter.remove();
            }
        }
        super.notify(this);
    }

    @Override
    public String toString() {
        return this.address();
    }
}

