/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.cluster.impl;

import net.kuujo.vertigo.cluster.ClusterManager;
import net.kuujo.vertigo.cluster.ClusterScope;
import net.kuujo.vertigo.cluster.impl.ClusterFactory;
import net.kuujo.vertigo.util.Factories;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.impl.DefaultFutureResult;
import org.vertx.java.platform.Container;

public class ClusterManagerFactory {
    private final Vertx vertx;
    private final Container container;
    private final ClusterFactory clusterFactory;

    public ClusterManagerFactory(Vertx vertx, Container container) {
        this.vertx = vertx;
        this.container = container;
        this.clusterFactory = new ClusterFactory(vertx, container);
    }

    public void getCurrentScope(Handler<AsyncResult<ClusterScope>> resultHandler) {
        this.clusterFactory.getCurrentScope(resultHandler);
    }

    public void getCurrentClusterManager(final Handler<AsyncResult<ClusterManager>> resultHandler) {
        this.clusterFactory.getCurrentScope((Handler)new Handler<AsyncResult<ClusterScope>>(){

            public void handle(AsyncResult<ClusterScope> result) {
                if (result.failed()) {
                    new DefaultFutureResult(result.cause()).setHandler(resultHandler);
                } else {
                    new DefaultFutureResult((Object)ClusterManagerFactory.this.createClusterManager("vertigo", (ClusterScope)result.result())).setHandler(resultHandler);
                }
            }
        });
    }

    public ClusterManager createClusterManager(String address, ClusterScope scope) {
        return Factories.createObject(scope, ClusterManager.class, address, this.vertx, this.container);
    }
}

