/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.cluster.impl;

import net.kuujo.vertigo.cluster.Cluster;
import net.kuujo.vertigo.cluster.ClusterException;
import net.kuujo.vertigo.cluster.ClusterManager;
import net.kuujo.vertigo.cluster.ClusterScope;
import net.kuujo.vertigo.cluster.DeploymentException;
import net.kuujo.vertigo.cluster.data.MapEvent;
import net.kuujo.vertigo.cluster.data.WatchableAsyncMap;
import net.kuujo.vertigo.cluster.data.impl.WrappedWatchableAsyncMap;
import net.kuujo.vertigo.cluster.impl.ClusterFactory;
import net.kuujo.vertigo.impl.ContextBuilder;
import net.kuujo.vertigo.network.ActiveNetwork;
import net.kuujo.vertigo.network.NetworkConfig;
import net.kuujo.vertigo.network.NetworkContext;
import net.kuujo.vertigo.network.impl.DefaultActiveNetwork;
import net.kuujo.vertigo.network.impl.DefaultNetworkContext;
import net.kuujo.vertigo.network.manager.NetworkManager;
import net.kuujo.vertigo.util.Configs;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.eventbus.EventBus;
import org.vertx.java.core.impl.DefaultFutureResult;
import org.vertx.java.core.json.JsonObject;
import org.vertx.java.platform.Container;

abstract class AbstractClusterManager
implements ClusterManager {
    protected final Vertx vertx;
    protected final Container container;
    protected final EventBus eventBus;
    protected final Cluster cluster;

    protected AbstractClusterManager(Vertx vertx, Container container, Cluster cluster) {
        this.vertx = vertx;
        this.container = container;
        this.eventBus = vertx.eventBus();
        this.cluster = cluster;
    }

    private Cluster createNetworkCluster(NetworkContext context) {
        if (context.cluster().scope().equals((Object)ClusterScope.CLUSTER) && this.scope().equals((Object)ClusterScope.CLUSTER)) {
            return new ClusterFactory(this.vertx, this.container).createCluster(context.cluster().address(), ClusterScope.CLUSTER);
        }
        return new ClusterFactory(this.vertx, this.container).createCluster(context.cluster().address(), ClusterScope.LOCAL);
    }

    @Override
    public ClusterManager getNetwork(String name, final Handler<AsyncResult<ActiveNetwork>> resultHandler) {
        WrappedWatchableAsyncMap data = new WrappedWatchableAsyncMap(this.cluster.getMap(name), this.vertx);
        data.get((Object)name, (Handler)new Handler<AsyncResult<String>>((WatchableAsyncMap)data, name){
            final /* synthetic */ WatchableAsyncMap val$data;
            final /* synthetic */ String val$name;
            {
                this.val$data = watchableAsyncMap;
                this.val$name = string;
            }

            public void handle(AsyncResult<String> result) {
                if (result.failed()) {
                    new DefaultFutureResult((Throwable)new ClusterException(result.cause())).setHandler(resultHandler);
                } else if (result.result() != null) {
                    final DefaultNetworkContext context = DefaultNetworkContext.fromJson(new JsonObject((String)result.result()));
                    Cluster contextCluster = AbstractClusterManager.this.createNetworkCluster(context);
                    contextCluster.isDeployed(context.name(), (Handler)new Handler<AsyncResult<Boolean>>(){

                        public void handle(AsyncResult<Boolean> result) {
                            if (result.failed()) {
                                new DefaultFutureResult((Throwable)new DeploymentException(result.cause())).setHandler(resultHandler);
                            } else if (!((Boolean)result.result()).booleanValue()) {
                                new DefaultFutureResult((Throwable)new DeploymentException("Network is not deployed.")).setHandler(resultHandler);
                            } else {
                                final DefaultActiveNetwork active = new DefaultActiveNetwork(context.config(), AbstractClusterManager.this);
                                val$data.watch((Object)val$name, (Handler)new Handler<MapEvent<String, String>>(){

                                    public void handle(MapEvent<String, String> event) {
                                        String scontext = (String)event.value();
                                        if (scontext != null && scontext.length() > 0) {
                                            active.update(DefaultNetworkContext.fromJson(new JsonObject(scontext)));
                                        }
                                    }
                                }, (Handler)new Handler<AsyncResult<Void>>(){

                                    public void handle(AsyncResult<Void> result) {
                                        if (result.failed()) {
                                            new DefaultFutureResult((Throwable)new ClusterException(result.cause())).setHandler(resultHandler);
                                        } else {
                                            new DefaultFutureResult((Object)active).setHandler(resultHandler);
                                        }
                                    }
                                });
                            }
                        }
                    });
                }
            }
        });
        return this;
    }

    @Override
    public ClusterManager isRunning(String name, final Handler<AsyncResult<Boolean>> resultHandler) {
        WrappedWatchableAsyncMap data = new WrappedWatchableAsyncMap(this.cluster.getMap(name), this.vertx);
        data.get((Object)name, (Handler)new Handler<AsyncResult<String>>(){

            public void handle(AsyncResult<String> result) {
                if (result.failed()) {
                    new DefaultFutureResult((Throwable)new ClusterException(result.cause())).setHandler(resultHandler);
                } else if (result.result() == null) {
                    new DefaultFutureResult((Object)false).setHandler(resultHandler);
                } else {
                    DefaultNetworkContext context = DefaultNetworkContext.fromJson(new JsonObject((String)result.result()));
                    Cluster contextCluster = AbstractClusterManager.this.createNetworkCluster(context);
                    contextCluster.isDeployed(context.name(), resultHandler);
                }
            }
        });
        return this;
    }

    @Override
    public ClusterManager deployNetwork(NetworkConfig network) {
        return this.deployNetwork(network, null);
    }

    @Override
    public ClusterManager deployNetwork(final NetworkConfig network, final Handler<AsyncResult<ActiveNetwork>> doneHandler) {
        WrappedWatchableAsyncMap data = new WrappedWatchableAsyncMap(this.cluster.getMap(network.getName()), this.vertx);
        data.get((Object)network.getName(), (Handler)new Handler<AsyncResult<String>>(){

            public void handle(AsyncResult<String> result) {
                if (result.failed()) {
                    new DefaultFutureResult((Throwable)new ClusterException(result.cause())).setHandler(doneHandler);
                } else {
                    NetworkContext updatedContext = result.result() == null ? ContextBuilder.buildContext(network) : ContextBuilder.buildContext(Configs.mergeNetworks(DefaultNetworkContext.fromJson(new JsonObject((String)result.result())).config(), network));
                    final NetworkContext context = updatedContext;
                    final Cluster contextCluster = AbstractClusterManager.this.createNetworkCluster(context);
                    contextCluster.isDeployed(context.name(), (Handler)new Handler<AsyncResult<Boolean>>(){

                        public void handle(AsyncResult<Boolean> result) {
                            if (result.failed()) {
                                new DefaultFutureResult((Throwable)new DeploymentException(result.cause())).setHandler(doneHandler);
                            } else if (((Boolean)result.result()).booleanValue()) {
                                AbstractClusterManager.this.doDeployNetwork(context, (Handler<AsyncResult<ActiveNetwork>>)doneHandler);
                            } else {
                                contextCluster.deployVerticle(context.name(), NetworkManager.class.getName(), new JsonObject().putString("name", context.name()), 1, (Handler)new Handler<AsyncResult<String>>(){

                                    public void handle(AsyncResult<String> result) {
                                        if (result.failed()) {
                                            new DefaultFutureResult((Throwable)new ClusterException(result.cause())).setHandler(doneHandler);
                                        } else {
                                            AbstractClusterManager.this.doDeployNetwork(context, (Handler<AsyncResult<ActiveNetwork>>)doneHandler);
                                        }
                                    }
                                });
                            }
                        }
                    });
                }
            }
        });
        return this;
    }

    private void doDeployNetwork(NetworkContext context, final Handler<AsyncResult<ActiveNetwork>> doneHandler) {
        WrappedWatchableAsyncMap data = new WrappedWatchableAsyncMap(this.cluster.getMap(context.name()), this.vertx);
        final DefaultActiveNetwork active = new DefaultActiveNetwork(context.config(), this);
        data.watch((Object)context.name(), (Handler)new Handler<MapEvent<String, String>>(){

            public void handle(MapEvent<String, String> event) {
                String scontext = (String)event.value();
                if (scontext != null && scontext.length() > 0) {
                    active.update(DefaultNetworkContext.fromJson(new JsonObject(scontext)));
                }
            }
        }, (Handler)new Handler<AsyncResult<Void>>((WatchableAsyncMap)data, context, active){
            final /* synthetic */ WatchableAsyncMap val$data;
            final /* synthetic */ NetworkContext val$context;
            final /* synthetic */ DefaultActiveNetwork val$active;
            {
                this.val$data = watchableAsyncMap;
                this.val$context = networkContext;
                this.val$active = defaultActiveNetwork;
            }

            public void handle(AsyncResult<Void> result) {
                if (result.failed()) {
                    new DefaultFutureResult((Throwable)new ClusterException(result.cause())).setHandler(doneHandler);
                } else {
                    this.val$data.watch((Object)this.val$context.status(), (Handler)new Handler<MapEvent<String, String>>(){

                        public void handle(MapEvent<String, String> event) {
                            if (event.type().equals((Object)MapEvent.Type.CREATE) && ((String)event.value()).equals(val$context.version())) {
                                val$data.unwatch((Object)val$context.status(), (Handler)this, (Handler)new Handler<AsyncResult<Void>>(){

                                    public void handle(AsyncResult<Void> result) {
                                        new DefaultFutureResult((Object)val$active).setHandler(doneHandler);
                                    }
                                });
                            }
                        }
                    }, (Handler)new Handler<AsyncResult<Void>>(){

                        public void handle(AsyncResult<Void> result) {
                            if (result.failed()) {
                                new DefaultFutureResult((Throwable)new ClusterException(result.cause())).setHandler(doneHandler);
                            } else {
                                val$data.put((Object)val$context.address(), (Object)DefaultNetworkContext.toJson(val$context).encode(), (Handler)new Handler<AsyncResult<String>>(){

                                    public void handle(AsyncResult<String> result) {
                                        if (result.failed()) {
                                            new DefaultFutureResult((Throwable)new ClusterException(result.cause())).setHandler(doneHandler);
                                        }
                                    }
                                });
                            }
                        }
                    });
                }
            }
        });
    }

    @Override
    public ClusterManager undeployNetwork(String name) {
        return this.undeployNetwork(name, null);
    }

    @Override
    public ClusterManager undeployNetwork(String name, final Handler<AsyncResult<Void>> doneHandler) {
        WrappedWatchableAsyncMap data = new WrappedWatchableAsyncMap(this.cluster.getMap(name), this.vertx);
        data.get((Object)name, (Handler)new Handler<AsyncResult<String>>((WatchableAsyncMap)data){
            final /* synthetic */ WatchableAsyncMap val$data;
            {
                this.val$data = watchableAsyncMap;
            }

            public void handle(AsyncResult<String> result) {
                if (result.failed()) {
                    new DefaultFutureResult((Throwable)new ClusterException(result.cause())).setHandler(doneHandler);
                } else if (result.result() == null) {
                    new DefaultFutureResult((Throwable)new DeploymentException("Network is not deployed.")).setHandler(doneHandler);
                } else {
                    final DefaultNetworkContext context = DefaultNetworkContext.fromJson(new JsonObject((String)result.result()));
                    final Cluster contextCluster = AbstractClusterManager.this.createNetworkCluster(context);
                    contextCluster.isDeployed(context.name(), (Handler)new Handler<AsyncResult<Boolean>>(){

                        public void handle(AsyncResult<Boolean> result) {
                            if (result.failed()) {
                                new DefaultFutureResult((Throwable)new ClusterException(result.cause())).setHandler(doneHandler);
                            } else if (!((Boolean)result.result()).booleanValue()) {
                                new DefaultFutureResult((Throwable)new DeploymentException("Network is not deployed.")).setHandler(doneHandler);
                            } else {
                                val$data.watch((Object)context.status(), MapEvent.Type.CHANGE, (Handler)new Handler<MapEvent<String, String>>(){

                                    public void handle(MapEvent<String, String> event) {
                                        if (event.value() != null && ((String)event.value()).equals("")) {
                                            val$data.unwatch((Object)context.status(), MapEvent.Type.CHANGE, (Handler)this, (Handler)new Handler<AsyncResult<Void>>(){

                                                public void handle(AsyncResult<Void> result) {
                                                    contextCluster.undeployVerticle(context.name(), (Handler)new Handler<AsyncResult<Void>>(){

                                                        public void handle(AsyncResult<Void> result) {
                                                            if (result.failed()) {
                                                                new DefaultFutureResult((Throwable)new DeploymentException(result.cause())).setHandler(doneHandler);
                                                            } else {
                                                                val$data.remove((Object)context.status());
                                                                new DefaultFutureResult((Object)null).setHandler(doneHandler);
                                                            }
                                                        }
                                                    });
                                                }
                                            });
                                        }
                                    }
                                }, (Handler)new Handler<AsyncResult<Void>>(){

                                    public void handle(AsyncResult<Void> result) {
                                        if (result.failed()) {
                                            new DefaultFutureResult((Throwable)new ClusterException(result.cause())).setHandler(doneHandler);
                                        } else {
                                            val$data.remove((Object)context.name(), (Handler)new Handler<AsyncResult<String>>(){

                                                public void handle(AsyncResult<String> result) {
                                                    if (result.failed()) {
                                                        new DefaultFutureResult((Throwable)new ClusterException(result.cause())).setHandler(doneHandler);
                                                    }
                                                }
                                            });
                                        }
                                    }
                                });
                            }
                        }
                    });
                }
            }
        });
        return this;
    }

    @Override
    public ClusterManager undeployNetwork(NetworkConfig network) {
        return this.undeployNetwork(network, null);
    }

    @Override
    public ClusterManager undeployNetwork(final NetworkConfig network, final Handler<AsyncResult<Void>> doneHandler) {
        WrappedWatchableAsyncMap data = new WrappedWatchableAsyncMap(this.cluster.getMap(network.getName()), this.vertx);
        data.get((Object)network.getName(), (Handler)new Handler<AsyncResult<String>>((WatchableAsyncMap)data){
            final /* synthetic */ WatchableAsyncMap val$data;
            {
                this.val$data = watchableAsyncMap;
            }

            public void handle(AsyncResult<String> result) {
                if (result.failed()) {
                    new DefaultFutureResult((Throwable)new ClusterException(result.cause())).setHandler(doneHandler);
                } else {
                    final DefaultNetworkContext context = DefaultNetworkContext.fromJson(new JsonObject((String)result.result()));
                    final Cluster contextCluster = AbstractClusterManager.this.createNetworkCluster(context);
                    contextCluster.isDeployed(context.name(), (Handler)new Handler<AsyncResult<Boolean>>(){

                        public void handle(AsyncResult<Boolean> result) {
                            if (result.failed()) {
                                new DefaultFutureResult((Throwable)new ClusterException(result.cause())).setHandler(doneHandler);
                            } else if (!((Boolean)result.result()).booleanValue()) {
                                new DefaultFutureResult((Throwable)new DeploymentException("Network is not deployed.")).setHandler(doneHandler);
                            } else {
                                NetworkConfig updatedConfig = Configs.unmergeNetworks(context.config(), network);
                                final NetworkContext context2 = ContextBuilder.buildContext(updatedConfig);
                                if (context2.components().isEmpty()) {
                                    val$data.watch((Object)context2.status(), MapEvent.Type.CHANGE, (Handler)new Handler<MapEvent<String, String>>(){

                                        public void handle(MapEvent<String, String> event) {
                                            if (event.value() != null && ((String)event.value()).equals("")) {
                                                val$data.unwatch((Object)context2.status(), MapEvent.Type.CHANGE, (Handler)this, (Handler)new Handler<AsyncResult<Void>>(){

                                                    public void handle(AsyncResult<Void> result) {
                                                        contextCluster.undeployVerticle(context2.name(), (Handler)new Handler<AsyncResult<Void>>(){

                                                            public void handle(AsyncResult<Void> result) {
                                                                if (result.failed()) {
                                                                    new DefaultFutureResult((Throwable)new DeploymentException(result.cause())).setHandler(doneHandler);
                                                                } else {
                                                                    val$data.remove((Object)context2.status());
                                                                    new DefaultFutureResult((Object)null).setHandler(doneHandler);
                                                                }
                                                            }
                                                        });
                                                    }
                                                });
                                            }
                                        }
                                    }, (Handler)new Handler<AsyncResult<Void>>(){

                                        public void handle(AsyncResult<Void> result) {
                                            if (result.failed()) {
                                                new DefaultFutureResult((Throwable)new ClusterException(result.cause())).setHandler(doneHandler);
                                            } else {
                                                val$data.remove((Object)context2.name(), (Handler)new Handler<AsyncResult<String>>(){

                                                    public void handle(AsyncResult<String> result) {
                                                        if (result.failed()) {
                                                            new DefaultFutureResult((Throwable)new ClusterException(result.cause())).setHandler(doneHandler);
                                                        }
                                                    }
                                                });
                                            }
                                        }
                                    });
                                } else {
                                    val$data.watch((Object)context2.status(), MapEvent.Type.CHANGE, (Handler)new Handler<MapEvent<String, String>>(){

                                        public void handle(MapEvent<String, String> event) {
                                            if (event.value() != null && ((String)event.value()).equals(context2.version())) {
                                                val$data.unwatch((Object)context2.status(), (Handler)this, (Handler)new Handler<AsyncResult<Void>>(){

                                                    public void handle(AsyncResult<Void> result) {
                                                        new DefaultFutureResult((Object)null).setHandler(doneHandler);
                                                    }
                                                });
                                            }
                                        }
                                    }, (Handler)new Handler<AsyncResult<Void>>(){

                                        public void handle(AsyncResult<Void> result) {
                                            if (result.failed()) {
                                                new DefaultFutureResult((Throwable)new ClusterException(result.cause())).setHandler(doneHandler);
                                            } else {
                                                val$data.put((Object)context2.address(), (Object)DefaultNetworkContext.toJson(context2).encode(), (Handler)new Handler<AsyncResult<String>>(){

                                                    public void handle(AsyncResult<String> result) {
                                                        if (result.failed()) {
                                                            new DefaultFutureResult((Throwable)new ClusterException(result.cause())).setHandler(doneHandler);
                                                        }
                                                    }
                                                });
                                            }
                                        }
                                    });
                                }
                            }
                        }
                    });
                }
            }
        });
        return this;
    }
}

