/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo;

import net.kuujo.vertigo.cluster.ClusterConfig;
import net.kuujo.vertigo.cluster.ClusterManager;
import net.kuujo.vertigo.cluster.ClusterScope;
import net.kuujo.vertigo.cluster.impl.ClusterManagerFactory;
import net.kuujo.vertigo.network.ActiveNetwork;
import net.kuujo.vertigo.network.NetworkConfig;
import net.kuujo.vertigo.network.impl.DefaultNetworkConfig;
import net.kuujo.vertigo.util.Configs;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.impl.DefaultFutureResult;
import org.vertx.java.core.json.JsonObject;
import org.vertx.java.platform.Container;
import org.vertx.java.platform.Verticle;

public final class Vertigo {
    private final ClusterManagerFactory clusterFactory;

    public Vertigo(Verticle verticle) {
        this(verticle.getVertx(), verticle.getContainer());
    }

    public Vertigo(Vertx vertx, Container container) {
        this.clusterFactory = new ClusterManagerFactory(vertx, container);
    }

    public NetworkConfig createNetwork(String name) {
        return new DefaultNetworkConfig(name);
    }

    public NetworkConfig createNetwork(JsonObject json) {
        return Configs.createNetwork(json);
    }

    public Vertigo isDeployed(String name, Handler<AsyncResult<Boolean>> resultHandler) {
        return this.isDeployed(this.createNetwork(name), resultHandler);
    }

    public Vertigo isDeployed(final NetworkConfig network, final Handler<AsyncResult<Boolean>> resultHandler) {
        this.clusterFactory.getCurrentClusterManager(new Handler<AsyncResult<ClusterManager>>(){

            public void handle(AsyncResult<ClusterManager> result) {
                if (result.failed()) {
                    new DefaultFutureResult(result.cause()).setHandler(resultHandler);
                } else {
                    ((ClusterManager)result.result()).isRunning(network.getName(), (Handler<AsyncResult<Boolean>>)resultHandler);
                }
            }
        });
        return this;
    }

    public Vertigo getNetwork(final String name, final Handler<AsyncResult<ActiveNetwork>> resultHandler) {
        this.clusterFactory.getCurrentClusterManager(new Handler<AsyncResult<ClusterManager>>(){

            public void handle(AsyncResult<ClusterManager> result) {
                if (result.failed()) {
                    new DefaultFutureResult(result.cause()).setHandler(resultHandler);
                } else {
                    ((ClusterManager)result.result()).getNetwork(name, (Handler<AsyncResult<ActiveNetwork>>)resultHandler);
                }
            }
        });
        return this;
    }

    public Vertigo deployNetwork(String name) {
        return this.deployNetwork(this.createNetwork(name));
    }

    public Vertigo deployNetwork(String name, Handler<AsyncResult<ActiveNetwork>> doneHandler) {
        return this.deployNetwork(this.createNetwork(name), doneHandler);
    }

    public Vertigo deployNetwork(String name, ClusterScope scope) {
        NetworkConfig network = this.createNetwork(name);
        network.getClusterConfig().setScope(scope);
        return this.deployNetwork(network);
    }

    public Vertigo deployNetwork(String name, ClusterScope scope, Handler<AsyncResult<ActiveNetwork>> doneHandler) {
        NetworkConfig network = this.createNetwork(name);
        network.getClusterConfig().setScope(scope);
        return this.deployNetwork(network, doneHandler);
    }

    public Vertigo deployNetwork(String name, ClusterConfig cluster) {
        return this.deployNetwork(name, cluster, null);
    }

    public Vertigo deployNetwork(String name, ClusterConfig cluster, Handler<AsyncResult<ActiveNetwork>> doneHandler) {
        NetworkConfig network = this.createNetwork(name);
        network.setClusterConfig(cluster);
        return this.deployNetwork(network, doneHandler);
    }

    public Vertigo deployNetwork(JsonObject network) {
        return this.deployNetwork(this.createNetwork(network));
    }

    public Vertigo deployNetwork(JsonObject network, Handler<AsyncResult<ActiveNetwork>> doneHandler) {
        return this.deployNetwork(this.createNetwork(network), doneHandler);
    }

    public Vertigo deployNetwork(NetworkConfig network) {
        return this.deployNetwork(network, null);
    }

    public Vertigo deployNetwork(final NetworkConfig network, final Handler<AsyncResult<ActiveNetwork>> doneHandler) {
        this.clusterFactory.getCurrentClusterManager(new Handler<AsyncResult<ClusterManager>>(){

            public void handle(AsyncResult<ClusterManager> result) {
                if (result.failed()) {
                    new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                } else {
                    ((ClusterManager)result.result()).deployNetwork(network, (Handler<AsyncResult<ActiveNetwork>>)doneHandler);
                }
            }
        });
        return this;
    }

    public Vertigo undeployNetwork(String name) {
        return this.undeployNetwork(this.createNetwork(name));
    }

    public Vertigo undeployNetwork(final String name, final Handler<AsyncResult<Void>> doneHandler) {
        this.clusterFactory.getCurrentClusterManager(new Handler<AsyncResult<ClusterManager>>(){

            public void handle(AsyncResult<ClusterManager> result) {
                if (result.failed()) {
                    new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                } else {
                    ((ClusterManager)result.result()).undeployNetwork(name, (Handler<AsyncResult<Void>>)doneHandler);
                }
            }
        });
        return this;
    }

    public Vertigo undeployNetwork(JsonObject network) {
        return this.undeployNetwork(this.createNetwork(network));
    }

    public Vertigo undeployNetwork(JsonObject network, Handler<AsyncResult<Void>> doneHandler) {
        return this.undeployNetwork(this.createNetwork(network), doneHandler);
    }

    public Vertigo undeployNetwork(NetworkConfig network) {
        return this.undeployNetwork(network, null);
    }

    public Vertigo undeployNetwork(final NetworkConfig network, final Handler<AsyncResult<Void>> doneHandler) {
        this.clusterFactory.getCurrentClusterManager(new Handler<AsyncResult<ClusterManager>>(){

            public void handle(AsyncResult<ClusterManager> result) {
                if (result.failed()) {
                    new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                } else {
                    ((ClusterManager)result.result()).undeployNetwork(network, (Handler<AsyncResult<Void>>)doneHandler);
                }
            }
        });
        return this;
    }
}

