/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.util.serialization.impl;

import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.kuujo.vertigo.util.serialization.JsonSerializable;

public class InclusiveAnnotationIntrospector
extends JacksonAnnotationIntrospector {
    private static final long serialVersionUID = 1L;
    private static final Set<Class<?>> primitiveTypes = new HashSet<Class<?>>(){
        {
            this.add(Class.class);
            this.add(String.class);
            this.add(String[].class);
            this.add(Boolean.class);
            this.add(Boolean[].class);
            this.add(Boolean.TYPE);
            this.add(boolean[].class);
            this.add(Character.class);
            this.add(Character[].class);
            this.add(Character.TYPE);
            this.add(char[].class);
            this.add(Byte.class);
            this.add(Byte[].class);
            this.add(Byte.TYPE);
            this.add(byte[].class);
            this.add(Short.class);
            this.add(Short[].class);
            this.add(Short.TYPE);
            this.add(short[].class);
            this.add(Integer.class);
            this.add(Integer[].class);
            this.add(Integer.TYPE);
            this.add(int[].class);
            this.add(Long.class);
            this.add(Long[].class);
            this.add(Long.TYPE);
            this.add(long[].class);
            this.add(Float.class);
            this.add(Float[].class);
            this.add(Float.TYPE);
            this.add(float[].class);
            this.add(Double.class);
            this.add(Double[].class);
            this.add(Double.TYPE);
            this.add(double[].class);
            this.add(Void.class);
            this.add(Void[].class);
            this.add(Void.TYPE);
        }
    };
    private final Set<Class<?>> serializableTypes = new HashSet<Class<?>>(){
        {
            this.add(Map.class);
            this.add(Map[].class);
            this.add(Collection.class);
            this.add(Collection[].class);
        }
    };
    private final Map<Class<?>, Boolean> cache = new HashMap();

    private boolean isSerializableType(Class<?> type) {
        Boolean serializable = this.cache.get(type);
        if (serializable != null) {
            return serializable;
        }
        if (type == Object.class) {
            return true;
        }
        if (primitiveTypes.contains(type)) {
            this.cache.put(type, true);
            return true;
        }
        if (JsonSerializable.class.isAssignableFrom(type)) {
            this.cache.put(type, true);
            return true;
        }
        for (Class<?> clazz : this.serializableTypes) {
            if (!clazz.isAssignableFrom(type)) continue;
            this.cache.put(type, true);
            return true;
        }
        this.cache.put(type, false);
        return false;
    }

    public Boolean isIgnorableType(AnnotatedClass ac) {
        Boolean ignorable = super.isIgnorableType(ac);
        if (ignorable != null && ignorable.booleanValue()) {
            return true;
        }
        return !this.isSerializableType(ac.getRawType());
    }

    public boolean hasIgnoreMarker(AnnotatedMember member) {
        Boolean ignore = super.hasIgnoreMarker(member);
        if (ignore != null && ignore.booleanValue()) {
            return true;
        }
        return !this.isSerializableType(member.getDeclaringClass());
    }
}

