/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.io;

import java.io.File;
import net.kuujo.vertigo.io.IOException;
import net.kuujo.vertigo.io.Output;
import net.kuujo.vertigo.io.group.OutputGroup;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Handler;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.file.AsyncFile;
import org.vertx.java.core.impl.DefaultFutureResult;

public class FileSender {
    private static final int BUFFER_SIZE = 4096;
    private final Output<?> output;

    public FileSender(Output<?> output) {
        this.output = output;
    }

    public FileSender sendFile(AsyncFile file) {
        return this.sendFile(file, null);
    }

    public FileSender sendFile(final AsyncFile file, final Handler<AsyncResult<Void>> doneHandler) {
        this.output.group("file", (Object)"file", (Handler)new Handler<OutputGroup>(){

            public void handle(OutputGroup group) {
                FileSender.this.doSendFile(file, group, (Handler<AsyncResult<Void>>)doneHandler);
            }
        });
        return this;
    }

    public FileSender sendFile(String filePath) {
        return this.sendFile(filePath, null);
    }

    public FileSender sendFile(String filePath, final Handler<AsyncResult<Void>> doneHandler) {
        final File file = new File(filePath);
        this.output.vertx().fileSystem().exists(file.getAbsolutePath(), (Handler)new Handler<AsyncResult<Boolean>>(){

            public void handle(AsyncResult<Boolean> result) {
                if (result.failed()) {
                    new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                } else if (!((Boolean)result.result()).booleanValue()) {
                    new DefaultFutureResult((Throwable)new IOException("File not found.")).setHandler(doneHandler);
                } else {
                    FileSender.this.output.group("file", (Object)file.getName(), (Handler)new Handler<OutputGroup>(){

                        public void handle(final OutputGroup group) {
                            FileSender.this.output.vertx().fileSystem().open(file.getAbsolutePath(), (Handler)new Handler<AsyncResult<AsyncFile>>(){

                                public void handle(AsyncResult<AsyncFile> result) {
                                    if (result.failed()) {
                                        new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                                    } else {
                                        FileSender.this.doSendFile((AsyncFile)result.result(), group, (Handler<AsyncResult<Void>>)doneHandler);
                                    }
                                }
                            });
                        }
                    });
                }
            }
        });
        return this;
    }

    private void doSendFile(AsyncFile file, OutputGroup group, Handler<AsyncResult<Void>> doneHandler) {
        this.doSendFile(file, group, 0, doneHandler);
    }

    private void doSendFile(final AsyncFile file, final OutputGroup group, final int position, final Handler<AsyncResult<Void>> doneHandler) {
        if (!group.sendQueueFull()) {
            file.read(new Buffer(4096), 0, (long)position, 4096, (Handler)new Handler<AsyncResult<Buffer>>(){

                public void handle(AsyncResult<Buffer> result) {
                    if (result.failed()) {
                        new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                    } else {
                        Buffer buffer = (Buffer)result.result();
                        if (buffer.length() > 0) {
                            group.send(buffer);
                            FileSender.this.doSendFile(file, group, position + buffer.length(), (Handler<AsyncResult<Void>>)doneHandler);
                        } else {
                            group.end();
                            new DefaultFutureResult((Object)null).setHandler(doneHandler);
                        }
                    }
                }
            });
        } else {
            group.drainHandler((Handler)new Handler<Void>(){

                public void handle(Void event) {
                    FileSender.this.doSendFile(file, group, position, (Handler<AsyncResult<Void>>)doneHandler);
                }
            });
        }
    }
}

