/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.util.serialization.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.ObjectMapper;
import net.kuujo.vertigo.util.serialization.DeserializationException;
import net.kuujo.vertigo.util.serialization.SerializationException;
import net.kuujo.vertigo.util.serialization.Serializer;
import net.kuujo.vertigo.util.serialization.impl.InclusiveAnnotationIntrospector;
import org.vertx.java.core.json.JsonArray;
import org.vertx.java.core.json.JsonObject;

public class JacksonSerializer
implements Serializer {
    private final ObjectMapper mapper = new ObjectMapper();

    public JacksonSerializer() {
        this((AnnotationIntrospector)new InclusiveAnnotationIntrospector());
    }

    public JacksonSerializer(AnnotationIntrospector introspector) {
        this.mapper.setAnnotationIntrospector(introspector);
    }

    @Override
    public <T> byte[] serializeToBytes(T object) {
        try {
            return this.mapper.writeValueAsBytes(object);
        }
        catch (Exception e) {
            throw new SerializationException(e.getMessage());
        }
    }

    @Override
    public <T> T deserializeBytes(byte[] json, Class<T> type) {
        try {
            return (T)this.mapper.readValue(json, type);
        }
        catch (Exception e) {
            throw new SerializationException(e.getMessage());
        }
    }

    @Override
    public <T> T deserializeBytes(byte[] json, TypeReference<T> type) {
        try {
            return (T)this.mapper.readValue(json, type);
        }
        catch (Exception e) {
            throw new SerializationException(e.getMessage());
        }
    }

    @Override
    public <T> String serializeToString(T object) {
        try {
            return this.mapper.writeValueAsString(object);
        }
        catch (Exception e) {
            throw new SerializationException(e.getMessage());
        }
    }

    @Override
    public <T> T deserializeString(String json, Class<T> type) {
        try {
            return (T)this.mapper.readValue(json, type);
        }
        catch (Exception e) {
            throw new SerializationException(e.getMessage());
        }
    }

    @Override
    public <T> T deserializeString(String json, TypeReference<T> type) {
        try {
            return (T)this.mapper.readValue(json, type);
        }
        catch (Exception e) {
            throw new SerializationException(e.getMessage());
        }
    }

    @Override
    public <T> JsonObject serializeToObject(T object) {
        try {
            return new JsonObject(this.mapper.writeValueAsString(object));
        }
        catch (Exception e) {
            throw new SerializationException(e.getMessage());
        }
    }

    @Override
    public <T> T deserializeObject(JsonObject json, Class<T> type) {
        try {
            return (T)this.mapper.readValue(json.encode(), type);
        }
        catch (Exception e) {
            throw new DeserializationException(e.getMessage());
        }
    }

    @Override
    public <T> T deserializeObject(JsonObject json, TypeReference<T> type) {
        try {
            return (T)this.mapper.readValue(json.encode(), type);
        }
        catch (Exception e) {
            throw new DeserializationException(e.getMessage());
        }
    }

    @Override
    public <T> T deserializeObject(JsonArray json, Class<T> type) {
        try {
            return (T)this.mapper.readValue(json.encode(), type);
        }
        catch (Exception e) {
            throw new DeserializationException(e.getMessage());
        }
    }

    @Override
    public <T> T deserializeObject(JsonArray json, TypeReference<T> type) {
        try {
            return (T)this.mapper.readValue(json.encode(), type);
        }
        catch (Exception e) {
            throw new DeserializationException(e.getMessage());
        }
    }
}

