/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.util.serialization;

import java.util.HashMap;
import java.util.Map;
import net.kuujo.vertigo.util.serialization.JsonSerializable;
import net.kuujo.vertigo.util.serialization.SerializationException;
import net.kuujo.vertigo.util.serialization.Serializer;
import net.kuujo.vertigo.util.serialization.impl.JacksonSerializerFactory;

public abstract class SerializerFactory {
    private static final String SERIALIZER_FACTORY_CLASS_NAME = "net.kuujo.vertigo.serializer-factory";
    private static SerializerFactory instance;
    private static Map<Class<?>, Class<?>> serializableTypes;
    private static Map<Class<?>, Serializer> serializers;

    private static SerializerFactory getInstance() {
        if (instance == null) {
            String className = JacksonSerializerFactory.class.getName();
            try {
                className = System.getProperty(SERIALIZER_FACTORY_CLASS_NAME);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (className != null) {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                try {
                    Class<?> clazz = loader.loadClass(className);
                    instance = (SerializerFactory)clazz.newInstance();
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Error instantiating serializer factory.");
                }
            } else {
                instance = new JacksonSerializerFactory();
            }
        }
        return instance;
    }

    public static Serializer getSerializer(Class<?> type) {
        Class<?> serializable = SerializerFactory.findSerializableType(type);
        Serializer serializer = serializers.get(serializable);
        if (serializer == null) {
            serializer = SerializerFactory.getInstance().createSerializer(serializable);
            serializers.put(serializable, serializer);
        }
        return serializer;
    }

    private static Class<?> findSerializableType(Class<?> type) {
        if (serializableTypes.containsKey(type)) {
            return serializableTypes.get(type);
        }
        for (Class<?> current = type; current != null && current != Object.class; current = current.getSuperclass()) {
            Class<?> serializable = SerializerFactory.findSerializableInterface(current);
            if (serializable == null) continue;
            serializableTypes.put(type, serializable);
            return serializable;
        }
        throw new SerializationException("Invalid serializable type.");
    }

    private static Class<?> findSerializableInterface(Class<?> type) {
        Class<?>[] interfaces = type.getInterfaces();
        if (interfaces.length > 0) {
            for (Class<?> iface : interfaces) {
                if (iface != JsonSerializable.class) continue;
                return type;
            }
            for (Class<?> iface : interfaces) {
                Class<?> serializable = SerializerFactory.findSerializableType(iface);
                if (serializable == null) continue;
                return serializable;
            }
            return null;
        }
        return null;
    }

    public abstract Serializer createSerializer(Class<?> var1);

    static {
        serializableTypes = new HashMap();
        serializers = new HashMap();
    }
}

