/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.util;

import java.util.concurrent.ExecutorService;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.impl.VertxInternal;
import org.vertx.java.core.spi.Action;

public class ContextManager {
    private final VertxInternal vertx;

    public ContextManager(Vertx vertx) {
        if (!(vertx instanceof VertxInternal)) {
            throw new IllegalArgumentException("ContextManager requires a VertxInternal instance");
        }
        this.vertx = (VertxInternal)vertx;
    }

    public ExecutorService getExecutorService() {
        return this.vertx.getBackgroundPool();
    }

    public ContextManager run(Runnable runnable) {
        this.vertx.startInBackground(runnable, false);
        return this;
    }

    public ContextManager run(Runnable runnable, boolean multiThreaded) {
        this.vertx.startInBackground(runnable, multiThreaded);
        return this;
    }

    public <T> ContextManager execute(Action<T> action, Handler<AsyncResult<T>> resultHandler) {
        this.vertx.executeBlocking(action, resultHandler);
        return this;
    }
}

