/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.io.stream.impl;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.kuujo.vertigo.impl.BaseContext;
import net.kuujo.vertigo.io.connection.OutputConnectionContext;
import net.kuujo.vertigo.io.connection.impl.DefaultOutputConnectionContext;
import net.kuujo.vertigo.io.port.OutputPortContext;
import net.kuujo.vertigo.io.selector.RoundRobinSelector;
import net.kuujo.vertigo.io.selector.Selector;
import net.kuujo.vertigo.io.stream.OutputStreamContext;

public class DefaultOutputStreamContext
extends BaseContext<OutputStreamContext>
implements OutputStreamContext {
    private List<OutputConnectionContext> connections = new ArrayList<OutputConnectionContext>();
    private Selector selector = new RoundRobinSelector();
    @JsonIgnore
    private OutputPortContext port;

    public DefaultOutputStreamContext setPort(OutputPortContext port) {
        this.port = port;
        return this;
    }

    @Override
    public String address() {
        return this.address;
    }

    @Override
    public OutputPortContext port() {
        return this.port;
    }

    @Override
    public Selector selector() {
        return this.selector;
    }

    @Override
    public List<OutputConnectionContext> connections() {
        return this.connections;
    }

    @Override
    public void notify(OutputStreamContext update) {
        if (update == null) {
            for (OutputConnectionContext connection : this.connections) {
                connection.notify(null);
            }
            this.connections.clear();
        } else {
            Iterator<OutputConnectionContext> iter = this.connections.iterator();
            while (iter.hasNext()) {
                OutputConnectionContext connection = iter.next();
                OutputConnectionContext match = null;
                for (OutputConnectionContext c : update.connections()) {
                    if (!connection.equals(c)) continue;
                    match = c;
                    break;
                }
                if (match != null) {
                    connection.notify(match);
                    continue;
                }
                connection.notify(null);
                iter.remove();
            }
            for (OutputConnectionContext connection : update.connections()) {
                if (this.connections.contains(connection)) continue;
                this.connections.add(connection);
            }
        }
        super.notify(this);
    }

    @Override
    public String toString() {
        if (!this.connections.isEmpty()) {
            OutputConnectionContext context = this.connections.get(0);
            return String.format("Stream[%s:%s->%s:%s]", context.source().component(), context.source().port(), context.target().component(), context.target().port());
        }
        return "Stream[?]";
    }

    public static class Builder
    extends BaseContext.Builder<Builder, DefaultOutputStreamContext> {
        private Builder() {
            super(new DefaultOutputStreamContext());
        }

        private Builder(DefaultOutputStreamContext context) {
            super(context);
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static Builder newBuilder(DefaultOutputStreamContext context) {
            return new Builder(context);
        }

        public Builder addConnection(DefaultOutputConnectionContext connection) {
            ((DefaultOutputStreamContext)this.context).connections.add(connection.setStream((OutputStreamContext)((Object)this.context)));
            return this;
        }

        public Builder removeConnection(OutputConnectionContext connection) {
            ((DefaultOutputStreamContext)this.context).connections.remove(connection);
            return this;
        }

        public Builder setSelector(Selector selector) {
            ((DefaultOutputStreamContext)this.context).selector = selector;
            return this;
        }
    }
}

