/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.io.stream.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.kuujo.vertigo.io.batch.OutputBatch;
import net.kuujo.vertigo.io.connection.OutputConnection;
import net.kuujo.vertigo.io.connection.OutputConnectionContext;
import net.kuujo.vertigo.io.connection.impl.ConnectionOutputBatch;
import net.kuujo.vertigo.io.connection.impl.DefaultOutputConnection;
import net.kuujo.vertigo.io.group.OutputGroup;
import net.kuujo.vertigo.io.group.impl.BaseOutputGroup;
import net.kuujo.vertigo.io.selector.Selector;
import net.kuujo.vertigo.io.stream.OutputStream;
import net.kuujo.vertigo.io.stream.OutputStreamContext;
import net.kuujo.vertigo.io.stream.impl.StreamOutputBatch;
import net.kuujo.vertigo.util.CountingCompletionHandler;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.json.JsonArray;
import org.vertx.java.core.json.JsonObject;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;

public class DefaultOutputStream
implements OutputStream {
    private final Logger log;
    private final Vertx vertx;
    private final OutputStreamContext context;
    final List<OutputConnection> connections = new ArrayList<OutputConnection>();
    private int maxQueueSize;
    Selector selector;

    public DefaultOutputStream(Vertx vertx, OutputStreamContext context) {
        this.vertx = vertx;
        this.context = context;
        this.log = LoggerFactory.getLogger((String)String.format("%s-%s", DefaultOutputStream.class.getName(), context.port().toString()));
        for (OutputConnectionContext connection : context.connections()) {
            this.connections.add(new DefaultOutputConnection(vertx, connection));
        }
        this.selector = context.selector();
    }

    @Override
    public Vertx vertx() {
        return this.vertx;
    }

    @Override
    public String address() {
        return this.context.address();
    }

    @Override
    public OutputStream open() {
        return this.open((Handler)null);
    }

    @Override
    public OutputStream open(Handler<AsyncResult<Void>> doneHandler) {
        final CountingCompletionHandler<Void> counter = new CountingCompletionHandler<Void>(this.connections.size()).setHandler(doneHandler);
        for (final OutputConnection connection : this.connections) {
            this.log.debug((Object)String.format("%s - Opening connection to: %s", this, connection.context().target()));
            connection.open(new Handler<AsyncResult<Void>>(){

                public void handle(AsyncResult<Void> result) {
                    if (result.failed()) {
                        DefaultOutputStream.this.log.error((Object)String.format("%s - Failed to open connection to: %s", DefaultOutputStream.this, connection.context().target()));
                        counter.fail(result.cause());
                    } else {
                        DefaultOutputStream.this.log.info((Object)String.format("%s - Opened connection to: %s", DefaultOutputStream.this, connection.context().target()));
                        counter.succeed();
                    }
                }
            });
        }
        return this;
    }

    @Override
    public OutputStream setSendQueueMaxSize(int maxSize) {
        this.maxQueueSize = maxSize;
        for (OutputConnection connection : this.connections) {
            connection.setSendQueueMaxSize(Math.round(this.maxQueueSize / this.connections.size()));
        }
        return this;
    }

    @Override
    public int getSendQueueMaxSize() {
        return this.maxQueueSize;
    }

    @Override
    public int size() {
        int highest = 0;
        for (OutputConnection connection : this.connections) {
            highest = Math.max(highest, connection.size());
        }
        return highest;
    }

    @Override
    public boolean sendQueueFull() {
        for (OutputConnection connection : this.connections) {
            if (!connection.sendQueueFull()) continue;
            return true;
        }
        return false;
    }

    @Override
    public OutputStream drainHandler(Handler<Void> handler) {
        for (OutputConnection connection : this.connections) {
            connection.drainHandler(handler);
        }
        return this;
    }

    @Override
    public OutputStream batch(Handler<OutputBatch> handler) {
        return this.batch(UUID.randomUUID().toString(), (Object)null, (Handler)handler);
    }

    @Override
    public OutputStream batch(Object args, Handler<OutputBatch> handler) {
        return this.batch(UUID.randomUUID().toString(), args, (Handler)handler);
    }

    @Override
    public OutputStream batch(final String id, Object args, final Handler<OutputBatch> handler) {
        final ArrayList<ConnectionOutputBatch> batches = new ArrayList<ConnectionOutputBatch>();
        final int connectionsSize = this.connections.size();
        if (connectionsSize == 0) {
            handler.handle((Object)new StreamOutputBatch(id, this, batches));
        } else {
            for (OutputConnection connection : this.connections) {
                connection.batch(id, args, new Handler<ConnectionOutputBatch>(){

                    public void handle(ConnectionOutputBatch batch) {
                        batches.add(batch);
                        if (batches.size() == connectionsSize) {
                            handler.handle((Object)new StreamOutputBatch(id, DefaultOutputStream.this, batches));
                        }
                    }
                });
            }
        }
        return this;
    }

    @Override
    public OutputStream group(Handler<OutputGroup> handler) {
        return this.group(UUID.randomUUID().toString(), (Object)null, (Handler)handler);
    }

    @Override
    public OutputStream group(String name, Handler<OutputGroup> handler) {
        return this.group(name, (Object)null, (Handler)handler);
    }

    @Override
    public OutputStream group(final String name, Object args, final Handler<OutputGroup> handler) {
        final ArrayList<OutputGroup> groups = new ArrayList<OutputGroup>();
        List<OutputConnection> connections = this.selector.select(name, this.connections);
        final int connectionsSize = connections.size();
        if (connectionsSize == 0) {
            handler.handle((Object)new BaseOutputGroup(name, this.vertx, groups));
        } else {
            for (OutputConnection connection : connections) {
                connection.group(name, args, new Handler<OutputGroup>(){

                    public void handle(OutputGroup group) {
                        groups.add(group);
                        if (groups.size() == connectionsSize) {
                            handler.handle((Object)new BaseOutputGroup(name, DefaultOutputStream.this.vertx, groups));
                        }
                    }
                });
            }
        }
        return this;
    }

    @Override
    public OutputStream send(Object message) {
        for (OutputConnection connection : this.selector.select(message, this.connections)) {
            connection.send(message);
        }
        return this;
    }

    @Override
    public OutputStream send(String message) {
        for (OutputConnection connection : this.selector.select(message, this.connections)) {
            connection.send(message);
        }
        return this;
    }

    @Override
    public OutputStream send(Boolean message) {
        for (OutputConnection connection : this.selector.select(message, this.connections)) {
            connection.send(message);
        }
        return this;
    }

    @Override
    public OutputStream send(Character message) {
        for (OutputConnection connection : this.selector.select(message, this.connections)) {
            connection.send(message);
        }
        return this;
    }

    @Override
    public OutputStream send(Short message) {
        for (OutputConnection connection : this.selector.select(message, this.connections)) {
            connection.send(message);
        }
        return this;
    }

    @Override
    public OutputStream send(Integer message) {
        for (OutputConnection connection : this.selector.select(message, this.connections)) {
            connection.send(message);
        }
        return this;
    }

    @Override
    public OutputStream send(Long message) {
        for (OutputConnection connection : this.selector.select(message, this.connections)) {
            connection.send(message);
        }
        return this;
    }

    @Override
    public OutputStream send(Double message) {
        for (OutputConnection connection : this.selector.select(message, this.connections)) {
            connection.send(message);
        }
        return this;
    }

    @Override
    public OutputStream send(Float message) {
        for (OutputConnection connection : this.selector.select(message, this.connections)) {
            connection.send(message);
        }
        return this;
    }

    @Override
    public OutputStream send(JsonObject message) {
        for (OutputConnection connection : this.selector.select(message, this.connections)) {
            connection.send(message);
        }
        return this;
    }

    @Override
    public OutputStream send(JsonArray message) {
        for (OutputConnection connection : this.selector.select(message, this.connections)) {
            connection.send(message);
        }
        return this;
    }

    @Override
    public OutputStream send(Byte message) {
        for (OutputConnection connection : this.selector.select(message, this.connections)) {
            connection.send(message);
        }
        return this;
    }

    @Override
    public OutputStream send(byte[] message) {
        for (OutputConnection connection : this.selector.select(message, this.connections)) {
            connection.send(message);
        }
        return this;
    }

    @Override
    public OutputStream send(Buffer message) {
        for (OutputConnection connection : this.selector.select(message, this.connections)) {
            connection.send(message);
        }
        return this;
    }

    @Override
    public void close() {
        this.close(null);
    }

    @Override
    public void close(Handler<AsyncResult<Void>> doneHandler) {
        final CountingCompletionHandler<Void> counter = new CountingCompletionHandler<Void>(this.connections.size()).setHandler(doneHandler);
        for (final OutputConnection connection : this.connections) {
            this.log.debug((Object)String.format("%s - Closing connection to: %s", this, connection.context().target()));
            connection.close(new Handler<AsyncResult<Void>>(){

                public void handle(AsyncResult<Void> result) {
                    if (result.failed()) {
                        DefaultOutputStream.this.log.warn((Object)String.format("%s - Failed to close connection to: %s", DefaultOutputStream.this, connection.context().target()));
                        counter.fail(result.cause());
                    } else {
                        DefaultOutputStream.this.log.info((Object)String.format("%s - Closed connection to: %s", DefaultOutputStream.this, connection.context().target()));
                        counter.succeed();
                    }
                }
            });
        }
    }

    public String toString() {
        return this.context.toString();
    }
}

