/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.io.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.kuujo.vertigo.io.OutputCollector;
import net.kuujo.vertigo.io.OutputContext;
import net.kuujo.vertigo.io.impl.DefaultOutputContext;
import net.kuujo.vertigo.io.port.OutputPort;
import net.kuujo.vertigo.io.port.OutputPortContext;
import net.kuujo.vertigo.io.port.impl.DefaultOutputPort;
import net.kuujo.vertigo.io.port.impl.DefaultOutputPortContext;
import net.kuujo.vertigo.util.CountingCompletionHandler;
import net.kuujo.vertigo.util.Observer;
import net.kuujo.vertigo.util.Task;
import net.kuujo.vertigo.util.TaskRunner;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.impl.DefaultFutureResult;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;

public class DefaultOutputCollector
implements OutputCollector,
Observer<OutputContext> {
    private final Logger log;
    private final Vertx vertx;
    private OutputContext context;
    private final Map<String, OutputPort> ports = new HashMap<String, OutputPort>();
    private final TaskRunner tasks = new TaskRunner();
    private boolean started;

    public DefaultOutputCollector(Vertx vertx) {
        this.vertx = vertx;
        this.log = LoggerFactory.getLogger(DefaultOutputCollector.class);
    }

    public DefaultOutputCollector(Vertx vertx, OutputContext context) {
        this.vertx = vertx;
        this.context = context;
        this.log = LoggerFactory.getLogger((String)String.format("%s-%s-%d", DefaultOutputCollector.class.getName(), context.instance().component().name(), context.instance().number()));
        context.registerObserver(this);
    }

    @Override
    public Collection<OutputPort> ports() {
        return this.ports.values();
    }

    @Override
    public OutputPort port(String name) {
        OutputPort port = this.ports.get(name);
        if (port == null) {
            this.log.debug((Object)String.format("%s - Lazily creating out port: %s", this, name));
            OutputPortContext portContext = null;
            for (OutputPortContext output : this.context.ports()) {
                if (!output.name().equals(name)) continue;
                portContext = output;
                break;
            }
            if (portContext == null) {
                portContext = (OutputPortContext)((DefaultOutputPortContext.Builder)DefaultOutputPortContext.Builder.newBuilder().setAddress(UUID.randomUUID().toString())).setName(name).build();
                DefaultOutputContext.Builder.newBuilder((DefaultOutputContext)this.context).addPort((DefaultOutputPortContext)portContext);
            }
            port = new DefaultOutputPort(this.vertx, portContext);
            this.ports.put(name, (OutputPort)port.open());
        }
        return port;
    }

    @Override
    public void update(final OutputContext update) {
        this.log.debug((Object)String.format("%s - Output context changed, updating ports", this));
        this.tasks.runTask(new Handler<Task>(){

            public void handle(final Task task) {
                ArrayList<DefaultOutputPort> newPorts = new ArrayList<DefaultOutputPort>();
                for (OutputPortContext outputPortContext : update.ports()) {
                    boolean bl = false;
                    for (OutputPort port : DefaultOutputCollector.this.ports.values()) {
                        if (!port.name().equals(outputPortContext.name())) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    DefaultOutputCollector.this.log.debug((Object)String.format("%s - Adding out port: %s", DefaultOutputCollector.this, outputPortContext));
                    newPorts.add(new DefaultOutputPort(DefaultOutputCollector.this.vertx, outputPortContext));
                }
                if (DefaultOutputCollector.this.started) {
                    final CountingCompletionHandler<Void> counter = new CountingCompletionHandler<Void>(newPorts.size());
                    counter.setHandler(new Handler<AsyncResult<Void>>(){

                        public void handle(AsyncResult<Void> result) {
                            task.complete();
                        }
                    });
                    for (final OutputPort outputPort : newPorts) {
                        DefaultOutputCollector.this.log.debug((Object)String.format("%s - Opening out port: %s", DefaultOutputCollector.this, outputPort));
                        outputPort.open(new Handler<AsyncResult<Void>>(){

                            public void handle(AsyncResult<Void> result) {
                                if (result.failed()) {
                                    DefaultOutputCollector.this.log.error((Object)String.format("%s - Failed to open out port: %s", DefaultOutputCollector.this, outputPort));
                                } else {
                                    DefaultOutputCollector.this.log.info((Object)String.format("%s - Opened out port: %s", DefaultOutputCollector.this, outputPort));
                                    DefaultOutputCollector.this.ports.put(outputPort.name(), outputPort);
                                }
                                counter.succeed();
                            }
                        });
                    }
                } else {
                    for (OutputPort outputPort : newPorts) {
                        DefaultOutputCollector.this.ports.put(outputPort.name(), outputPort);
                    }
                    task.complete();
                }
            }
        });
    }

    @Override
    public OutputCollector open() {
        return this.open((Handler)null);
    }

    @Override
    public OutputCollector open(final Handler<AsyncResult<Void>> doneHandler) {
        this.tasks.runTask(new Handler<Task>(){

            public void handle(final Task task) {
                if (!DefaultOutputCollector.this.started) {
                    final CountingCompletionHandler<Void> startCounter = new CountingCompletionHandler<Void>(DefaultOutputCollector.this.context.ports().size());
                    startCounter.setHandler(new Handler<AsyncResult<Void>>(){

                        public void handle(AsyncResult<Void> result) {
                            if (result.failed()) {
                                new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                            } else {
                                new DefaultFutureResult((Object)null).setHandler(doneHandler);
                            }
                            task.complete();
                        }
                    });
                    for (OutputPortContext output : DefaultOutputCollector.this.context.ports()) {
                        if (DefaultOutputCollector.this.ports.containsKey(output.name())) {
                            ((DefaultOutputPort)DefaultOutputCollector.this.ports.get(output.name())).open(startCounter);
                            continue;
                        }
                        final DefaultOutputPort port = new DefaultOutputPort(DefaultOutputCollector.this.vertx, output);
                        DefaultOutputCollector.this.log.debug((Object)String.format("%s - Opening out port: %s", DefaultOutputCollector.this, output));
                        port.open(new Handler<AsyncResult<Void>>(){

                            public void handle(AsyncResult<Void> result) {
                                if (result.failed()) {
                                    DefaultOutputCollector.this.log.error((Object)String.format("%s - Failed to open out port: %s", DefaultOutputCollector.this, port));
                                    startCounter.fail(result.cause());
                                } else {
                                    DefaultOutputCollector.this.log.info((Object)String.format("%s - Opened out port: %s", DefaultOutputCollector.this, port));
                                    DefaultOutputCollector.this.ports.put(port.name(), port);
                                    startCounter.succeed();
                                }
                            }
                        });
                    }
                    DefaultOutputCollector.this.started = true;
                } else {
                    new DefaultFutureResult((Object)null).setHandler(doneHandler);
                    task.complete();
                }
            }
        });
        return this;
    }

    @Override
    public void close() {
        this.close(null);
    }

    @Override
    public void close(final Handler<AsyncResult<Void>> doneHandler) {
        this.tasks.runTask(new Handler<Task>(){

            public void handle(final Task task) {
                if (DefaultOutputCollector.this.started) {
                    final CountingCompletionHandler<Void> stopCounter = new CountingCompletionHandler<Void>(DefaultOutputCollector.this.ports.size());
                    stopCounter.setHandler(new Handler<AsyncResult<Void>>(){

                        public void handle(AsyncResult<Void> result) {
                            if (result.failed()) {
                                new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                            } else {
                                DefaultOutputCollector.this.ports.clear();
                                DefaultOutputCollector.this.started = false;
                                new DefaultFutureResult((Object)null).setHandler(doneHandler);
                            }
                            task.complete();
                        }
                    });
                    for (final OutputPort output : DefaultOutputCollector.this.ports.values()) {
                        DefaultOutputCollector.this.log.debug((Object)String.format("%s - Closing out port: %s", DefaultOutputCollector.this, output));
                        output.close(new Handler<AsyncResult<Void>>(){

                            public void handle(AsyncResult<Void> result) {
                                if (result.failed()) {
                                    DefaultOutputCollector.this.log.warn((Object)String.format("%s - Failed to close out port: %s", DefaultOutputCollector.this, output));
                                    stopCounter.fail(result.cause());
                                } else {
                                    DefaultOutputCollector.this.log.info((Object)String.format("%s - Closed out port: %s", DefaultOutputCollector.this, output));
                                    stopCounter.succeed();
                                }
                            }
                        });
                    }
                } else {
                    new DefaultFutureResult((Object)null).setHandler(doneHandler);
                    task.complete();
                }
            }
        });
    }

    public String toString() {
        return this.context.toString();
    }
}

