/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.io.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.kuujo.vertigo.io.InputCollector;
import net.kuujo.vertigo.io.InputContext;
import net.kuujo.vertigo.io.impl.DefaultInputContext;
import net.kuujo.vertigo.io.port.InputPort;
import net.kuujo.vertigo.io.port.InputPortContext;
import net.kuujo.vertigo.io.port.impl.DefaultInputPort;
import net.kuujo.vertigo.io.port.impl.DefaultInputPortContext;
import net.kuujo.vertigo.util.CountingCompletionHandler;
import net.kuujo.vertigo.util.Observer;
import net.kuujo.vertigo.util.Task;
import net.kuujo.vertigo.util.TaskRunner;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.impl.DefaultFutureResult;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;

public class DefaultInputCollector
implements InputCollector,
Observer<InputContext> {
    private final Logger log;
    private final Vertx vertx;
    private InputContext context;
    private final Map<String, InputPort> ports = new HashMap<String, InputPort>();
    private final TaskRunner tasks = new TaskRunner();
    private boolean started;

    public DefaultInputCollector(Vertx vertx) {
        this.vertx = vertx;
        this.log = LoggerFactory.getLogger(DefaultInputCollector.class);
    }

    public DefaultInputCollector(Vertx vertx, InputContext context) {
        this.vertx = vertx;
        this.context = context;
        this.log = LoggerFactory.getLogger((String)String.format("%s-%s-%d", DefaultInputCollector.class.getName(), context.instance().component().name(), context.instance().number()));
        context.registerObserver(this);
    }

    @Override
    public Collection<InputPort> ports() {
        return this.ports.values();
    }

    @Override
    public InputPort port(String name) {
        InputPort port = this.ports.get(name);
        if (port == null) {
            this.log.debug((Object)String.format("%s - Lazily creating in port: %s", this, name));
            InputPortContext portContext = null;
            for (InputPortContext input : this.context.ports()) {
                if (!input.name().equals(name)) continue;
                portContext = input;
                break;
            }
            if (portContext == null) {
                portContext = (InputPortContext)((DefaultInputPortContext.Builder)DefaultInputPortContext.Builder.newBuilder().setAddress(UUID.randomUUID().toString())).setName(name).build();
                DefaultInputContext.Builder.newBuilder((DefaultInputContext)this.context).addPort((DefaultInputPortContext)portContext);
            }
            port = new DefaultInputPort(this.vertx, portContext);
            this.ports.put(name, (InputPort)port.open());
        }
        return port;
    }

    @Override
    public void update(final InputContext update) {
        this.log.info((Object)String.format("%s - Input configuration has changed, updating ports", this));
        this.tasks.runTask(new Handler<Task>(){

            public void handle(final Task task) {
                ArrayList<DefaultInputPort> newPorts = new ArrayList<DefaultInputPort>();
                for (InputPortContext inputPortContext : update.ports()) {
                    boolean bl = false;
                    for (InputPort port : DefaultInputCollector.this.ports.values()) {
                        if (!port.name().equals(inputPortContext.name())) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    DefaultInputCollector.this.log.debug((Object)String.format("%s - Adding in port: %s", DefaultInputCollector.this, inputPortContext));
                    newPorts.add(new DefaultInputPort(DefaultInputCollector.this.vertx, inputPortContext));
                }
                if (DefaultInputCollector.this.started) {
                    final CountingCompletionHandler<Void> counter = new CountingCompletionHandler<Void>(newPorts.size());
                    counter.setHandler(new Handler<AsyncResult<Void>>(){

                        public void handle(AsyncResult<Void> result) {
                            task.complete();
                        }
                    });
                    for (final InputPort inputPort : newPorts) {
                        DefaultInputCollector.this.log.debug((Object)String.format("%s - Opening in port: %s", DefaultInputCollector.this, inputPort));
                        inputPort.open(new Handler<AsyncResult<Void>>(){

                            public void handle(AsyncResult<Void> result) {
                                if (result.failed()) {
                                    DefaultInputCollector.this.log.error((Object)String.format("%s - Failed to open in port: %s", DefaultInputCollector.this, inputPort));
                                } else {
                                    DefaultInputCollector.this.log.info((Object)String.format("%s - Opened in port: %s", DefaultInputCollector.this, inputPort));
                                    DefaultInputCollector.this.ports.put(inputPort.name(), inputPort);
                                }
                                counter.succeed();
                            }
                        });
                    }
                } else {
                    for (InputPort inputPort : newPorts) {
                        DefaultInputCollector.this.ports.put(inputPort.name(), inputPort);
                    }
                    task.complete();
                }
            }
        });
    }

    @Override
    public InputCollector open() {
        return this.open((Handler)null);
    }

    @Override
    public InputCollector open(final Handler<AsyncResult<Void>> doneHandler) {
        this.tasks.runTask(new Handler<Task>(){

            public void handle(final Task task) {
                if (!DefaultInputCollector.this.started) {
                    final CountingCompletionHandler<Void> startCounter = new CountingCompletionHandler<Void>(DefaultInputCollector.this.context.ports().size());
                    startCounter.setHandler(new Handler<AsyncResult<Void>>(){

                        public void handle(AsyncResult<Void> result) {
                            if (result.failed()) {
                                new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                            } else {
                                new DefaultFutureResult((Object)null).setHandler(doneHandler);
                            }
                            task.complete();
                        }
                    });
                    for (final InputPortContext port : DefaultInputCollector.this.context.ports()) {
                        DefaultInputCollector.this.log.debug((Object)String.format("%s - Opening in port: %s", DefaultInputCollector.this, port));
                        if (DefaultInputCollector.this.ports.containsKey(port.name())) {
                            ((DefaultInputPort)DefaultInputCollector.this.ports.get(port.name())).open((Handler)new Handler<AsyncResult<Void>>(){

                                public void handle(AsyncResult<Void> result) {
                                    if (result.failed()) {
                                        DefaultInputCollector.this.log.error((Object)String.format("%s - Failed to open in port: %s", DefaultInputCollector.this, port));
                                        startCounter.fail(result.cause());
                                    } else {
                                        DefaultInputCollector.this.log.info((Object)String.format("%s - Opened in port: %s", DefaultInputCollector.this, port));
                                        startCounter.succeed();
                                    }
                                }
                            });
                            continue;
                        }
                        DefaultInputCollector.this.ports.put(port.name(), new DefaultInputPort(DefaultInputCollector.this.vertx, port).open((Handler)new Handler<AsyncResult<Void>>(){

                            public void handle(AsyncResult<Void> result) {
                                if (result.failed()) {
                                    DefaultInputCollector.this.log.error((Object)String.format("%s - Failed to open in port: %s", DefaultInputCollector.this, port));
                                    startCounter.fail(result.cause());
                                } else {
                                    DefaultInputCollector.this.log.info((Object)String.format("%s - Opened in port: %s", DefaultInputCollector.this, port));
                                    startCounter.succeed();
                                }
                            }
                        }));
                    }
                    DefaultInputCollector.this.started = true;
                } else {
                    new DefaultFutureResult((Object)null).setHandler(doneHandler);
                    task.complete();
                }
            }
        });
        return this;
    }

    @Override
    public void close() {
        this.close(null);
    }

    @Override
    public void close(final Handler<AsyncResult<Void>> doneHandler) {
        this.tasks.runTask(new Handler<Task>(){

            public void handle(final Task task) {
                if (DefaultInputCollector.this.started) {
                    final CountingCompletionHandler<Void> stopCounter = new CountingCompletionHandler<Void>(DefaultInputCollector.this.ports.size());
                    stopCounter.setHandler(new Handler<AsyncResult<Void>>(){

                        public void handle(AsyncResult<Void> result) {
                            if (result.failed()) {
                                new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                            } else {
                                DefaultInputCollector.this.ports.clear();
                                DefaultInputCollector.this.started = false;
                                new DefaultFutureResult((Object)null).setHandler(doneHandler);
                            }
                            task.complete();
                        }
                    });
                    for (final InputPort port : DefaultInputCollector.this.ports.values()) {
                        DefaultInputCollector.this.log.debug((Object)String.format("%s - Closing in port: %s", DefaultInputCollector.this, port));
                        port.close(new Handler<AsyncResult<Void>>(){

                            public void handle(AsyncResult<Void> result) {
                                if (result.failed()) {
                                    DefaultInputCollector.this.log.warn((Object)String.format("%s - Failed to close in port: %s", DefaultInputCollector.this, port));
                                    stopCounter.fail(result.cause());
                                } else {
                                    DefaultInputCollector.this.log.info((Object)String.format("%s - Closed in port: %s", DefaultInputCollector.this, port));
                                    stopCounter.succeed();
                                }
                            }
                        });
                    }
                } else {
                    new DefaultFutureResult((Object)null).setHandler(doneHandler);
                    task.complete();
                }
            }
        });
    }

    public String toString() {
        return this.context.toString();
    }
}

