/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.io.connection.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import net.kuujo.vertigo.hook.OutputHook;
import net.kuujo.vertigo.io.connection.OutputConnection;
import net.kuujo.vertigo.io.connection.OutputConnectionContext;
import net.kuujo.vertigo.io.connection.impl.ConnectionOutputBatch;
import net.kuujo.vertigo.io.connection.impl.DefaultConnectionOutputBatch;
import net.kuujo.vertigo.io.connection.impl.DefaultConnectionOutputGroup;
import net.kuujo.vertigo.io.connection.impl.DefaultOutputConnectionContext;
import net.kuujo.vertigo.io.group.OutputGroup;
import net.kuujo.vertigo.io.impl.OutputSerializer;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.eventbus.EventBus;
import org.vertx.java.core.eventbus.Message;
import org.vertx.java.core.eventbus.ReplyException;
import org.vertx.java.core.eventbus.ReplyFailure;
import org.vertx.java.core.impl.DefaultFutureResult;
import org.vertx.java.core.json.JsonArray;
import org.vertx.java.core.json.JsonObject;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;

public class DefaultOutputConnection
implements OutputConnection {
    private static final int DEFAULT_MAX_QUEUE_SIZE = 1000;
    private final Logger log;
    private final Vertx vertx;
    private final EventBus eventBus;
    private final OutputConnectionContext context;
    private final String outAddress;
    private final String inAddress;
    private final OutputSerializer serializer = new OutputSerializer();
    private List<OutputHook> hooks = new ArrayList<OutputHook>();
    private int maxQueueSize = 1000;
    private Handler<Void> drainHandler;
    private long currentMessage = 1L;
    private final TreeMap<Long, JsonObject> messages = new TreeMap();
    private final Map<String, DefaultConnectionOutputGroup> groups = new HashMap<String, DefaultConnectionOutputGroup>();
    private DefaultConnectionOutputBatch currentBatch;
    private boolean open;
    private boolean full;
    private boolean paused;
    private final Handler<Message<JsonObject>> internalMessageHandler = new Handler<Message<JsonObject>>(){

        public void handle(Message<JsonObject> message) {
            String action = ((JsonObject)message.body()).getString("action");
            if (action != null) {
                switch (action) {
                    case "group": {
                        DefaultOutputConnection.this.doStartGroup(((JsonObject)message.body()).getString("group"));
                        break;
                    }
                    case "batch": {
                        DefaultOutputConnection.this.doStartBatch(((JsonObject)message.body()).getString("batch"));
                        break;
                    }
                    case "ack": {
                        DefaultOutputConnection.this.doAck(((JsonObject)message.body()).getLong("id"));
                        break;
                    }
                    case "fail": {
                        DefaultOutputConnection.this.doFail(((JsonObject)message.body()).getLong("id"));
                        break;
                    }
                    case "pause": {
                        DefaultOutputConnection.this.doPause(((JsonObject)message.body()).getLong("id"));
                        break;
                    }
                    case "resume": {
                        DefaultOutputConnection.this.doResume(((JsonObject)message.body()).getLong("id"));
                    }
                }
            }
        }
    };

    public DefaultOutputConnection(Vertx vertx, String address) {
        this(vertx, (OutputConnectionContext)((DefaultOutputConnectionContext.Builder)DefaultOutputConnectionContext.Builder.newBuilder().setAddress(address)).build());
    }

    public DefaultOutputConnection(Vertx vertx, OutputConnectionContext context) {
        this.vertx = vertx;
        this.eventBus = vertx.eventBus();
        this.context = context;
        this.hooks = context.hooks();
        this.outAddress = String.format("%s.out", context.address());
        this.inAddress = String.format("%s.in", context.address());
        this.log = LoggerFactory.getLogger((String)String.format("%s-%s", DefaultOutputConnection.class.getName(), context.target()));
    }

    @Override
    public String address() {
        return this.context.address();
    }

    @Override
    public OutputConnectionContext context() {
        return this.context;
    }

    @Override
    public Vertx vertx() {
        return this.vertx;
    }

    @Override
    public OutputConnection open() {
        return this.open((Handler)null);
    }

    @Override
    public OutputConnection open(final Handler<AsyncResult<Void>> doneHandler) {
        this.eventBus.registerHandler(this.outAddress, this.internalMessageHandler, (Handler)new Handler<AsyncResult<Void>>(){

            public void handle(AsyncResult<Void> result) {
                if (result.failed()) {
                    new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                } else {
                    DefaultOutputConnection.this.connect((Handler<AsyncResult<Void>>)doneHandler);
                }
            }
        });
        return this;
    }

    private void connect(final Handler<AsyncResult<Void>> doneHandler) {
        this.eventBus.sendWithTimeout(this.inAddress, new JsonObject().putString("action", "connect"), 1000L, (Handler)new Handler<AsyncResult<Message<Boolean>>>(){

            public void handle(AsyncResult<Message<Boolean>> result) {
                if (result.failed()) {
                    ReplyException failure = (ReplyException)result.cause();
                    if (failure.failureType().equals((Object)ReplyFailure.RECIPIENT_FAILURE)) {
                        DefaultOutputConnection.this.log.warn((Object)String.format("%s - Failed to connect to %s", DefaultOutputConnection.this, DefaultOutputConnection.this.context.target()), result.cause());
                        new DefaultFutureResult((Throwable)failure).setHandler(doneHandler);
                    } else if (failure.failureType().equals((Object)ReplyFailure.TIMEOUT)) {
                        DefaultOutputConnection.this.log.warn((Object)String.format("%s - Connection to %s failed, retrying", DefaultOutputConnection.this, DefaultOutputConnection.this.context.target()));
                        DefaultOutputConnection.this.connect((Handler<AsyncResult<Void>>)doneHandler);
                    } else {
                        DefaultOutputConnection.this.log.debug((Object)String.format("%s - Connection to %s failed, retrying", DefaultOutputConnection.this, DefaultOutputConnection.this.context.target()));
                        DefaultOutputConnection.this.vertx.setTimer(500L, (Handler)new Handler<Long>(){

                            public void handle(Long timerID) {
                                DefaultOutputConnection.this.connect((Handler<AsyncResult<Void>>)doneHandler);
                            }
                        });
                    }
                } else if (((Boolean)((Message)result.result()).body()).booleanValue()) {
                    DefaultOutputConnection.this.log.info((Object)String.format("%s - Connected to %s", DefaultOutputConnection.this, DefaultOutputConnection.this.context.target()));
                    DefaultOutputConnection.this.open = true;
                    new DefaultFutureResult((Object)null).setHandler(doneHandler);
                } else {
                    DefaultOutputConnection.this.log.debug((Object)String.format("%s - Connection to %s failed, retrying", DefaultOutputConnection.this, DefaultOutputConnection.this.context.target()));
                    DefaultOutputConnection.this.vertx.setTimer(500L, (Handler)new Handler<Long>(){

                        public void handle(Long timerID) {
                            DefaultOutputConnection.this.connect((Handler<AsyncResult<Void>>)doneHandler);
                        }
                    });
                }
            }
        });
    }

    @Override
    public OutputConnection setSendQueueMaxSize(int maxSize) {
        this.maxQueueSize = maxSize;
        return this;
    }

    @Override
    public int getSendQueueMaxSize() {
        return this.maxQueueSize;
    }

    @Override
    public int size() {
        return this.messages.size();
    }

    @Override
    public boolean sendQueueFull() {
        return this.paused || this.messages.size() >= this.maxQueueSize;
    }

    @Override
    public OutputConnection drainHandler(Handler<Void> handler) {
        this.drainHandler = handler;
        return this;
    }

    @Override
    public OutputConnection batch(final String id, final Object args, final Handler<ConnectionOutputBatch> handler) {
        if (this.currentBatch != null) {
            this.currentBatch.endHandler(new Handler<Void>(){

                public void handle(Void _) {
                    DefaultOutputConnection.this.currentBatch = new DefaultConnectionOutputBatch(id, args, DefaultOutputConnection.this);
                    DefaultOutputConnection.this.currentBatch.start((Handler<ConnectionOutputBatch>)handler);
                }
            });
        } else {
            this.currentBatch = new DefaultConnectionOutputBatch(id, args, this);
            this.currentBatch.start(handler);
        }
        return this;
    }

    @Override
    public OutputConnection group(Handler<OutputGroup> handler) {
        return this.group(UUID.randomUUID().toString(), (Object)null, (Handler)handler);
    }

    @Override
    public OutputConnection group(String name, Handler<OutputGroup> handler) {
        return this.group(name, (Object)null, (Handler)handler);
    }

    @Override
    public OutputConnection group(String name, Object args, Handler<OutputGroup> handler) {
        DefaultConnectionOutputGroup group = new DefaultConnectionOutputGroup(UUID.randomUUID().toString(), name, args, this);
        this.groups.put(group.id(), group);
        group.start(handler);
        return this;
    }

    DefaultConnectionOutputGroup group(String name, Object args, String parent, Handler<OutputGroup> handler) {
        DefaultConnectionOutputGroup group = new DefaultConnectionOutputGroup(UUID.randomUUID().toString(), name, args, parent, this);
        this.groups.put(group.id(), group);
        group.start(handler);
        return group;
    }

    @Override
    public void close() {
        this.close(null);
    }

    @Override
    public void close(final Handler<AsyncResult<Void>> doneHandler) {
        this.eventBus.unregisterHandler(this.outAddress, this.internalMessageHandler, (Handler)new Handler<AsyncResult<Void>>(){

            public void handle(AsyncResult<Void> result) {
                if (result.failed()) {
                    new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                } else {
                    DefaultOutputConnection.this.disconnect((Handler<AsyncResult<Void>>)doneHandler);
                }
            }
        });
    }

    private void disconnect(final Handler<AsyncResult<Void>> doneHandler) {
        this.eventBus.sendWithTimeout(this.inAddress, new JsonObject().putString("action", "disconnect"), 5000L, (Handler)new Handler<AsyncResult<Message<Boolean>>>(){

            public void handle(AsyncResult<Message<Boolean>> result) {
                if (result.failed()) {
                    ReplyException failure = (ReplyException)result.cause();
                    if (failure.failureType().equals((Object)ReplyFailure.RECIPIENT_FAILURE)) {
                        DefaultOutputConnection.this.log.warn((Object)String.format("%s - Failed to disconnect from %s", DefaultOutputConnection.this, DefaultOutputConnection.this.context.target()), result.cause());
                        new DefaultFutureResult((Throwable)failure).setHandler(doneHandler);
                    } else if (failure.failureType().equals((Object)ReplyFailure.NO_HANDLERS)) {
                        DefaultOutputConnection.this.log.info((Object)String.format("%s - Disconnected from %s", DefaultOutputConnection.this, DefaultOutputConnection.this.context.target()));
                        new DefaultFutureResult((Object)null).setHandler(doneHandler);
                    } else {
                        DefaultOutputConnection.this.log.debug((Object)String.format("%s - Disconnection from %s failed, retrying", DefaultOutputConnection.this, DefaultOutputConnection.this.context.target()));
                        DefaultOutputConnection.this.disconnect((Handler<AsyncResult<Void>>)doneHandler);
                    }
                } else if (((Boolean)((Message)result.result()).body()).booleanValue()) {
                    DefaultOutputConnection.this.log.info((Object)String.format("%s - Disconnected from %s", DefaultOutputConnection.this, DefaultOutputConnection.this.context.target()));
                    DefaultOutputConnection.this.open = false;
                    new DefaultFutureResult((Object)null).setHandler(doneHandler);
                } else {
                    DefaultOutputConnection.this.log.debug((Object)String.format("%s - Disconnection from %s failed, retrying", DefaultOutputConnection.this, DefaultOutputConnection.this.context.target()));
                    DefaultOutputConnection.this.vertx.setTimer(500L, (Handler)new Handler<Long>(){

                        public void handle(Long timerID) {
                            DefaultOutputConnection.this.disconnect((Handler<AsyncResult<Void>>)doneHandler);
                        }
                    });
                }
            }
        });
    }

    private void checkOpen() {
        if (!this.open) {
            throw new IllegalStateException(String.format("%s - Connection to %s not open.", this, this.context.target()));
        }
    }

    private void checkFull() {
        if (!this.full && this.messages.size() >= this.maxQueueSize) {
            this.full = true;
            this.log.debug((Object)String.format("%s - Connection to %s is full", this, this.context.target()));
        }
    }

    private void checkDrain() {
        if (this.full && !this.paused && this.messages.size() < this.maxQueueSize / 2) {
            this.full = false;
            this.log.debug((Object)String.format("%s - Connection to %s is drained", this, this.context.target()));
            if (this.drainHandler != null) {
                this.drainHandler.handle((Object)null);
            }
        }
    }

    private void doStartGroup(String groupID) {
        DefaultConnectionOutputGroup group = this.groups.get(groupID);
        if (group != null) {
            group.handleStart();
        }
    }

    private void doStartBatch(String batchID) {
        if (this.currentBatch != null && this.currentBatch.id().equals(batchID)) {
            this.currentBatch.handleStart();
        }
    }

    private void doAck(long id) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("%s - Received ack for messages up to %d, removing all previous messages from memory", this, id));
        }
        if (this.messages.containsKey(id + 1L)) {
            this.messages.tailMap(id + 1L);
        } else {
            this.messages.clear();
        }
        this.checkDrain();
    }

    private void doFail(long id) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("%s - Received resend request for messages starting at %d", this, id));
        }
        this.doAck(id);
        Iterator<Map.Entry<Long, JsonObject>> iter = this.messages.entrySet().iterator();
        while (iter.hasNext()) {
            this.eventBus.send(this.inAddress, iter.next().getValue());
        }
    }

    private void doPause(long id) {
        this.log.debug((Object)String.format("%s - Paused connection to %s", this, this.context.target()));
        this.paused = true;
    }

    private void doResume(long id) {
        if (this.paused) {
            this.log.debug((Object)String.format("%s - Resumed connection to %s", this, this.context.target()));
            this.paused = false;
            this.checkDrain();
        }
    }

    private OutputConnection doSend(Object value) {
        this.checkOpen();
        JsonObject message = this.createMessage(value).putString("action", "message");
        if (this.open && !this.paused) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("%s - Send: Message[id=%d, message=%s]", this, message.getLong("id"), value));
            }
            this.eventBus.send(this.inAddress, message);
        }
        for (OutputHook hook : this.hooks) {
            hook.handleSend(value);
        }
        this.checkFull();
        return this;
    }

    void doGroupStart(String group, String name, Object args, String parent) {
        this.checkOpen();
        JsonObject message = this.createMessage(args).putString("group", group).putString("name", name).putString("parent", parent).putString("action", "startGroup");
        if (this.open && !this.paused) {
            if (this.log.isDebugEnabled()) {
                if (parent != null) {
                    this.log.debug((Object)String.format("%s - Group start: Group[name=%s, group=%s, parent=%s, args=%s]", this, name, group, parent, args));
                } else {
                    this.log.debug((Object)String.format("%s - Group start: Group[name=%s, group=%s, args=%s]", this, name, group, args));
                }
            }
            this.eventBus.send(this.inAddress, message);
        }
        this.checkFull();
    }

    void doGroupSend(String group, Object value) {
        this.checkOpen();
        JsonObject message = this.createMessage(value).putString("action", "group").putString("group", group);
        if (this.open && !this.paused) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("%s - Group send: Group[group=%s, id=%d, message=%s", this, group, message.getLong("id"), value));
            }
            this.eventBus.send(this.inAddress, message);
        }
        for (OutputHook hook : this.hooks) {
            hook.handleSend(value);
        }
        this.checkFull();
    }

    void doGroupEnd(String group, Object args) {
        this.checkOpen();
        JsonObject message = this.createMessage(args).putString("action", "endGroup").putString("group", group);
        if (this.open && !this.paused) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("%s - Group end: Group[group=%s, args=%s]", this, group, args));
            }
            this.eventBus.send(this.inAddress, message);
        }
        this.groups.remove(group);
    }

    void doBatchStart(String batch, Object args) {
        this.checkOpen();
        JsonObject message = this.createMessage(args).putString("batch", batch).putString("action", "startBatch");
        if (this.open && !this.paused) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("%s - Batch start: Batch[batch=%s]", this, batch));
            }
            this.eventBus.send(this.inAddress, message);
        }
        this.checkFull();
    }

    void doBatchSend(String batch, Object value) {
        this.checkOpen();
        JsonObject message = this.createMessage(value).putString("action", "batch").putString("batch", batch);
        if (this.open && !this.paused) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("%s - Batch send: Batch[batch=%s, id=%d, message=%s]", this, batch, message.getLong("id"), value));
            }
            this.eventBus.send(this.inAddress, message);
        }
        for (OutputHook hook : this.hooks) {
            hook.handleSend(value);
        }
        this.checkFull();
    }

    void doBatchEnd(String batch, Object args) {
        this.checkOpen();
        JsonObject message = this.createMessage(args).putString("action", "endBatch").putString("batch", batch);
        if (this.open && !this.paused) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("%s - Batch end: Batch[batch=%s, args=%s]", this, batch, args));
            }
            this.eventBus.send(this.inAddress, message);
        }
        if (this.currentBatch != null && this.currentBatch.id().equals(batch)) {
            this.currentBatch = null;
        }
    }

    private JsonObject createMessage(Object value) {
        JsonObject message = this.serializer.serialize(value);
        long id = this.currentMessage++;
        message.putNumber("id", (Number)id);
        this.messages.put(id, message);
        return message;
    }

    @Override
    public OutputConnection send(Object message) {
        return this.doSend(message);
    }

    @Override
    public OutputConnection send(String message) {
        return this.doSend(message);
    }

    @Override
    public OutputConnection send(Boolean message) {
        return this.doSend(message);
    }

    @Override
    public OutputConnection send(Character message) {
        return this.doSend(message);
    }

    @Override
    public OutputConnection send(Short message) {
        return this.doSend(message);
    }

    @Override
    public OutputConnection send(Integer message) {
        return this.doSend(message);
    }

    @Override
    public OutputConnection send(Long message) {
        return this.doSend(message);
    }

    @Override
    public OutputConnection send(Double message) {
        return this.doSend(message);
    }

    @Override
    public OutputConnection send(Float message) {
        return this.doSend(message);
    }

    @Override
    public OutputConnection send(JsonObject message) {
        return this.doSend(message);
    }

    @Override
    public OutputConnection send(JsonArray message) {
        return this.doSend(message);
    }

    @Override
    public OutputConnection send(Byte message) {
        return this.doSend(message);
    }

    @Override
    public OutputConnection send(byte[] message) {
        return this.doSend(message);
    }

    @Override
    public OutputConnection send(Buffer message) {
        return this.doSend(message);
    }

    public String toString() {
        return this.context.toString();
    }
}

