/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.io.connection.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.kuujo.vertigo.hook.InputHook;
import net.kuujo.vertigo.io.batch.InputBatch;
import net.kuujo.vertigo.io.connection.InputConnection;
import net.kuujo.vertigo.io.connection.InputConnectionContext;
import net.kuujo.vertigo.io.connection.impl.DefaultConnectionInputBatch;
import net.kuujo.vertigo.io.connection.impl.DefaultConnectionInputGroup;
import net.kuujo.vertigo.io.connection.impl.DefaultInputConnectionContext;
import net.kuujo.vertigo.io.group.InputGroup;
import net.kuujo.vertigo.io.impl.InputDeserializer;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.eventbus.EventBus;
import org.vertx.java.core.eventbus.Message;
import org.vertx.java.core.json.JsonObject;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;

public class DefaultInputConnection
implements InputConnection {
    private static final long BATCH_SIZE = 1000L;
    private static final long MAX_BATCH_TIME = 100L;
    private final Logger log;
    private final Vertx vertx;
    private final EventBus eventBus;
    private final InputConnectionContext context;
    private final String inAddress;
    private final String outAddress;
    private List<InputHook> hooks = new ArrayList<InputHook>();
    private Handler<InputGroup> groupHandler;
    private final Map<String, Handler<InputGroup>> groupHandlers = new HashMap<String, Handler<InputGroup>>();
    private final Map<String, DefaultConnectionInputGroup> groups = new HashMap<String, DefaultConnectionInputGroup>();
    private final InputDeserializer deserializer = new InputDeserializer();
    private Handler messageHandler;
    private Handler<InputBatch> batchHandler;
    private DefaultConnectionInputBatch currentBatch;
    private long lastReceived;
    private long lastFeedbackTime;
    private long feedbackTimerID;
    private boolean open;
    private boolean connected;
    private boolean paused;
    private final Handler<Long> internalTimer = new Handler<Long>(){

        public void handle(Long timerID) {
            long currentTime = System.currentTimeMillis();
            if (currentTime - DefaultInputConnection.this.lastFeedbackTime > 1000L) {
                DefaultInputConnection.this.ack();
            }
        }
    };
    private final Handler<Message<JsonObject>> internalMessageHandler = new Handler<Message<JsonObject>>(){

        public void handle(Message<JsonObject> message) {
            if (DefaultInputConnection.this.open && !DefaultInputConnection.this.paused) {
                String action;
                switch (action = ((JsonObject)message.body()).getString("action")) {
                    case "message": {
                        if (!DefaultInputConnection.this.checkID(((JsonObject)message.body()).getLong("id"))) break;
                        DefaultInputConnection.this.doMessage((JsonObject)message.body());
                        break;
                    }
                    case "startGroup": {
                        if (!DefaultInputConnection.this.checkID(((JsonObject)message.body()).getLong("id"))) break;
                        DefaultInputConnection.this.doGroupStart((JsonObject)message.body());
                        break;
                    }
                    case "group": {
                        if (!DefaultInputConnection.this.checkID(((JsonObject)message.body()).getLong("id"))) break;
                        DefaultInputConnection.this.doGroupMessage((JsonObject)message.body());
                        break;
                    }
                    case "endGroup": {
                        if (!DefaultInputConnection.this.checkID(((JsonObject)message.body()).getLong("id"))) break;
                        DefaultInputConnection.this.doGroupEnd((JsonObject)message.body());
                        break;
                    }
                    case "startBatch": {
                        if (!DefaultInputConnection.this.checkID(((JsonObject)message.body()).getLong("id"))) break;
                        DefaultInputConnection.this.doBatchStart((JsonObject)message.body());
                        break;
                    }
                    case "batch": {
                        if (!DefaultInputConnection.this.checkID(((JsonObject)message.body()).getLong("id"))) break;
                        DefaultInputConnection.this.doBatchMessage((JsonObject)message.body());
                        break;
                    }
                    case "endBatch": {
                        if (!DefaultInputConnection.this.checkID(((JsonObject)message.body()).getLong("id"))) break;
                        DefaultInputConnection.this.doBatchEnd((JsonObject)message.body());
                        break;
                    }
                    case "connect": {
                        DefaultInputConnection.this.doConnect((Message<JsonObject>)message);
                        break;
                    }
                    case "disconnect": {
                        DefaultInputConnection.this.doDisconnect((Message<JsonObject>)message);
                    }
                }
            }
        }
    };

    public DefaultInputConnection(Vertx vertx, String address) {
        this(vertx, (InputConnectionContext)((DefaultInputConnectionContext.Builder)DefaultInputConnectionContext.Builder.newBuilder().setAddress(address)).build());
    }

    public DefaultInputConnection(Vertx vertx, InputConnectionContext context) {
        this.vertx = vertx;
        this.eventBus = vertx.eventBus();
        this.context = context;
        this.inAddress = String.format("%s.in", context.address());
        this.outAddress = String.format("%s.out", context.address());
        this.log = LoggerFactory.getLogger((String)String.format("%s-%s", DefaultInputConnection.class.getName(), context.address()));
        this.hooks = context.hooks();
    }

    @Override
    public String address() {
        return this.context.address();
    }

    @Override
    public InputConnectionContext context() {
        return this.context;
    }

    @Override
    public Vertx vertx() {
        return this.vertx;
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public InputConnection open() {
        return this.open((Handler)null);
    }

    @Override
    public InputConnection open(final Handler<AsyncResult<Void>> doneHandler) {
        this.eventBus.registerHandler(this.inAddress, this.internalMessageHandler, (Handler)new Handler<AsyncResult<Void>>(){

            public void handle(AsyncResult<Void> result) {
                if (result.succeeded()) {
                    DefaultInputConnection.this.log.info((Object)String.format("%s - Opened connection to %s", DefaultInputConnection.this, DefaultInputConnection.this.context.source()));
                    if (DefaultInputConnection.this.feedbackTimerID == 0L) {
                        DefaultInputConnection.this.log.debug((Object)String.format("%s - Starting periodic ack timer with max batch interval: %d", DefaultInputConnection.this, 100L));
                        DefaultInputConnection.this.feedbackTimerID = DefaultInputConnection.this.vertx.setPeriodic(100L, DefaultInputConnection.this.internalTimer);
                    }
                    DefaultInputConnection.this.open = true;
                } else {
                    DefaultInputConnection.this.log.warn((Object)String.format("%s - Failed to open connection to %s", DefaultInputConnection.this, DefaultInputConnection.this.context.source()));
                }
                doneHandler.handle(result);
            }
        });
        return this;
    }

    private boolean checkID(long id) {
        if (this.lastReceived == 0L || id == this.lastReceived + 1L || id < this.lastReceived) {
            this.lastReceived = id;
            if (this.lastReceived % 1000L == 0L) {
                this.ack();
            }
            return true;
        }
        this.fail();
        return false;
    }

    private void ack() {
        if (this.open && this.connected) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("%s - Acking messages up to: %d", this, this.lastReceived));
            }
            this.eventBus.send(this.outAddress, new JsonObject().putString("action", "ack").putNumber("id", (Number)this.lastReceived));
            this.lastFeedbackTime = System.currentTimeMillis();
        }
    }

    private void fail() {
        if (this.open && this.connected) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("%s - Received a message out of order: %d", this, this.lastReceived));
            }
            this.eventBus.send(this.outAddress, new JsonObject().putString("action", "fail").putNumber("id", (Number)this.lastReceived));
            this.lastFeedbackTime = System.currentTimeMillis();
        }
    }

    @Override
    public InputConnection pause() {
        if (!this.paused) {
            this.paused = true;
            if (this.open && this.connected) {
                this.log.debug((Object)String.format("%s - Pausing connection: %s", this, this.context.source()));
                this.eventBus.send(this.outAddress, new JsonObject().putString("action", "pause").putNumber("id", (Number)this.lastReceived));
            }
        }
        return this;
    }

    @Override
    public InputConnection resume() {
        if (this.paused) {
            this.paused = false;
            if (this.open && this.connected) {
                this.log.debug((Object)String.format("%s - Resuming connection: %s", this, this.context.source()));
                this.eventBus.send(this.outAddress, new JsonObject().putString("action", "resume").putNumber("id", (Number)this.lastReceived));
            }
        }
        return this;
    }

    @Override
    public InputConnection messageHandler(Handler handler) {
        this.messageHandler = handler;
        return this;
    }

    @Override
    public InputConnection batchHandler(Handler<InputBatch> handler) {
        this.batchHandler = handler;
        return this;
    }

    @Override
    public InputConnection groupHandler(Handler<InputGroup> handler) {
        this.groupHandler = handler;
        return this;
    }

    @Override
    public InputConnection groupHandler(String group, Handler<InputGroup> handler) {
        this.groupHandlers.put(group, handler);
        return this;
    }

    private void doMessage(JsonObject message) {
        Object value = this.deserializer.deserialize(message);
        if (value != null && this.messageHandler != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("%s - Received: Message[id=%d, value=%s]", this, message.getLong("id"), value));
            }
            this.messageHandler.handle(value);
        }
        for (InputHook hook : this.hooks) {
            hook.handleReceive(value);
        }
    }

    private void doGroupStart(JsonObject message) {
        String groupID = message.getString("group");
        String name = message.getString("name");
        String parentId = message.getString("parent");
        Object args = this.deserializer.deserialize(message);
        DefaultConnectionInputGroup group = new DefaultConnectionInputGroup(groupID, name, this);
        this.groups.put(groupID, group);
        if (parentId != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("%s - Group started: Group[name=%s, group=%s, parent=%s, args=%s]", this, name, groupID, parentId, args));
            }
            if (this.currentBatch != null && parentId.equals(this.currentBatch.id())) {
                this.currentBatch.handleGroup(group);
            } else {
                DefaultConnectionInputGroup parent = this.groups.get(parentId);
                if (parent != null) {
                    parent.handleGroup(group);
                }
            }
        } else {
            Handler<InputGroup> handler;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("%s - Group started: Group[name=%s, group=%s, args=%s]", this, name, groupID, args));
            }
            if ((handler = this.groupHandlers.get(name)) != null) {
                handler.handle((Object)group);
            } else if (this.groupHandler != null) {
                this.groupHandler.handle((Object)group);
            } else {
                this.groupReady(groupID);
            }
        }
        group.handleStart(args);
    }

    void groupReady(String group) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("%s - Group ready: Group[group=%s]", this, group));
        }
        this.eventBus.send(this.outAddress, new JsonObject().putString("action", "group").putString("group", group));
    }

    private void doGroupMessage(JsonObject message) {
        Object value;
        String groupID = message.getString("group");
        DefaultConnectionInputGroup group = this.groups.get(groupID);
        if (group != null && (value = this.deserializer.deserialize(message)) != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("%s - Group received: Group[group=%s, id=%d, message=%s", this, groupID, message.getLong("id"), value));
            }
            group.handleMessage(value);
        }
    }

    private void doGroupEnd(JsonObject message) {
        String groupID = message.getString("group");
        DefaultConnectionInputGroup group = this.groups.remove(groupID);
        if (group != null) {
            Object args = this.deserializer.deserialize(message);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("%s - Group ended: Group[group=%s, args=%s]", this, group.id(), args));
            }
            group.handleEnd(args);
        }
    }

    private void doBatchStart(JsonObject message) {
        if (this.currentBatch != null) {
            this.currentBatch.handleEnd(null);
        }
        String batchID = message.getString("batch");
        Object args = this.deserializer.deserialize(message);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("%s - Batch started: Batch[batch=%s, args=%s]", this, batchID, args));
        }
        this.currentBatch = new DefaultConnectionInputBatch(batchID, this);
        if (this.batchHandler != null) {
            this.batchHandler.handle((Object)this.currentBatch);
        }
        this.currentBatch.handleStart(args);
    }

    void batchReady(String batch) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("%s - Batch ready: Batch[batch=%s]", this, batch));
        }
        this.eventBus.send(this.outAddress, new JsonObject().putString("action", "batch").putString("batch", batch));
    }

    private void doBatchMessage(JsonObject message) {
        Object value;
        String batchID = message.getString("batch");
        if (this.currentBatch != null && this.currentBatch.id().equals(batchID) && (value = this.deserializer.deserialize(message)) != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("%s - Batch received: Batch[batch=%s, id=%d, message=%s]", this, batchID, message.getLong("id"), value));
            }
            this.currentBatch.handleMessage(value);
        }
    }

    private void doBatchEnd(JsonObject message) {
        if (this.currentBatch != null) {
            Object args = this.deserializer.deserialize(message);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("%s - Batch ended: Batch[batch=%s, args=%s]", this, this.currentBatch.id(), args));
            }
            this.currentBatch.handleEnd(args);
            this.currentBatch = null;
        }
    }

    private void doConnect(Message<JsonObject> message) {
        if (this.open) {
            if (!this.connected) {
                this.groups.clear();
                this.connected = true;
            }
            message.reply(Boolean.valueOf(true));
            this.log.debug((Object)String.format("%s - Accepted connect request from %s", this, this.context.source()));
        } else {
            message.reply(Boolean.valueOf(false));
            this.log.debug((Object)String.format("%s - Rejected connect request from %s, connection not open", this, this.context.source()));
        }
    }

    private void doDisconnect(Message<JsonObject> message) {
        if (this.open) {
            if (this.connected) {
                this.groups.clear();
                this.connected = false;
            }
            message.reply(Boolean.valueOf(true));
            this.log.debug((Object)String.format("%s - Accepted disconnect request from %s", this, this.context.source()));
        } else {
            message.reply(Boolean.valueOf(false));
            this.log.debug((Object)String.format("%s - Rejected connect request from %s, connection not open", this, this.context.source()));
        }
    }

    @Override
    public void close() {
        this.close(null);
    }

    @Override
    public void close(final Handler<AsyncResult<Void>> doneHandler) {
        this.eventBus.unregisterHandler(this.inAddress, this.internalMessageHandler, (Handler)new Handler<AsyncResult<Void>>(){

            public void handle(AsyncResult<Void> result) {
                if (DefaultInputConnection.this.feedbackTimerID > 0L) {
                    DefaultInputConnection.this.log.debug((Object)String.format("%s - Stopping periodic ack timer ", DefaultInputConnection.this, DefaultInputConnection.this.feedbackTimerID));
                    DefaultInputConnection.this.vertx.cancelTimer(DefaultInputConnection.this.feedbackTimerID);
                    DefaultInputConnection.this.feedbackTimerID = 0L;
                }
                DefaultInputConnection.this.open = false;
                DefaultInputConnection.this.log.info((Object)String.format("%s - Closed connection from %s", DefaultInputConnection.this, DefaultInputConnection.this.context.source()));
                doneHandler.handle(result);
            }
        });
    }

    public String toString() {
        return this.context.toString();
    }
}

