/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.io.connection.impl;

import java.util.HashMap;
import java.util.Map;
import net.kuujo.vertigo.io.batch.InputBatch;
import net.kuujo.vertigo.io.connection.impl.ConnectionInputBatch;
import net.kuujo.vertigo.io.connection.impl.DefaultInputConnection;
import net.kuujo.vertigo.io.group.InputGroup;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;

public class DefaultConnectionInputBatch
implements ConnectionInputBatch {
    private final String id;
    private final DefaultInputConnection connection;
    private Handler messageHandler;
    private Handler startHandler;
    private Handler endHandler;
    private Handler<InputGroup> groupHandler;
    private final Map<String, Handler<InputGroup>> groupHandlers = new HashMap<String, Handler<InputGroup>>();
    private boolean started;

    public DefaultConnectionInputBatch(String id, DefaultInputConnection connection) {
        this.id = id;
        this.connection = connection;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public Vertx vertx() {
        return this.connection.vertx();
    }

    @Override
    public InputBatch pause() {
        this.connection.pause();
        return this;
    }

    @Override
    public InputBatch resume() {
        this.connection.resume();
        return this;
    }

    void handleStart(Object args) {
        if (this.startHandler != null) {
            this.startHandler.handle(args);
        }
    }

    @Override
    public <T> InputBatch startHandler(Handler<T> handler) {
        this.startHandler = handler;
        return this;
    }

    void handleMessage(Object message) {
        if (this.messageHandler != null) {
            this.messageHandler.handle(message);
        }
    }

    @Override
    public InputBatch messageHandler(Handler handler) {
        this.messageHandler = handler;
        if (!this.started && handler != null) {
            this.connection.batchReady(this.id);
            this.started = true;
        }
        return this;
    }

    void handleGroup(InputGroup group) {
        Handler<InputGroup> handler = this.groupHandlers.get(group.name());
        if (handler != null) {
            handler.handle((Object)group);
        } else if (this.groupHandler != null) {
            this.groupHandler.handle((Object)group);
        } else {
            this.connection.groupReady(group.id());
        }
    }

    @Override
    public InputBatch groupHandler(Handler<InputGroup> handler) {
        this.groupHandler = handler;
        if (handler != null && !this.started) {
            this.connection.batchReady(this.id);
            this.started = true;
        }
        return this;
    }

    @Override
    public InputBatch groupHandler(String group, Handler<InputGroup> handler) {
        if (handler != null) {
            this.groupHandlers.put(group, handler);
            if (!this.started) {
                this.connection.batchReady(this.id);
                this.started = true;
            }
        } else {
            this.groupHandlers.remove(group);
        }
        return this;
    }

    void handleEnd(Object args) {
        if (this.endHandler != null) {
            this.endHandler.handle(args);
        }
    }

    @Override
    public <T> InputBatch endHandler(Handler<T> handler) {
        this.endHandler = handler;
        return this;
    }
}

