/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.io.connection.impl;

import net.kuujo.vertigo.impl.BaseContext;
import net.kuujo.vertigo.io.connection.ConnectionContext;

public abstract class DefaultConnectionContext<T extends ConnectionContext<T>>
extends BaseContext<T>
implements ConnectionContext<T> {
    protected ConnectionContext.SourceContext source;
    protected ConnectionContext.TargetContext target;

    @Override
    public ConnectionContext.SourceContext source() {
        return this.source;
    }

    @Override
    public ConnectionContext.TargetContext target() {
        return this.target;
    }

    @Override
    public String toString() {
        return String.format("Connection[%s-%d:%s->%s-%d:%s]", this.source.component(), this.source.instance(), this.source.port(), this.target.component(), this.target.instance(), this.target.port());
    }

    public static class DefaultTargetContext
    extends DefaultEndpointContext<ConnectionContext.TargetContext>
    implements ConnectionContext.TargetContext {
        @Override
        public String toString() {
            return String.format("Target[%s-%d:%s]", this.component, this.instance, this.port);
        }

        public static class Builder
        extends DefaultEndpointContext.Builder<DefaultTargetContext, Builder> {
            private Builder() {
                super(new DefaultTargetContext());
            }

            protected Builder(DefaultTargetContext context) {
                super(context);
            }

            public static Builder newBuilder() {
                return new Builder();
            }

            public static Builder newBuilder(DefaultTargetContext context) {
                return new Builder(context);
            }
        }
    }

    public static class DefaultSourceContext
    extends DefaultEndpointContext<ConnectionContext.SourceContext>
    implements ConnectionContext.SourceContext {
        @Override
        public String toString() {
            return String.format("Source[%s-%d:%s]", this.component, this.instance, this.port);
        }

        public static class Builder
        extends DefaultEndpointContext.Builder<DefaultSourceContext, Builder> {
            private Builder() {
                super(new DefaultSourceContext());
            }

            protected Builder(DefaultSourceContext context) {
                super(context);
            }

            public static Builder newBuilder() {
                return new Builder();
            }

            public static Builder newBuilder(DefaultSourceContext context) {
                return new Builder(context);
            }
        }
    }

    public static class DefaultEndpointContext<T extends ConnectionContext.EndpointContext<T>>
    extends BaseContext<T>
    implements ConnectionContext.EndpointContext<T> {
        protected String address;
        protected String component;
        protected String port;
        protected int instance;

        @Override
        public String address() {
            return this.address;
        }

        @Override
        public String component() {
            return this.component;
        }

        @Override
        public String port() {
            return this.port;
        }

        @Override
        public int instance() {
            return this.instance;
        }

        @Override
        public String toString() {
            return String.format("Connection[%s-%d:%s]", this.component, this.instance, this.port);
        }

        public static class Builder<T extends DefaultEndpointContext, U extends Builder<T, U>>
        extends BaseContext.Builder<Builder<T, ?>, T> {
            protected Builder(T context) {
                super(context);
            }

            public U setComponent(String component) {
                ((DefaultEndpointContext)this.context).component = component;
                return (U)this;
            }

            public U setPort(String port) {
                ((DefaultEndpointContext)this.context).port = port;
                return (U)this;
            }

            public U setInstance(int instance) {
                ((DefaultEndpointContext)this.context).instance = instance;
                return (U)this;
            }
        }
    }
}

