/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.io.connection.impl;

import java.util.ArrayList;
import java.util.List;
import net.kuujo.vertigo.hook.IOHook;
import net.kuujo.vertigo.hook.InputHook;
import net.kuujo.vertigo.hook.OutputHook;
import net.kuujo.vertigo.io.connection.ConnectionConfig;
import net.kuujo.vertigo.io.selector.AllSelector;
import net.kuujo.vertigo.io.selector.CustomSelector;
import net.kuujo.vertigo.io.selector.FairSelector;
import net.kuujo.vertigo.io.selector.HashSelector;
import net.kuujo.vertigo.io.selector.RandomSelector;
import net.kuujo.vertigo.io.selector.RoundRobinSelector;
import net.kuujo.vertigo.io.selector.Selector;
import net.kuujo.vertigo.network.NetworkConfig;
import net.kuujo.vertigo.util.Args;

public class DefaultConnectionConfig
implements ConnectionConfig {
    private static final String DEFAULT_OUT_PORT = "out";
    private static final String DEFAULT_IN_PORT = "in";
    private ConnectionConfig.Source source = new DefaultSource();
    private ConnectionConfig.Target target = new DefaultTarget();
    private List<IOHook> hooks = new ArrayList<IOHook>();
    private Selector selector;

    public DefaultConnectionConfig() {
        this.selector = new RoundRobinSelector();
    }

    public DefaultConnectionConfig(String source, String target, NetworkConfig network) {
        this(source, DEFAULT_OUT_PORT, target, DEFAULT_IN_PORT, new RoundRobinSelector(), network);
    }

    public DefaultConnectionConfig(String source, String target, Selector selector, NetworkConfig network) {
        this(source, DEFAULT_OUT_PORT, target, DEFAULT_IN_PORT, selector, network);
    }

    public DefaultConnectionConfig(String source, String out, String target, String in, NetworkConfig network) {
        this(source, out, target, in, new RoundRobinSelector(), network);
    }

    public DefaultConnectionConfig(String source, String out, String target, String in, Selector selector, NetworkConfig network) {
        Args.checkNotNull(source, "connection source cannot be null", new Object[0]);
        Args.checkNotNull(target, "connection target cannot be null", new Object[0]);
        this.source.setComponent(source);
        this.source.setPort(out != null ? out : DEFAULT_OUT_PORT);
        this.target.setComponent(target);
        this.target.setPort(in != null ? in : DEFAULT_IN_PORT);
        if (selector == null) {
            selector = new RoundRobinSelector();
        }
        this.selector = selector;
    }

    @Override
    public ConnectionConfig.Source getSource() {
        return this.source;
    }

    @Override
    public ConnectionConfig.Target getTarget() {
        return this.target;
    }

    @Override
    public ConnectionConfig addHook(IOHook hook) {
        if (hook != null) {
            this.hooks.add(hook);
        }
        return this;
    }

    @Override
    public List<IOHook> getHooks() {
        return this.hooks;
    }

    @Override
    public Selector getSelector() {
        return this.selector;
    }

    @Override
    public ConnectionConfig setSelector(Selector selector) {
        return this.customSelect(selector);
    }

    @Override
    public ConnectionConfig roundSelect() {
        this.selector = new RoundRobinSelector();
        return this;
    }

    @Override
    public ConnectionConfig randomSelect() {
        this.selector = new RandomSelector();
        return this;
    }

    @Override
    public ConnectionConfig hashSelect() {
        this.selector = new HashSelector();
        return this;
    }

    @Override
    public ConnectionConfig fairSelect() {
        this.selector = new FairSelector();
        return this;
    }

    @Override
    public ConnectionConfig allSelect() {
        this.selector = new AllSelector();
        return this;
    }

    @Override
    public ConnectionConfig customSelect(Selector selector) {
        this.selector = selector == null ? new RoundRobinSelector() : (selector instanceof RoundRobinSelector || selector instanceof RandomSelector || selector instanceof HashSelector || selector instanceof FairSelector || selector instanceof AllSelector ? selector : new CustomSelector(selector));
        return this;
    }

    public boolean equals(Object other) {
        if (!(other instanceof ConnectionConfig)) {
            return false;
        }
        ConnectionConfig connection = (ConnectionConfig)other;
        return connection.getSource().getComponent().equals(this.source.getComponent()) && connection.getSource().getPort().equals(this.source.getPort()) && connection.getTarget().getComponent().equals(this.target.getComponent()) && connection.getTarget().getPort().equals(this.target.getPort());
    }

    public static class DefaultTarget
    implements ConnectionConfig.Target {
        private String component;
        private String port;
        private List<InputHook> hooks = new ArrayList<InputHook>();

        private DefaultTarget() {
        }

        @Override
        public String getComponent() {
            return this.component;
        }

        @Override
        public ConnectionConfig.Target setComponent(String component) {
            Args.checkNotNull(component, "component cannot be null", new Object[0]);
            this.component = component;
            return this;
        }

        @Override
        public String getPort() {
            return this.port;
        }

        @Override
        public ConnectionConfig.Target setPort(String port) {
            Args.checkNotNull(port, "port cannot be null", new Object[0]);
            this.port = port;
            return this;
        }

        @Override
        public ConnectionConfig.Target addHook(InputHook hook) {
            if (hook != null) {
                this.hooks.add(hook);
            }
            return this;
        }

        @Override
        public List<InputHook> getHooks() {
            return this.hooks;
        }
    }

    public static class DefaultSource
    implements ConnectionConfig.Source {
        private String component;
        private String port;
        private List<OutputHook> hooks = new ArrayList<OutputHook>();

        private DefaultSource() {
        }

        @Override
        public String getComponent() {
            return this.component;
        }

        @Override
        public ConnectionConfig.Source setComponent(String component) {
            Args.checkNotNull(component, "component cannot be null", new Object[0]);
            this.component = component;
            return this;
        }

        @Override
        public String getPort() {
            return this.port;
        }

        @Override
        public ConnectionConfig.Source setPort(String port) {
            Args.checkNotNull(port, "port cannot be null", new Object[0]);
            this.port = port;
            return this;
        }

        @Override
        public ConnectionConfig.Source addHook(OutputHook hook) {
            if (hook != null) {
                this.hooks.add(hook);
            }
            return this;
        }

        @Override
        public List<OutputHook> getHooks() {
            return this.hooks;
        }
    }
}

