/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.component.impl;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.kuujo.vertigo.component.ComponentConfig;
import net.kuujo.vertigo.component.VerticleConfig;
import net.kuujo.vertigo.hook.ComponentHook;
import net.kuujo.vertigo.network.NetworkConfig;
import net.kuujo.vertigo.util.Args;
import org.vertx.java.core.json.JsonObject;

public class DefaultVerticleConfig
implements VerticleConfig {
    private static final int DEFAULT_NUM_INSTANCES = 1;
    private static final String DEFAULT_GROUP = "__DEFAULT__";
    private String name;
    private Map<String, Object> config;
    private int instances = 1;
    private String group = "__DEFAULT__";
    private List<ComponentHook> hooks = new ArrayList<ComponentHook>();
    private String main;
    private boolean worker = false;
    @JsonProperty(value="multi-threaded")
    private boolean multiThreaded = false;

    public DefaultVerticleConfig() {
    }

    public DefaultVerticleConfig(String name, String main, NetworkConfig network) {
        this.setName(name);
        this.setMain(main);
    }

    @Override
    public ComponentConfig.Type getType() {
        return ComponentConfig.Type.VERTICLE;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public VerticleConfig setName(String name) {
        Args.checkNotNull(name, "component name must not be null", new Object[0]);
        this.name = name;
        return this;
    }

    @Override
    public JsonObject getConfig() {
        return this.config != null ? new JsonObject(this.config) : new JsonObject();
    }

    @Override
    public VerticleConfig setConfig(JsonObject config) {
        this.config = config != null ? config.toMap() : new HashMap();
        return this;
    }

    @Override
    public int getInstances() {
        return this.instances;
    }

    @Override
    public VerticleConfig setInstances(int instances) {
        Args.checkPositive(instances, "instances must be a positive number", new Object[0]);
        this.instances = instances;
        return this;
    }

    @Override
    public VerticleConfig setGroup(String group) {
        this.group = group;
        return this;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public VerticleConfig addHook(ComponentHook hook) {
        if (hook != null) {
            this.hooks.add(hook);
        }
        return this;
    }

    @Override
    public List<ComponentHook> getHooks() {
        return this.hooks;
    }

    @Override
    @JsonSetter(value="main")
    public VerticleConfig setMain(String main) {
        Args.checkNotNull(main, "verticle main must not be null", new Object[0]);
        this.main = main;
        return this;
    }

    @Override
    public String getMain() {
        return this.main;
    }

    @Override
    public VerticleConfig setWorker(boolean isWorker) {
        this.worker = isWorker;
        if (!this.worker) {
            this.multiThreaded = false;
        }
        return this;
    }

    @Override
    public boolean isWorker() {
        return this.worker;
    }

    @Override
    public VerticleConfig setMultiThreaded(boolean isMultiThreaded) {
        this.multiThreaded = isMultiThreaded;
        return this;
    }

    @Override
    public boolean isMultiThreaded() {
        return this.multiThreaded;
    }
}

