/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.component.impl;

import com.fasterxml.jackson.annotation.JsonIgnore;
import net.kuujo.vertigo.component.ComponentContext;
import net.kuujo.vertigo.component.InstanceContext;
import net.kuujo.vertigo.component.impl.DefaultComponentContext;
import net.kuujo.vertigo.impl.BaseContext;
import net.kuujo.vertigo.io.InputContext;
import net.kuujo.vertigo.io.OutputContext;
import net.kuujo.vertigo.io.impl.DefaultInputContext;
import net.kuujo.vertigo.io.impl.DefaultOutputContext;
import net.kuujo.vertigo.util.serialization.Serializer;
import net.kuujo.vertigo.util.serialization.SerializerFactory;
import org.vertx.java.core.json.JsonObject;

public final class DefaultInstanceContext
extends BaseContext<InstanceContext>
implements InstanceContext {
    private int number;
    private String status;
    private InputContext input;
    private OutputContext output;
    @JsonIgnore
    private ComponentContext<?> component;

    private DefaultInstanceContext() {
    }

    public static DefaultInstanceContext fromJson(JsonObject context) {
        Serializer serializer = SerializerFactory.getSerializer(DefaultInstanceContext.class);
        DefaultInstanceContext instance = serializer.deserializeObject(context.getObject("instance"), DefaultInstanceContext.class);
        Object component = DefaultComponentContext.fromJson(context);
        return instance.setComponentContext((DefaultComponentContext<?>)component);
    }

    public static JsonObject toJson(InstanceContext context) {
        Serializer serializer = SerializerFactory.getSerializer(DefaultInstanceContext.class);
        JsonObject json = DefaultComponentContext.toJson(context.component().isModule() ? context.component() : context.component());
        return json.putObject("instance", serializer.serializeToObject(context));
    }

    DefaultInstanceContext setComponentContext(DefaultComponentContext<?> component) {
        this.component = component;
        return this;
    }

    @Override
    public int number() {
        return this.number;
    }

    @Override
    public String address() {
        return this.address;
    }

    @Override
    public String status() {
        return this.status;
    }

    @Override
    public InputContext input() {
        return (InputContext)((DefaultInputContext)this.input).setInstanceContext(this);
    }

    @Override
    public OutputContext output() {
        return (OutputContext)((DefaultOutputContext)this.output).setInstanceContext(this);
    }

    @Override
    public <T extends ComponentContext> T component() {
        return (T)this.component;
    }

    @Override
    public void notify(InstanceContext update) {
        if (update == null) {
            this.input.notify(null);
            this.output.notify(null);
        } else {
            this.input.notify(update.input());
            this.output.notify(update.output());
        }
        super.notify(this);
    }

    @Override
    public String toString() {
        return this.address();
    }

    public static class Builder
    extends BaseContext.Builder<Builder, DefaultInstanceContext> {
        private Builder() {
            super(new DefaultInstanceContext());
        }

        private Builder(DefaultInstanceContext context) {
            super(context);
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static Builder newBuilder(DefaultInstanceContext context) {
            return new Builder(context);
        }

        public Builder setStatusAddress(String address) {
            ((DefaultInstanceContext)this.context).status = address;
            return this;
        }

        public Builder setNumber(int number) {
            ((DefaultInstanceContext)this.context).number = number;
            return this;
        }

        public Builder setInput(DefaultInputContext input) {
            ((DefaultInstanceContext)this.context).input = (InputContext)input.setInstanceContext((DefaultInstanceContext)this.context);
            return this;
        }

        public Builder setOutput(DefaultOutputContext output) {
            ((DefaultInstanceContext)this.context).output = (OutputContext)output.setInstanceContext((DefaultInstanceContext)this.context);
            return this;
        }
    }
}

