/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.component.impl;

import net.kuujo.vertigo.VertigoException;
import net.kuujo.vertigo.cluster.Cluster;
import net.kuujo.vertigo.cluster.data.MapEvent;
import net.kuujo.vertigo.cluster.data.WatchableAsyncMap;
import net.kuujo.vertigo.cluster.data.impl.WrappedWatchableAsyncMap;
import net.kuujo.vertigo.component.ComponentCoordinator;
import net.kuujo.vertigo.component.InstanceContext;
import net.kuujo.vertigo.component.impl.DefaultInstanceContext;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.impl.DefaultFutureResult;
import org.vertx.java.core.json.JsonObject;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;

public class DefaultComponentCoordinator
implements ComponentCoordinator {
    private final Logger log;
    private final String address;
    private final Vertx vertx;
    private Cluster cluster;
    private WatchableAsyncMap<String, String> data;
    private InstanceContext currentContext;
    private Handler<Void> resumeHandler;
    private Handler<Void> pauseHandler;
    private boolean paused = true;
    private final Handler<MapEvent<String, String>> instanceHandler = new Handler<MapEvent<String, String>>(){

        public void handle(MapEvent<String, String> event) {
            if (DefaultComponentCoordinator.this.currentContext != null && !event.type().equals((Object)MapEvent.Type.CHANGE)) {
                DefaultComponentCoordinator.this.log.info((Object)String.format("%s - Configuration change detected, updating context", DefaultComponentCoordinator.this));
                DefaultComponentCoordinator.this.currentContext.notify(DefaultInstanceContext.fromJson(new JsonObject(event.value())));
            }
        }
    };
    private final Handler<MapEvent<String, String>> statusHandler = new Handler<MapEvent<String, String>>(){

        public void handle(MapEvent<String, String> event) {
            if (event.type().equals((Object)MapEvent.Type.CREATE) || event.type().equals((Object)MapEvent.Type.UPDATE)) {
                DefaultComponentCoordinator.this.log.debug((Object)String.format("%s - Resumed", DefaultComponentCoordinator.this));
                DefaultComponentCoordinator.this.paused = false;
                DefaultComponentCoordinator.this.checkResume();
            } else if (event.type().equals((Object)MapEvent.Type.DELETE)) {
                DefaultComponentCoordinator.this.log.debug((Object)String.format("%s - Paused", DefaultComponentCoordinator.this));
                DefaultComponentCoordinator.this.paused = true;
                DefaultComponentCoordinator.this.checkPause();
            }
        }
    };

    public DefaultComponentCoordinator(InstanceContext context, Vertx vertx, Cluster cluster) {
        this.address = context.address();
        this.log = LoggerFactory.getLogger((String)String.format("%s-%s", DefaultComponentCoordinator.class.getName(), this.address));
        this.vertx = vertx;
        this.currentContext = context;
        this.cluster = cluster;
    }

    @Override
    public String address() {
        return this.address;
    }

    @Override
    public ComponentCoordinator start(final Handler<AsyncResult<InstanceContext>> doneHandler) {
        this.data = new WrappedWatchableAsyncMap<String, String>(this.cluster.getMap(this.currentContext.component().network().address()), this.vertx);
        this.log.debug((Object)String.format("%s - start() watching key at %s", this, this.address));
        this.data.watch(this.address, this.instanceHandler, new Handler<AsyncResult<Void>>(){

            public void handle(AsyncResult<Void> result) {
                if (result.failed()) {
                    new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                } else {
                    DefaultComponentCoordinator.this.data.get(DefaultComponentCoordinator.this.address, new Handler<AsyncResult<String>>(){

                        public void handle(AsyncResult<String> result) {
                            if (result.failed()) {
                                new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                            } else {
                                if (result.result() != null) {
                                    DefaultComponentCoordinator.this.currentContext.notify(DefaultInstanceContext.fromJson(new JsonObject((String)result.result())));
                                }
                                DefaultComponentCoordinator.this.log.debug((Object)String.format("%s - start() watching status key at %s", DefaultComponentCoordinator.this, DefaultComponentCoordinator.this.currentContext.component().network().status()));
                                DefaultComponentCoordinator.this.data.watch(DefaultComponentCoordinator.this.currentContext.component().network().status(), DefaultComponentCoordinator.this.statusHandler, new Handler<AsyncResult<Void>>(){

                                    public void handle(AsyncResult<Void> result) {
                                        if (result.failed()) {
                                            new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                                        } else {
                                            new DefaultFutureResult((Object)DefaultComponentCoordinator.this.currentContext).setHandler(doneHandler);
                                        }
                                    }
                                });
                            }
                        }
                    });
                }
            }
        });
        return this;
    }

    @Override
    public ComponentCoordinator resume() {
        return this.resume(null);
    }

    @Override
    public ComponentCoordinator resume(final Handler<AsyncResult<Void>> doneHandler) {
        if (this.currentContext != null && this.data != null) {
            this.log.debug((Object)String.format("%s - resume() setting status key at %s", this, this.currentContext.status()));
            this.data.put(this.currentContext.status(), "ready", new Handler<AsyncResult<String>>(){

                public void handle(AsyncResult<String> result) {
                    if (result.failed()) {
                        new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                    } else {
                        new DefaultFutureResult((Object)null).setHandler(doneHandler);
                    }
                }
            });
        } else {
            new DefaultFutureResult((Throwable)((Object)new VertigoException("No component context available."))).setHandler(doneHandler);
        }
        return this;
    }

    @Override
    public ComponentCoordinator pause() {
        return this.pause(null);
    }

    @Override
    public ComponentCoordinator pause(final Handler<AsyncResult<Void>> doneHandler) {
        if (this.currentContext != null && this.data != null) {
            this.log.debug((Object)String.format("%s - pause() clearing status key at %s", this, this.currentContext.status()));
            this.data.remove(this.currentContext.status(), new Handler<AsyncResult<String>>(){

                public void handle(AsyncResult<String> result) {
                    if (result.failed()) {
                        new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                    } else {
                        new DefaultFutureResult((Object)null).setHandler(doneHandler);
                    }
                }
            });
        } else {
            new DefaultFutureResult((Throwable)((Object)new VertigoException("No component context available."))).setHandler(doneHandler);
        }
        return this;
    }

    @Override
    public ComponentCoordinator resumeHandler(Handler<Void> handler) {
        this.resumeHandler = handler;
        this.checkResume();
        return this;
    }

    private void checkResume() {
        if (!this.paused && this.resumeHandler != null) {
            this.resumeHandler.handle((Object)null);
        }
    }

    @Override
    public ComponentCoordinator pauseHandler(Handler<Void> handler) {
        this.pauseHandler = handler;
        this.checkPause();
        return this;
    }

    private void checkPause() {
        if (this.paused && this.pauseHandler != null) {
            this.pauseHandler.handle((Object)null);
        }
    }

    @Override
    public void stop(final Handler<AsyncResult<Void>> doneHandler) {
        if (this.currentContext != null && this.data != null) {
            this.log.debug((Object)String.format("%s - stop() unwatching status key at %s", this, this.currentContext.component().network().status()));
            this.data.unwatch(this.currentContext.component().network().status(), this.statusHandler, new Handler<AsyncResult<Void>>(){

                public void handle(AsyncResult<Void> result) {
                    if (result.failed()) {
                        DefaultComponentCoordinator.this.data.unwatch(DefaultComponentCoordinator.this.address, DefaultComponentCoordinator.this.instanceHandler);
                        new DefaultFutureResult(result.cause()).setHandler(doneHandler);
                    } else {
                        DefaultComponentCoordinator.this.data.unwatch(DefaultComponentCoordinator.this.address, DefaultComponentCoordinator.this.instanceHandler, (Handler<AsyncResult<Void>>)doneHandler);
                    }
                    DefaultComponentCoordinator.this.currentContext = null;
                }
            });
        } else {
            this.data.unwatch(this.address, this.instanceHandler, doneHandler);
        }
    }

    public String toString() {
        return String.format("Coordinator[%s]", this.address);
    }
}

