/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.cluster.manager.impl;

import com.hazelcast.core.MultiMap;
import java.util.Collection;
import java.util.Map;
import java.util.Random;
import net.kuujo.vertigo.cluster.manager.GroupManager;
import net.kuujo.vertigo.cluster.manager.impl.ClusterData;
import net.kuujo.vertigo.cluster.manager.impl.ClusterListener;
import net.kuujo.vertigo.platform.PlatformManager;
import net.kuujo.vertigo.util.ContextManager;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.eventbus.Message;
import org.vertx.java.core.json.JsonArray;
import org.vertx.java.core.json.JsonObject;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;
import org.vertx.java.core.spi.Action;

public class DefaultGroupManager
implements GroupManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultGroupManager.class);
    private final String group;
    private final Vertx vertx;
    private final ContextManager context;
    private final PlatformManager platform;
    private final MultiMap<String, String> groups;
    private final MultiMap<String, String> deployments;
    private final Map<Object, String> nodeSelectors;
    private final Handler<Message<JsonObject>> messageHandler = new Handler<Message<JsonObject>>(){

        public void handle(Message<JsonObject> message) {
            String action;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Received message " + ((JsonObject)message.body()).encode()));
            }
            if ((action = ((JsonObject)message.body()).getString("action")) != null) {
                switch (action) {
                    case "ping": {
                        DefaultGroupManager.this.doPing((Message<JsonObject>)message);
                        break;
                    }
                    case "find": {
                        DefaultGroupManager.this.doFind((Message<JsonObject>)message);
                        break;
                    }
                    case "list": {
                        DefaultGroupManager.this.doList((Message<JsonObject>)message);
                        break;
                    }
                    case "select": {
                        DefaultGroupManager.this.doSelect((Message<JsonObject>)message);
                        break;
                    }
                    case "deploy": {
                        DefaultGroupManager.this.doDeploy((Message<JsonObject>)message);
                        break;
                    }
                    case "undeploy": {
                        DefaultGroupManager.this.doUndeploy((Message<JsonObject>)message);
                        break;
                    }
                    default: {
                        message.reply(new JsonObject().putString("status", "error").putString("message", "Invalid action " + action));
                        break;
                    }
                }
            } else {
                message.reply(new JsonObject().putString("status", "error").putString("message", "Must specify an action"));
            }
        }
    };

    public DefaultGroupManager(String group, String cluster, Vertx vertx, ContextManager context, PlatformManager platform, ClusterListener listener, ClusterData data) {
        this.group = group;
        this.vertx = vertx;
        this.context = context;
        this.platform = platform;
        this.groups = data.getMultiMap(String.format("groups.%s", cluster));
        this.deployments = data.getMultiMap(String.format("deployments.%s", cluster));
        this.nodeSelectors = data.getMap(String.format("selectors.node.%s", group));
    }

    @Override
    public String address() {
        return this.group;
    }

    @Override
    public GroupManager start() {
        return this.start(null);
    }

    @Override
    public GroupManager start(Handler<AsyncResult<Void>> doneHandler) {
        this.vertx.eventBus().registerHandler(this.group, this.messageHandler, doneHandler);
        return this;
    }

    @Override
    public void stop() {
        this.stop(null);
    }

    @Override
    public void stop(final Handler<AsyncResult<Void>> doneHandler) {
        this.context.execute(new Action<Void>(){

            public Void perform() {
                DefaultGroupManager.this.groups.remove((Object)DefaultGroupManager.this.group);
                return null;
            }
        }, new Handler<AsyncResult<Void>>(){

            public void handle(AsyncResult<Void> result) {
                DefaultGroupManager.this.vertx.eventBus().unregisterHandler(DefaultGroupManager.this.group, DefaultGroupManager.this.messageHandler, doneHandler);
            }
        });
    }

    private void doPing(Message<JsonObject> message) {
        message.reply(new JsonObject().putString("status", "pong").putString("result", "group"));
    }

    private void doFind(Message<JsonObject> message) {
        String type = ((JsonObject)message.body()).getString("type");
        if (type != null) {
            switch (type) {
                case "node": {
                    this.doFindNode(message);
                    break;
                }
                default: {
                    message.reply(new JsonObject().putString("status", "error").putString("message", "Invalid type specified."));
                    break;
                }
            }
        } else {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No type specified."));
        }
    }

    private void doFindNode(final Message<JsonObject> message) {
        String nodeName = ((JsonObject)message.body()).getString("node");
        if (nodeName == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No node specified."));
            return;
        }
        final String address = String.format("%s.%s", this.group, nodeName);
        this.context.execute(new Action<Boolean>(){

            public Boolean perform() {
                return DefaultGroupManager.this.groups.containsEntry((Object)DefaultGroupManager.this.group, (Object)address);
            }
        }, new Handler<AsyncResult<Boolean>>(){

            public void handle(AsyncResult<Boolean> result) {
                if (result.failed()) {
                    message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                } else if (!((Boolean)result.result()).booleanValue()) {
                    message.reply(new JsonObject().putString("status", "error").putString("message", "Invalid node."));
                } else {
                    message.reply(new JsonObject().putString("status", "ok").putString("result", address));
                }
            }
        });
    }

    private void doList(Message<JsonObject> message) {
        String type = ((JsonObject)message.body()).getString("type");
        if (type != null) {
            switch (type) {
                case "node": {
                    this.doListNode(message);
                    break;
                }
                default: {
                    message.reply(new JsonObject().putString("status", "error").putString("message", "Invalid type specified."));
                    break;
                }
            }
        } else {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No type specified."));
        }
    }

    private void doListNode(final Message<JsonObject> message) {
        this.context.execute(new Action<Collection<String>>(){

            public Collection<String> perform() {
                return DefaultGroupManager.this.groups.get((Object)DefaultGroupManager.this.group);
            }
        }, new Handler<AsyncResult<Collection<String>>>(){

            public void handle(AsyncResult<Collection<String>> result) {
                if (result.failed()) {
                    message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                } else if (result.result() == null) {
                    message.reply(new JsonObject().putString("status", "ok").putArray("result", new JsonArray()));
                } else {
                    message.reply(new JsonObject().putString("status", "ok").putArray("result", new JsonArray((Object[])((Collection)result.result()).toArray(new String[((Collection)result.result()).size()]))));
                }
            }
        });
    }

    private void doSelect(Message<JsonObject> message) {
        String type = ((JsonObject)message.body()).getString("type");
        if (type != null) {
            switch (type) {
                case "node": {
                    this.doSelectNode(message);
                    break;
                }
                default: {
                    message.reply(new JsonObject().putString("status", "error").putString("message", "Invalid type specified."));
                    break;
                }
            }
        } else {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No type specified."));
        }
    }

    private void doSelectNode(final Message<JsonObject> message) {
        final Object key = ((JsonObject)message.body()).getValue("key");
        if (key == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No key specified."));
        } else {
            this.context.execute(new Action<String>(){

                public String perform() {
                    String address = (String)DefaultGroupManager.this.nodeSelectors.get(key);
                    if (address != null) {
                        return address;
                    }
                    Collection nodes = DefaultGroupManager.this.groups.get((Object)DefaultGroupManager.this.group);
                    int index = new Random().nextInt(nodes.size());
                    int i = 0;
                    for (String node : nodes) {
                        if (i == index) {
                            DefaultGroupManager.this.nodeSelectors.put(key, node);
                            return node;
                        }
                        ++i;
                    }
                    return null;
                }
            }, new Handler<AsyncResult<String>>(){

                public void handle(AsyncResult<String> result) {
                    if (result.failed()) {
                        message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                    } else if (result.result() == null) {
                        message.reply(new JsonObject().putString("status", "error").putString("message", "No nodes to select."));
                    } else {
                        message.reply(new JsonObject().putString("status", "ok").putString("result", (String)result.result()));
                    }
                }
            });
        }
    }

    private void doDeploy(Message<JsonObject> message) {
        String type = ((JsonObject)message.body()).getString("type");
        if (type == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No deployment type specified."));
        } else {
            switch (type) {
                case "module": {
                    this.doDeployModule(message);
                    break;
                }
                case "verticle": {
                    this.doDeployVerticle(message);
                    break;
                }
                default: {
                    message.reply(new JsonObject().putString("status", "error").putString("message", "Invalid deployment type."));
                }
            }
        }
    }

    private void doDeployModule(final Message<JsonObject> message) {
        String moduleName = ((JsonObject)message.body()).getString("module");
        if (moduleName == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No module name specified."));
            return;
        }
        JsonObject config = ((JsonObject)message.body()).getObject("config");
        if (config == null) {
            config = new JsonObject();
        }
        int instances = ((JsonObject)message.body()).getInteger("instances", 1);
        this.platform.deployModule(moduleName, config, instances, new Handler<AsyncResult<String>>(){

            public void handle(AsyncResult<String> result) {
                if (result.failed()) {
                    message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                } else {
                    final String deploymentID = (String)result.result();
                    DefaultGroupManager.this.context.execute(new Action<String>(){

                        public String perform() {
                            DefaultGroupManager.this.deployments.put((Object)DefaultGroupManager.this.group, (Object)((JsonObject)message.body()).copy().putString("id", deploymentID).encode());
                            return deploymentID;
                        }
                    }, new Handler<AsyncResult<String>>(){

                        public void handle(AsyncResult<String> result) {
                            message.reply(new JsonObject().putString("status", "ok").putString("id", deploymentID));
                        }
                    });
                }
            }
        });
    }

    private void doDeployVerticle(final Message<JsonObject> message) {
        String main = ((JsonObject)message.body()).getString("main");
        if (main == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No verticle main specified."));
            return;
        }
        JsonObject config = ((JsonObject)message.body()).getObject("config");
        if (config == null) {
            config = new JsonObject();
        }
        int instances = ((JsonObject)message.body()).getInteger("instances", 1);
        boolean worker = ((JsonObject)message.body()).getBoolean("worker", false);
        if (worker) {
            boolean multiThreaded = ((JsonObject)message.body()).getBoolean("multi-threaded", false);
            this.platform.deployWorkerVerticle(main, config, instances, multiThreaded, new Handler<AsyncResult<String>>(){

                public void handle(AsyncResult<String> result) {
                    if (result.failed()) {
                        message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                    } else {
                        final String deploymentID = (String)result.result();
                        DefaultGroupManager.this.context.execute(new Action<String>(){

                            public String perform() {
                                DefaultGroupManager.this.deployments.put((Object)DefaultGroupManager.this.group, (Object)((JsonObject)message.body()).copy().putString("id", deploymentID).encode());
                                return deploymentID;
                            }
                        }, new Handler<AsyncResult<String>>(){

                            public void handle(AsyncResult<String> result) {
                                message.reply(new JsonObject().putString("status", "ok").putString("id", deploymentID));
                            }
                        });
                        message.reply(new JsonObject().putString("status", "ok").putString("id", (String)result.result()));
                    }
                }
            });
        } else {
            this.platform.deployVerticle(main, config, instances, new Handler<AsyncResult<String>>(){

                public void handle(AsyncResult<String> result) {
                    if (result.failed()) {
                        message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                    } else {
                        final String deploymentID = (String)result.result();
                        DefaultGroupManager.this.context.execute(new Action<String>(){

                            public String perform() {
                                DefaultGroupManager.this.deployments.put((Object)DefaultGroupManager.this.group, (Object)((JsonObject)message.body()).copy().putString("id", deploymentID).encode());
                                return deploymentID;
                            }
                        }, new Handler<AsyncResult<String>>(){

                            public void handle(AsyncResult<String> result) {
                                message.reply(new JsonObject().putString("status", "ok").putString("id", deploymentID));
                            }
                        });
                        message.reply(new JsonObject().putString("status", "ok").putString("id", (String)result.result()));
                    }
                }
            });
        }
    }

    private void doUndeploy(Message<JsonObject> message) {
        String type = ((JsonObject)message.body()).getString("type");
        if (type == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No deployment type specified."));
        } else {
            switch (type) {
                case "module": {
                    this.doUndeployModule(message);
                    break;
                }
                case "verticle": {
                    this.doUndeployVerticle(message);
                    break;
                }
                default: {
                    message.reply(new JsonObject().putString("status", "error").putString("message", "Invalid deployment type " + type));
                }
            }
        }
    }

    private void doUndeployModule(final Message<JsonObject> message) {
        final String deploymentID = ((JsonObject)message.body()).getString("id");
        if (deploymentID == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No deployment ID specified."));
        } else {
            this.removeDeployment(deploymentID, new Handler<AsyncResult<Void>>(){

                public void handle(AsyncResult<Void> result) {
                    DefaultGroupManager.this.platform.undeployModule(deploymentID, new Handler<AsyncResult<Void>>(){

                        public void handle(AsyncResult<Void> result) {
                            if (result.failed()) {
                                message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                            } else {
                                message.reply(new JsonObject().putString("status", "ok"));
                            }
                        }
                    });
                }
            });
        }
    }

    private void doUndeployVerticle(final Message<JsonObject> message) {
        final String deploymentID = ((JsonObject)message.body()).getString("id");
        if (deploymentID == null) {
            message.reply(new JsonObject().putString("status", "error").putString("message", "No deployment ID specified."));
        } else {
            this.removeDeployment(deploymentID, new Handler<AsyncResult<Void>>(){

                public void handle(AsyncResult<Void> result) {
                    DefaultGroupManager.this.platform.undeployVerticle(deploymentID, new Handler<AsyncResult<Void>>(){

                        public void handle(AsyncResult<Void> result) {
                            if (result.failed()) {
                                message.reply(new JsonObject().putString("status", "error").putString("message", result.cause().getMessage()));
                            } else {
                                message.reply(new JsonObject().putString("status", "ok"));
                            }
                        }
                    });
                }
            });
        }
    }

    private void removeDeployment(final String deploymentID, Handler<AsyncResult<Void>> doneHandler) {
        this.context.execute(new Action<Void>(){

            public Void perform() {
                Collection groupDeployments = DefaultGroupManager.this.deployments.get((Object)DefaultGroupManager.this.group);
                if (groupDeployments != null) {
                    String deployment = null;
                    for (String sdeployment : groupDeployments) {
                        JsonObject info = new JsonObject(sdeployment);
                        if (!info.getString("id").equals(deploymentID)) continue;
                        deployment = sdeployment;
                        break;
                    }
                    if (deployment != null) {
                        DefaultGroupManager.this.deployments.remove((Object)DefaultGroupManager.this.group, deployment);
                    }
                }
                return null;
            }
        }, doneHandler);
    }
}

