/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.vertigo.cluster.manager.impl;

import com.hazelcast.config.MapConfig;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import net.kuujo.vertigo.cluster.manager.impl.ClusterListener;
import net.kuujo.vertigo.cluster.manager.impl.HazelcastClusterListener;
import net.kuujo.vertigo.cluster.manager.impl.NoClusterListener;
import org.vertx.java.core.Vertx;

class ClusterListenerFactory {
    private final Vertx vertx;

    ClusterListenerFactory(Vertx vertx) {
        this.vertx = vertx;
    }

    static HazelcastInstance getHazelcastInstance() {
        for (HazelcastInstance instance : Hazelcast.getAllHazelcastInstances()) {
            MapConfig map = instance.getConfig().findMapConfig("subs");
            if (map == null || !map.getName().equals("subs")) continue;
            return instance;
        }
        return null;
    }

    public ClusterListener createClusterListener() {
        HazelcastInstance hazelcast = ClusterListenerFactory.getHazelcastInstance();
        if (hazelcast != null) {
            return new HazelcastClusterListener(hazelcast, this.vertx);
        }
        return new NoClusterListener();
    }
}

